/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.xml;

public class ByteStringConverter {
    private static final char MIN_HEX_CHAR = 'A';
    private static final char MAX_HEX_CHAR = 'P';
    private static final int HEX_MASK = 15;

    public static final String getStringFromBytes(byte[] bytes) {
        int length = bytes.length;
        if (length == 0) {
            return "";
        }
        int charsLength = length << 1;
        char[] chars = new char[charsLength];
        int byteIndex = 0;
        int charIndex = 0;
        do {
            byte b = bytes[byteIndex++];
            int lowFour = b & 0xF;
            int hiFour = b >> 4 & 0xF;
            char loChar = (char)(65 + lowFour);
            char hiChar = (char)(65 + hiFour);
            chars[charIndex++] = hiChar;
            chars[charIndex++] = loChar;
        } while (byteIndex < length);
        return new String(chars);
    }

    public static final byte[] getBytesFromString(String encodedString) {
        int length = encodedString.length();
        if (length == 0) {
            return new byte[0];
        }
        char[] chars = encodedString.toCharArray();
        int bytesLength = chars.length >>> 1;
        byte[] bytes = new byte[bytesLength];
        int charIndex = 0;
        int byteIndex = 0;
        do {
            char hiChar = chars[charIndex++];
            char loChar = chars[charIndex++];
            int hiFour = hiChar - 65;
            int loFour = loChar - 65;
            bytes[byteIndex++] = (byte)((hiFour << 4) + loFour);
        } while (charIndex < chars.length);
        return bytes;
    }
}

