/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.xml;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;
import com.sonicsw.mf.common.xml.ErrorHandlerImpl;
import com.sonicsw.mf.common.xml.XMLDocumentHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Validator {
    XMLReader m_saxReader = null;
    SAXParserFactory m_factory = null;
    XMLDocumentHandler m_saxEventHandler = null;
    IDirectoryAdminService m_dirService = null;
    ErrorHandlerImpl errHandler = null;
    Object xmlData = null;
    HashMap m_features = new HashMap(0);
    boolean m_keepElements = false;

    public Validator(Object xmlData) {
        try {
            this.xmlData = xmlData;
            this.m_factory = SAXParserFactory.newInstance();
            this.m_factory.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (Exception pce) {
            pce.printStackTrace();
        }
    }

    private void setDefaultFeatures() throws SAXException {
        this.m_saxReader.setFeature("http://xml.org/sax/features/validation", false);
    }

    private void setSpecifiedFeatures() throws SAXException {
        String fileURL = System.getProperty("sonicsw.mf.parserProps");
        if (fileURL == null) {
            return;
        }
        try {
            File f = new File(fileURL);
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = props.getProperty(key);
                    if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                        this.m_saxReader.setFeature(key, new Boolean(value));
                        continue;
                    }
                    this.m_saxReader.setProperty(key, value);
                }
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage(), ex);
        }
    }

    public void setKeepElements(boolean keep) {
        this.m_keepElements = keep;
    }

    public void resetXMLData(Object data) {
        this.xmlData = data;
    }

    public void setDirectoryService(IDirectoryAdminService dirService) {
        this.m_dirService = dirService;
    }

    public void createSAXParser() {
        try {
            SAXParser parser = this.m_factory.newSAXParser();
            ErrorHandlerImpl errHandler = new ErrorHandlerImpl();
            this.m_saxReader = parser.getXMLReader();
            this.m_saxReader.setErrorHandler(errHandler);
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
    }

    public void setContentHandler(String domainName) {
        block2: {
            this.m_saxEventHandler = new XMLDocumentHandler();
            this.m_saxEventHandler.setKeepElements(this.m_keepElements);
            this.m_saxReader.setContentHandler(this.m_saxEventHandler);
            try {
                this.m_saxReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.m_saxEventHandler);
            }
            catch (SAXException ex) {
                if (!(ex instanceof SAXNotRecognizedException)) break block2;
                ex.printStackTrace();
            }
        }
        this.m_saxEventHandler.setDirectoryService(this.m_dirService);
        this.m_saxEventHandler.setDomainName(domainName);
    }

    public XMLDocumentHandler getContentHandler() {
        return this.m_saxEventHandler;
    }

    public void setValidation(boolean validateUnused) {
        try {
            this.setDefaultFeatures();
            this.setSpecifiedFeatures();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void parseData() throws DirectoryServiceException, InvalidXMLException {
        try {
            if (this.xmlData instanceof String) {
                this.m_saxReader.parse((String)this.xmlData);
            } else {
                InputSource is = new InputSource((Reader)this.xmlData);
                this.m_saxReader.parse(is);
                ((Reader)this.xmlData).close();
            }
        }
        catch (SAXException ex) {
            String errorMsg = this.getErrorLocationString(ex) + ":" + ex.getMessage();
            throw new InvalidXMLException(errorMsg, (Throwable)ex);
        }
        catch (IOException io_ex) {
            throw new InvalidXMLException(io_ex.getMessage(), (Throwable)io_ex);
        }
    }

    private String getErrorLocationString(SAXException ex) {
        String retValue = "";
        if (ex instanceof SAXParseException) {
            StringBuffer str = new StringBuffer();
            String systemId = ((SAXParseException)ex).getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                str.append(systemId);
            }
            str.append("Line#:");
            str.append(((SAXParseException)ex).getLineNumber());
            str.append(" Column#:");
            str.append(((SAXParseException)ex).getColumnNumber());
            retValue = str.toString();
        }
        return retValue;
    }
}

