/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.IFaultTolerantState;
import com.sonicsw.mf.common.runtime.IStateController;
import com.sonicsw.mf.common.runtime.IStateListener;
import com.sonicsw.mf.common.runtime.NonRecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.RecoverableStateChangeException;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerFTConnectorClient;
import com.sonicsw.mf.framework.agent.ContainerFTStateListener;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.JMSConnectorServer;
import com.sonicsw.mf.framework.agent.PingThread;
import com.sonicsw.mf.framework.util.StateManager;
import java.io.IOException;
import javax.jms.Connection;
import javax.jms.JMSException;

class ContainerFT
extends StateManager {
    private ContainerImpl m_container;
    private JMSConnectorServer m_containerConnector;
    private String m_containerFTURLs;
    private String m_containerFTUser;
    private String m_containerFTPassword;
    private int m_containerFTConnectTimeout = 10;
    private long m_containerFTSocketConnectTimeout = 5000L;
    private ContainerFTConnectorClient m_containerFTConnector;
    private progress.message.jclient.Connection m_faultDetectionConnection = null;
    private String m_pingTopicForThisContainer;
    private String m_pingTopicForPeerContainer;
    private String m_role;
    private StateManager m_stateManager;
    private PingThread m_pingThread;
    private int m_faultDetectionInterval = 10;
    private int m_faultDetectionTimeout = 10;
    private boolean m_backupStartActive;
    public static final int CONNECT_TIMEOUT_DEFAULT = 10;
    public static final int CONNECT_TIMEOUT_MINIMUM = 10;
    public static final long SOCKET_CONNECT_TIMEOUT_DEFAULT = 5000L;
    public static final long SOCKET_CONNECT_TIMEOUT_MINIMUM = 0L;

    ContainerFT(ContainerImpl container, JMSConnectorServer containerConnector) throws JMSException, InterruptedException, IOException {
        super(IFaultTolerantState.STATE_VALUES, (short)1);
        this.m_container = container;
        this.m_containerConnector = containerConnector;
        this.init();
    }

    String getRole() {
        return this.m_role;
    }

    boolean isActive() {
        return this.m_stateManager.getState(null) == 2;
    }

    short getState() {
        return this.m_stateManager.getState(null);
    }

    PingThread getPingThread() {
        return this.m_pingThread;
    }

    private void init() throws JMSException, InterruptedException, IOException {
        IContainerIdentity containerIdentity = this.m_container.getContainerIdentity();
        String containerConfigIndentity = containerIdentity.getConfigIdentity().getName();
        IElement containerConfiguration = this.m_container.getConfiguration(containerConfigIndentity);
        IAttributeSet containerAttrs = containerConfiguration.getAttributes();
        IAttributeSet containerFTAttrs = (IAttributeSet)containerAttrs.getAttribute("FAULT_TOLERANCE_PARAMETERS");
        this.m_role = (String)containerFTAttrs.getAttribute("FAULT_TOLERANCE_ROLE");
        Reference peerContainerRef = (Reference)containerFTAttrs.getAttribute("FAULT_TOLERANCE_PEER_REF");
        String peerContainerConfigIndentity = peerContainerRef.getElementName();
        IElement peerContainerConfiguration = this.m_container.getConfiguration(peerContainerConfigIndentity);
        IAttributeSet peerContainerAttrs = peerContainerConfiguration.getAttributes();
        this.m_pingTopicForThisContainer = this.createPingTopic(containerAttrs);
        this.m_pingTopicForPeerContainer = this.createPingTopic(peerContainerAttrs);
        this.setBackupStartActive((Boolean)containerFTAttrs.getAttribute("START_ACTIVE"));
        if (this.m_role.equals("BACKUP")) {
            containerFTAttrs = (IAttributeSet)peerContainerAttrs.getAttribute("FAULT_TOLERANCE_PARAMETERS");
        }
        this.setFaultDetectionInterval((Integer)containerFTAttrs.getAttribute("FAULT_DETECTION_INTERVAL"));
        this.setFaultDetectionTimeout((Integer)containerFTAttrs.getAttribute("FAULT_DETECTION_TIMEOUT"));
        this.m_container.logMessage(null, IContainer.NEWLINE + IContainer.NEWLINE + '\t' + "FT container role \"" + this.m_role + "\"." + IContainer.NEWLINE, 4);
        this.initStateManagement();
        this.initConnection(containerFTAttrs);
    }

    int getFaultDetectionInterval() {
        return this.m_faultDetectionInterval;
    }

    private void setFaultDetectionInterval(Integer faultDetectionInterval) {
        this.m_faultDetectionInterval = faultDetectionInterval == null ? 10 : faultDetectionInterval;
        if (this.m_pingThread != null) {
            this.m_pingThread.setPingInterval(this.m_faultDetectionInterval);
        }
    }

    private void setFaultDetectionTimeout(Integer faultDetectionTimeout) {
        this.m_faultDetectionTimeout = faultDetectionTimeout == null ? 10 : faultDetectionTimeout;
        if (this.m_pingThread != null) {
            this.m_pingThread.setPingTimeout(this.m_faultDetectionTimeout);
        }
    }

    private void setBackupStartActive(Boolean startActive) {
        this.m_backupStartActive = startActive == null ? false : startActive;
    }

    private String createPingTopic(IAttributeSet containerAttrs) {
        String containerName = (String)containerAttrs.getAttribute("CONTAINER_NAME");
        String domainName = (String)containerAttrs.getAttribute("DOMAIN_NAME");
        return "SonicMQ.mf.." + domainName + '.' + containerName + ".ping";
    }

    private void initStateManagement() {
        this.m_stateManager = new StateManager(IFaultTolerantState.STATE_VALUES, 1);
        this.m_container.logMessage(null, "FT container initial state: \"" + IFaultTolerantState.STATE_TEXT[this.m_stateManager.getState(null)] + '\"', 3);
        this.m_stateManager.registerStateListener((IStateListener)new ContainerFTStateListener(this.m_container), null);
        ToActiveController toActiveController = new ToActiveController();
        this.m_stateManager.registerStateController((IStateController)toActiveController, (short)1, (short)2, null);
        this.m_stateManager.registerStateController((IStateController)toActiveController, (short)3, (short)2, null);
        ActiveToStandbyController activeToStandbyController = new ActiveToStandbyController();
        this.m_stateManager.registerStateController((IStateController)activeToStandbyController, (short)2, (short)3, null);
        WaitingToStandbyController waitingToStandbyController = new WaitingToStandbyController();
        this.m_stateManager.registerStateController((IStateController)waitingToStandbyController, (short)1, (short)3, null);
    }

    private void initConnection(IAttributeSet containerFTAttrs) throws JMSException, InterruptedException, IOException {
        this.m_containerFTURLs = (String)containerFTAttrs.getAttribute("FAILURE_DETECTION_CONNECTIONURLS");
        this.m_containerFTUser = (String)containerFTAttrs.getAttribute("FAILURE_DETECTION_DEFAULT_USER");
        this.m_containerFTPassword = (String)containerFTAttrs.getAttribute("FAILURE_DETECTION_DEFAULT_PASSWORD");
        if (this.m_containerFTURLs != null) {
            Integer socketConnectTimeout;
            Integer connectTimeout = (Integer)containerFTAttrs.getAttribute("FAILURE_DETECTION_CONNECT_TIMEOUT");
            if (connectTimeout != null) {
                this.m_containerFTConnectTimeout = connectTimeout;
            }
            if (this.m_containerFTConnectTimeout < 10) {
                this.m_containerFTConnectTimeout = 10;
            }
            if ((socketConnectTimeout = (Integer)containerFTAttrs.getAttribute("FAILURE_DETECTION_SOCKET_CONNECT_TIMEOUT")) != null) {
                this.m_containerFTSocketConnectTimeout = socketConnectTimeout * 1000;
            }
            if (this.m_containerFTSocketConnectTimeout < 0L) {
                this.m_containerFTSocketConnectTimeout = 0L;
            }
            IContainerIdentity containerID = this.m_container.getContainerIdentity();
            String domainName = containerID.getDomainName();
            String containerName = containerID.getContainerName();
            this.m_containerFTConnector = new ContainerFTConnectorClient(this, domainName, containerName, this.m_role, this.m_containerFTURLs, this.m_containerFTUser, this.m_containerFTPassword, this.m_containerFTConnectTimeout, this.m_containerFTSocketConnectTimeout, this.m_faultDetectionTimeout);
        }
        this.setFaultDetectionConnection();
    }

    private void setFaultDetectionConnection() {
        try {
            if (this.m_containerFTConnector == null) {
                if (this.m_containerConnector.isConnected()) {
                    progress.message.jclient.Connection connection = (progress.message.jclient.Connection)this.m_containerConnector.getConnection();
                    this.setFaultDetectionConnection(connection);
                }
            } else if (this.m_containerFTConnector.isConnected()) {
                progress.message.jclient.Connection connection = this.m_containerFTConnector.getConnection();
                this.setFaultDetectionConnection(connection);
            }
        }
        catch (JMSException e) {
            this.m_container.logMessage(null, "Failed to set this FT container's fault detection connection, trace follows...", e, 1);
        }
    }

    private synchronized void setFaultDetectionConnection(progress.message.jclient.Connection connection) throws JMSException {
        if (this.m_pingThread != null && this.m_pingThread.getConnection() == connection) {
            return;
        }
        this.m_faultDetectionConnection = connection;
        this.cleanupPingThread();
        this.m_pingThread = new PingThread((Connection)this.m_faultDetectionConnection, this.m_pingTopicForThisContainer, this.m_pingTopicForPeerContainer, this.m_faultDetectionInterval, this.m_faultDetectionTimeout, this.m_role, this.m_backupStartActive, this.m_stateManager, this.m_container);
        this.m_pingThread.start();
    }

    void onReconnect() {
        this.setFaultDetectionConnection();
    }

    void onDisconnect() {
        if (this.m_containerFTConnector == null || !this.m_containerFTConnector.isConnected()) {
            this.cleanupPingThread();
        }
    }

    void onFailure(Exception e) {
        if (this.m_containerFTConnector == null || !this.m_containerFTConnector.isConnected()) {
            this.cleanupPingThread();
        }
    }

    private synchronized void cleanupPingThread() {
        if (this.m_pingThread != null) {
            this.m_pingThread.interrupt();
            this.m_pingThread = null;
        }
    }

    void handleChangeFTAttrs(IDeltaAttributeSet attrs) throws Exception {
        this.handleModifiedFTAttrs(attrs.getNewAttributesNames(), attrs);
        this.handleModifiedFTAttrs(attrs.getModifiedAttributesNames(), attrs);
        this.handleDeletedFTAttrs(attrs.getDeletedAttributesNames());
    }

    void handleModifiedFTAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equals("FAULT_DETECTION_INTERVAL")) {
                this.setFaultDetectionInterval((Integer)attrs.getNewValue(names[i]));
                continue;
            }
            if (!names[i].equals("FAULT_DETECTION_TIMEOUT")) continue;
            this.setFaultDetectionTimeout((Integer)attrs.getNewValue(names[i]));
        }
    }

    void handleDeletedFTAttrs(String[] names) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equals("FAULT_DETECTION_INTERVAL")) {
                this.setFaultDetectionInterval(new Integer(10));
                continue;
            }
            if (!names[i].equals("FAULT_DETECTION_TIMEOUT")) continue;
            this.setFaultDetectionTimeout(new Integer(10));
        }
    }

    public void logMessage(String message, int severity) {
        this.m_container.logMessage(null, message, severity);
    }

    public void logMessage(String message, Throwable e, int severity) {
        this.m_container.logMessage(null, message, e, severity);
    }

    public int getTraceMask() {
        return this.m_container.m_agent.getTraceMask();
    }

    private class WaitingToStandbyController
    implements IStateController {
        private WaitingToStandbyController() {
        }

        public boolean changeState() {
            return true;
        }
    }

    private class ActiveToStandbyController
    implements IStateController {
        private ActiveToStandbyController() {
        }

        public boolean changeState() {
            ContainerFT.this.m_container.stopComponents();
            return true;
        }
    }

    private class ToActiveController
    implements IStateController {
        private ToActiveController() {
        }

        public boolean changeState() throws NonRecoverableStateChangeException, RecoverableStateChangeException {
            ContainerFT.this.m_container.startComponents();
            return true;
        }
    }
}

