/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.cache.impl;

import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.framework.agent.cache.PersistentCacheException;
import com.sonicsw.mf.framework.directory.storage.StorageException;
import com.sonicsw.mf.framework.directory.storage.fs.FSStorage;
import java.io.File;

public class PersistentBlobCache {
    private FSStorage m_storage;
    private boolean DEBUG = false;

    PersistentBlobCache(String hostDirName, String domainName, String dataDirName, String password, boolean doSync) throws StorageException, PersistentCacheException {
        this.m_storage = new FSStorage(hostDirName, domainName, dataDirName, password, false);
    }

    public synchronized File blobToFile(EntityName elementName) {
        return this.m_storage.blobToFile(elementName);
    }

    public synchronized void appendBlob(EntityName blobName, byte[] blob, int blobOff, int blobLen, int src) throws StorageException, PersistentCacheException {
        if (this.DEBUG) {
            System.out.println("PersistentBlobCache.appendBlob " + blobName.getName());
        }
        this.m_storage.appendBlob(blobName, blob, blobOff, blobLen, src);
    }

    public synchronized void deleteBlob(EntityName blobName) throws StorageException, PersistentCacheException {
        if (this.DEBUG) {
            System.out.println("PersistentBlobCache.deleteBlob " + blobName.getName());
        }
        this.m_storage.deleteBlob(blobName);
    }
}

