/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.framework.agent.ClassLoaderFactory;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.ExpandedSonicArchive;
import com.sonicsw.mf.framework.agent.LocalFileManager;
import com.sonicsw.mf.framework.agent.cache.ConfigCacheFactory;
import com.sonicsw.mf.framework.agent.cache.IConfigCache;
import com.sonicsw.mf.framework.agent.cache.IConfigCacheView;
import com.sonicsw.mf.framework.agent.ci.WinServiceUpdate;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;

public final class Agent {
    private static final String UTIL_DLL_FILE_32 = "sonicmfUtil.dll";
    private static final String UTIL_DLL_FILE_64 = "sonicmfUtil64.dll";
    private static final boolean RUNNING_AS_WINSERVICE = System.getProperty("sonicsw.mf.winsvc.utilDir") != null;
    private static int m_exitCode = 0;
    private static Object m_containerExitCode;
    private static Class m_exitCodeClass;

    private static native void ignoreLogoffEvent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(final String[] args) {
        try {
            int exitCode;
            String winsvcUtilDir;
            if (args.length < 3) {
                throw new IllegalArgumentException("Invalid number of arguments: " + args.length);
            }
            if (args[0].length() == 0) {
                throw new IllegalArgumentException("<cacheDir> cannot be zero length");
            }
            if (args[1].length() == 0) {
                throw new IllegalArgumentException("<containerName> cannot be zero length");
            }
            if (args[2].length() == 0) {
                throw new IllegalArgumentException("<containerConfigID> cannot be zero length");
            }
            if (!new File(args[0]).exists()) {
                throw new IllegalArgumentException(args[0] + " does not exist");
            }
            if (Boolean.getBoolean("sonicsw.mf.launcher_upgrade_restart")) {
                if (RUNNING_AS_WINSERVICE) {
                    WinServiceUpdate.startWinserviceUpdateProcess(args[1]);
                    System.exit(0);
                }
                System.exit(14);
            }
            if ((winsvcUtilDir = System.getProperty("sonicsw.mf.winsvc.utilDir")) != null && (winsvcUtilDir = winsvcUtilDir.trim()).length() > 0) {
                String winsvcUtilLib = winsvcUtilDir + File.separatorChar;
                winsvcUtilLib = winsvcUtilLib + (System.getProperty("os.arch").toLowerCase(Locale.US).equals("amd64") ? UTIL_DLL_FILE_64 : UTIL_DLL_FILE_32);
                System.load(winsvcUtilLib);
                Agent.ignoreLogoffEvent();
            }
            StringTokenizer containerNameTokens = new StringTokenizer(args[1], ",");
            StringTokenizer containerConfigIDTokens = new StringTokenizer(args[2], ",");
            if (containerNameTokens.countTokens() > 1) {
                System.setProperty("sonicsw.mf.lsd.colocate", "true");
                System.setProperty("sonicsw.mf.lsd.colocate.count", "0");
            }
            while (containerNameTokens.hasMoreTokens()) {
                final String containerName = containerNameTokens.nextToken();
                final String containerConfigID = containerConfigIDTokens.nextToken();
                Runnable agent = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new Agent(args[0], containerName, containerConfigID);
                        }
                        catch (Throwable e) {
                            Agent.startupAbort(e);
                        }
                    }
                };
                Thread startupThread = new Thread(agent);
                if (System.getProperty("sonicsw.mf.cacheGeneration.url") == null) {
                    startupThread.setName("Container boot thread [" + containerName + "]");
                } else {
                    startupThread.setName("Cache generation thread [" + containerName + "]");
                }
                Runtime runtime = Runtime.getRuntime();
                synchronized (runtime) {
                    String containerCount = System.getProperty("sonicsw.mf.lsd.colocate.count");
                    if (containerCount != null) {
                        System.setProperty("sonicsw.mf.lsd.colocate.count", new Integer(Integer.parseInt(containerCount) + 1).toString());
                    }
                }
                startupThread.start();
                startupThread.join();
            }
            Object object = m_containerExitCode;
            synchronized (object) {
                while (!Agent.isExit()) {
                    m_containerExitCode.wait();
                }
                exitCode = Agent.getExitCode();
            }
            System.exit(exitCode);
        }
        catch (Throwable e) {
            Agent.startupAbort(e);
        }
    }

    static boolean isExit() {
        try {
            Method isExitCode = m_exitCodeClass.getMethod("exit", new Class[0]);
            Boolean exitFlag = (Boolean)isExitCode.invoke(m_containerExitCode, new Object[0]);
            return exitFlag;
        }
        catch (Exception e) {
            return true;
        }
    }

    private static int getExitCode() {
        try {
            Method getExitCode = m_exitCodeClass.getMethod("getExitCode", new Class[0]);
            Integer exitCode = (Integer)getExitCode.invoke(m_containerExitCode, new Object[0]);
            return exitCode;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private static void startupAbort(Throwable e) {
        e.printStackTrace();
        if (e instanceof IllegalArgumentException) {
            Agent.printUsage();
        }
        if (Boolean.getBoolean("sonicsw.mf.signal")) {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        m_exitCode = e instanceof IllegalArgumentException ? 2 : 1;
        try {
            Method setExitCode = m_exitCodeClass.getMethod("setExitCode", Integer.class);
            setExitCode.invoke(m_containerExitCode, new Integer(m_exitCode));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        System.exit(m_exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent(String cacheDirectory0, String containerName, String containerConfigID) throws Throwable {
        File archiveRoot = null;
        String classpath = null;
        Long maxCacheSize = null;
        IConfigCache configCache = null;
        String cacheDirectory = Boolean.getBoolean("sonicsw.mf.lsd.colocate") ? new File(new File(cacheDirectory0).getParentFile(), containerName + ".cache").getAbsolutePath() : cacheDirectory0;
        try {
            String password = ContainerUtil.retrieveCachePassword(new File(cacheDirectory), false);
            configCache = ConfigCacheFactory.createCache(cacheDirectory, password);
            IConfigCacheView configCacheView = configCache.getCacheView();
            IElement containerConfig = configCacheView.getElement(containerConfigID);
            if (containerConfig == null) {
                throw new IllegalArgumentException(containerConfig + " does not exist in cache");
            }
            IAttributeSet containerAttrs = containerConfig.getAttributes();
            String containerArchive = (String)containerAttrs.getAttribute("ARCHIVE_NAME");
            String searchPath = (String)containerAttrs.getAttribute("ARCHIVE_SEARCH_PATH");
            IAttributeSet cacheAttrs = (IAttributeSet)containerAttrs.getAttribute("CACHE");
            if (cacheAttrs != null) {
                maxCacheSize = (Long)cacheAttrs.getAttribute("PERSISTENT_BLOB_CACHE_SIZE");
            }
            classpath = System.getProperty("sonicsw.mf.containerClasspath", "");
            archiveRoot = new LocalFileManager(null, configCache, null, null).getLocalFile(searchPath, containerArchive);
            System.setProperty("sonicsw.mf.container_archive_root", archiveRoot.getAbsolutePath());
        }
        finally {
            if (configCache != null) {
                try {
                    configCache.close();
                }
                catch (Exception e) {}
            }
        }
        ExpandedSonicArchive archive = new ExpandedSonicArchive(archiveRoot);
        ClassLoader containerClassLoader = this.createClassLoaderGraph(containerName, archive, classpath);
        try {
            Thread.currentThread().setContextClassLoader(containerClassLoader);
            Class<?> containerClass = containerClassLoader.loadClass("com.sonicsw.mf.framework.agent.ContainerImpl");
            Class<?> exitCodeClass = containerClassLoader.loadClass("com.sonicsw.mf.framework.agent.ContainerExitCode");
            Constructor<?> exitCodeConstructor = exitCodeClass.getConstructor(new Class[0]);
            Object containerExitCode = exitCodeConstructor.newInstance(new Object[0]);
            Class<Agent> e = Agent.class;
            synchronized (Agent.class) {
                m_exitCodeClass = exitCodeClass;
                m_containerExitCode = containerExitCode;
                // ** MonitorExit[e] (shouldn't be in output)
                Constructor<?> containerConstructor = containerClass.getConstructor(ClassLoader.class, String.class, String.class, String.class, Long.class, Object.class);
                containerConstructor.newInstance(containerClassLoader, cacheDirectory, containerName, containerConfigID, maxCacheSize, containerExitCode);
            }
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private ClassLoader createClassLoaderGraph(String containerName, ExpandedSonicArchive archive, String classpath) throws Exception {
        URL[] urls = ClassLoaderFactory.prependClasspath(classpath, archive.getGlobalClasspath());
        URLClassLoader globalClassLoader = ClassLoaderFactory.createGlobalLoader(containerName, urls, ClassLoader.getSystemClassLoader().getParent());
        HashMap<String, ClassLoader> sharedLibraryClassLoaders = new HashMap<String, ClassLoader>();
        String[] sharedLibraryNames = archive.getSharedLibraryNames();
        for (int i = 0; i < sharedLibraryNames.length; ++i) {
            ClassLoader sharedLoader = ClassLoaderFactory.createDelegateLoader(containerName, null, sharedLibraryNames[i], archive.getSharedLibraryClasspath(sharedLibraryNames[i]), globalClassLoader);
            sharedLibraryClassLoaders.put(sharedLibraryNames[i], sharedLoader);
            ClassLoaderFactory.addDelegateLoader(containerName, "AGENT", sharedLibraryNames[i], sharedLoader);
        }
        ClassLoader privateClassLoader = ClassLoaderFactory.createDelegatingLoader(containerName, "AGENT", archive.getPrivateClasspath(), globalClassLoader, sharedLibraryNames);
        Class<?> classLoaderFactoryClass = privateClassLoader.loadClass(ClassLoaderFactory.class.getName());
        Field classLoaderFactoryClassField = classLoaderFactoryClass.getField("m_classLoaderFactoryClass");
        ClassLoaderFactory.m_classLoaderFactoryClass = (Class)classLoaderFactoryClassField.get(null);
        Method setGlobalLoaderMethod = classLoaderFactoryClass.getMethod("setGlobalLoader", URLClassLoader.class);
        setGlobalLoaderMethod.invoke(null, globalClassLoader);
        Method addDelegateLoaderMethod = classLoaderFactoryClass.getMethod("addDelegateLoader", String.class, String.class, String.class, ClassLoader.class);
        for (int i = 0; i < sharedLibraryNames.length; ++i) {
            addDelegateLoaderMethod.invoke(null, containerName, null, sharedLibraryNames[i], (ClassLoader)sharedLibraryClassLoaders.get(sharedLibraryNames[i]));
        }
        Method addDelegatingLoaderMethod = classLoaderFactoryClass.getMethod("addDelegatingLoader", String.class, String.class, String[].class, ClassLoader.class);
        addDelegatingLoaderMethod.invoke(null, containerName, "AGENT", sharedLibraryNames, privateClassLoader);
        return privateClassLoader;
    }

    private static void printUsage() {
        System.err.println();
        System.err.println("Starts a manageable container.");
        System.err.println();
        System.err.println("Usage: <java> <java_params> [-Dsonicsw.mf.password=<password>] com.sonicsw.mf.Agent <cacheDir> <containerName> <containerConfigID>");
        System.err.println();
        System.err.println("  <cacheDir>          The path to the directory containing the cache");
        System.err.println("  <containerName>     The fully qualified name of the container (e.g.");
        System.err.println("                      \"Domain1.Container1\").");
        System.err.println("  <containerConfigID> The internal configuration identity of the container.");
        System.err.println();
        System.err.println("  <password>          Password to decrypt disk based configuration information.");
        System.err.flush();
    }
}

