/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.framework.agent.ExpandedSonicArchive;
import java.io.File;
import java.net.URL;

public final class CARClasspath {
    String[] m_launchClasspathItems;
    String[] m_bootClasspathItems;
    String[] m_bootAppendClasspathItems;
    String[] m_bootPrependClasspathItems;

    public CARClasspath(File archiveFile) throws Exception {
        ExpandedSonicArchive expandedArchive = new ExpandedSonicArchive(archiveFile);
        this.m_launchClasspathItems = CARClasspath.getFileNames(expandedArchive.getLaunchClasspath());
        this.m_bootClasspathItems = CARClasspath.getFileNames(expandedArchive.getBootClasspath());
        this.m_bootAppendClasspathItems = CARClasspath.getFileNames(expandedArchive.getBootAppendClasspath());
        this.m_bootPrependClasspathItems = CARClasspath.getFileNames(expandedArchive.getBootPrependClasspath());
    }

    public String[] getLaunchClasspath() {
        return this.m_launchClasspathItems;
    }

    String[] getBootClasspath() {
        return this.m_bootClasspathItems;
    }

    String[] getBootAppendClasspath() {
        return this.m_bootAppendClasspathItems;
    }

    String[] getBootPrependClasspath() {
        return this.m_bootPrependClasspathItems;
    }

    private static String[] getFileNames(URL[] classpath) {
        String[] fileNames = new String[classpath.length];
        for (int i = 0; i < classpath.length; ++i) {
            char leadingChar;
            String path = classpath[i].getPath();
            if (File.separatorChar == '\\' && (leadingChar = path.charAt(0)) == '/') {
                path = path.substring(1);
            }
            fileNames[i] = path;
        }
        return fileNames;
    }
}

