/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ci.AbstractContainerProcess;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

final class ContainerProcess
extends AbstractContainerProcess {
    ContainerProcess(ArrayList execCommand, String containerName, String workingDir, ILogger logger) throws Exception {
        this.m_logger = logger;
        this.m_outputString = "";
        this.m_errorString = "";
        this.setRunning(false);
        this.m_containerName = containerName;
        this.m_execCommand = execCommand;
        this.m_workDir = new File(workingDir);
        if (!this.m_workDir.exists()) {
            throw new Exception("Working directory \"" + this.m_workDir.getAbsolutePath() + "\" does not exist.");
        }
    }

    @Override
    protected void exec() throws Exception {
        this.m_containerProcess = Runtime.getRuntime().exec(this.m_execCommand.toArray(EMPTY_STRING_ARRAY), null, this.m_workDir);
        this.setRunning(true);
        new OutputReader(1, "Standard Output", this.m_containerProcess.getInputStream()).start();
        new OutputReader(2, "Standard Error", this.m_containerProcess.getErrorStream()).start();
    }

    private final class OutputReader
    extends Thread {
        InputStream m_stream;
        String m_threadName;
        int m_outputType;

        private OutputReader(int outputType, String threadName, InputStream stream) {
            super(threadName);
            this.m_outputType = outputType;
            this.setDaemon(true);
            this.m_threadName = threadName;
            this.m_stream = stream;
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_stream));
            while (ContainerProcess.this.isRunning()) {
                try {
                    String input = reader.readLine();
                    if (input == null) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (this.m_outputType == 1) {
                        ContainerProcess.this.m_outputString = ContainerProcess.this.m_outputString + input + IContainer.NEWLINE;
                        continue;
                    }
                    ContainerProcess.this.m_errorString = ContainerProcess.this.m_errorString + input + IContainer.NEWLINE;
                }
                catch (IOException e) {
                    ContainerProcess.this.logMessage(ContainerProcess.this.m_containerName + ": Failed to record " + this.m_threadName + ", trace follows...", e, 2);
                    break;
                }
            }
        }
    }
}

