/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.framework.agent.LocalFileManager;
import java.util.ArrayList;
import java.util.StringTokenizer;

final class DSClasspath {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private String[] m_resources;
    private String[] m_substitutedResources;
    private String[] m_sonicfsResources;
    private int[] m_sonicfsMarkes;
    private ILogger m_logger;

    DSClasspath(String classpath, ILogger logger) throws Exception {
        this.m_logger = logger;
        ArrayList<String> resources = new ArrayList<String>();
        ArrayList<String> sonicfsResources = new ArrayList<String>();
        ArrayList<Integer> markers = new ArrayList<Integer>();
        if (classpath == null) {
            this.m_resources = EMPTY_STRING_ARRAY;
            this.m_sonicfsMarkes = EMPTY_INT_ARRAY;
            this.m_sonicfsResources = EMPTY_STRING_ARRAY;
            return;
        }
        StringTokenizer st = new StringTokenizer(classpath, ";");
        int count = 0;
        while (st.hasMoreTokens()) {
            String cpItem = LocalFileManager.substituteSonicHome(st.nextToken());
            String path = this.getSonicfsPath(cpItem);
            if (path == null) {
                resources.add(cpItem);
            } else {
                resources.add(path);
                sonicfsResources.add(path);
                markers.add(new Integer(count));
            }
            ++count;
        }
        this.m_resources = resources.toArray(EMPTY_STRING_ARRAY);
        this.m_sonicfsResources = sonicfsResources.toArray(EMPTY_STRING_ARRAY);
        this.m_sonicfsMarkes = new int[markers.size()];
        for (int i = 0; i < this.m_sonicfsMarkes.length; ++i) {
            this.m_sonicfsMarkes[i] = (Integer)markers.get(i);
        }
    }

    String[] getResources() {
        return this.m_resources;
    }

    String[] getSonicfsResources() {
        return this.m_sonicfsResources;
    }

    String[] getSubstitutedResources() {
        return this.m_substitutedResources;
    }

    void substituteSonicfsResources(String[] substitutes) {
        this.m_substitutedResources = new String[this.m_resources.length];
        int indx = 0;
        for (int i = 0; i < this.m_resources.length; ++i) {
            this.m_substitutedResources[i] = indx < this.m_sonicfsMarkes.length && this.m_sonicfsMarkes[indx] == i ? substitutes[indx++] : this.m_resources[i];
        }
    }

    private String getSonicfsPath(String sonicfsPath) throws Exception {
        String dsClasspathPrefix = "sonicfs:///".substring(0, "sonicfs:///".length() - 1);
        if (sonicfsPath.length() > dsClasspathPrefix.length() && sonicfsPath.substring(0, dsClasspathPrefix.length()).equalsIgnoreCase(dsClasspathPrefix)) {
            if (sonicfsPath.charAt(dsClasspathPrefix.length()) != '/') {
                this.logMessage("Classpath contains an invalid URL: " + sonicfsPath, 1);
                return null;
            }
            return sonicfsPath.substring("sonicfs:///".length() - 1);
        }
        return null;
    }

    void logMessage(String message, int severityLevel) {
        this.m_logger.logMessage(message, severityLevel);
    }

    void logMessage(String message, Throwable t, int severityLevel) {
        this.m_logger.logMessage(message, t, severityLevel);
    }
}

