/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.comm.ConnectTimeoutException;
import com.sonicsw.mf.comm.IConnectorClient;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.comm.jms.ConnectorClient;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.cache.CacheIsLocked;
import com.sonicsw.mf.framework.agent.ci.Agent;
import com.sonicsw.mf.framework.agent.ci.CILogger;
import com.sonicsw.mf.framework.agent.ci.ConfigureFromCacheException;
import com.sonicsw.mf.framework.agent.ci.ContainerProcess;
import com.sonicsw.mf.framework.agent.ci.DeployContainerResources;
import com.sonicsw.mf.framework.agent.ci.GeneratePlatformArguments;
import com.sonicsw.mf.framework.agent.ci.HostHelper;
import com.sonicsw.mf.framework.agent.ci.LaunchConnector;
import com.sonicsw.mf.framework.agent.ci.LauncherFilesInstaller;
import com.sonicsw.mf.framework.agent.ci.LauncherJARBuilder;
import com.sonicsw.mf.framework.agent.ci.StartContainerCommand;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.JMRuntimeException;

public final class LaunchContainer {
    static final int CONTAINER_LAUNCH_TRACE_MASK = 4096;
    private static final String DEFAULT_JVM_HOME = System.getProperty("java.home");
    private static boolean ON_WINDOWS = File.separatorChar == '\\';
    private static final String SET_VERSION_SCRIPT_NAME = "set_launcher_version";
    private static boolean BAT_LAUNCH_SCRIPT;
    private static final String SUN_PATH = "LD_LIBRARY_PATH";
    private static final String LINUX_PATH = "LD_LIBRARY_PATH";
    private static final String HP_PATH = "SHLIB_PATH";
    private static final String AIX_PATH = "LIBPATH";
    private static final String WINDOWS_PATH = "PATH";
    private static final String DEFAULT_PATH = "LD_LIBRARY_PATH";
    private static final String PATH_VAR_NAME;
    private Object m_shutdownThreadLockObj = new Object();
    private boolean m_shutdownRequested;
    ILogger m_logger;
    String m_launchScriptPath;

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            LaunchContainer.printUsage();
            System.exit(2);
        }
        String bootFileNames = args[0];
        String dsBootFileName = null;
        if (args.length > 1) {
            dsBootFileName = args[1];
        }
        new LaunchContainer().deployAndStart(bootFileNames, dsBootFileName, true);
        if (!System.getProperty("sonicsw.mf.devSingleJVM", "false").equals("true")) {
            Runtime.getRuntime().halt(0);
        }
    }

    private static String getPathVarName() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (ON_WINDOWS) {
            return WINDOWS_PATH;
        }
        if (osName.indexOf("sunos") != -1) {
            return "LD_LIBRARY_PATH";
        }
        if (osName.indexOf("linux") != -1) {
            return "LD_LIBRARY_PATH";
        }
        if (osName.indexOf("hp") != -1) {
            return HP_PATH;
        }
        if (osName.indexOf("aix") != -1) {
            return AIX_PATH;
        }
        return "LD_LIBRARY_PATH";
    }

    private static String appendPathLine(String path) {
        if (BAT_LAUNCH_SCRIPT) {
            return "set PATH=" + path + File.pathSeparatorChar + "%PATH%";
        }
        return PATH_VAR_NAME + "=\"$" + PATH_VAR_NAME + File.pathSeparatorChar + path + "\"; export " + PATH_VAR_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deployAndStart(String bootFileNames, String dsBootFileName, boolean generateScriptOnly) {
        if (generateScriptOnly) {
            String scriptExtension = BAT_LAUNCH_SCRIPT ? ".bat" : ".sh";
            this.m_launchScriptPath = bootFileNames.indexOf(44) > -1 || bootFileNames.equals("*.xml") ? "default" + scriptExtension : bootFileNames + scriptExtension;
            new File(this.m_launchScriptPath).delete();
        }
        ArrayList<String> bootfiles = new ArrayList<String>();
        if (bootFileNames.equals("*.xml")) {
            File workingDir = new File(".");
            String[] bootfileList = workingDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            for (int i = 0; i < bootfileList.length; ++i) {
                bootfiles.add(bootfileList[i]);
            }
        } else {
            StringTokenizer bootFileTokens = new StringTokenizer(bootFileNames, ",");
            while (bootFileTokens.hasMoreTokens()) {
                bootfiles.add(bootFileTokens.nextToken());
            }
        }
        if (bootfiles.size() > 1) {
            System.setProperty("sonicsw.mf.lsd.colocate", "true");
        }
        DeployContainerResources[] deployments = new DeployContainerResources[bootfiles.size()];
        Iterator bootfileIterator = bootfiles.iterator();
        String originalThreadName = Thread.currentThread().getName();
        try {
            for (int i = 0; i < deployments.length; ++i) {
                String bootFileName = (String)bootfileIterator.next();
                if (bootfiles.size() > 1) {
                    Thread.currentThread().setName(originalThreadName + " [" + bootFileName + "]");
                }
                try {
                    block40: {
                        deployments[i] = new DeployContainerResources(dsBootFileName);
                        this.m_logger = deployments[i].getLogger();
                        deployments[i].init(bootFileName);
                        try {
                            deployments[i].connectAndGetConfiguration();
                            deployments[i].deployResources();
                        }
                        catch (Throwable t) {
                            if (t instanceof JMRuntimeException && ((JMRuntimeException)t).getCause() instanceof ConnectTimeoutException) {
                                this.logMessage("Failed to refresh resources due to a connection timeout", 2);
                            }
                            if (t instanceof ProxyRuntimeException && t.getCause() != null) {
                                t = t.getCause();
                            }
                            if (t instanceof InvokeTimeoutCommsException) {
                                this.logMessage("Failed to refresh resources due to a connection timeout", 2);
                            }
                            if (t instanceof InvokeTimeoutException) {
                                this.logMessage("Failed to refresh resources due to a request timeout", 2);
                            }
                            if (t instanceof ConfigureFromCacheException) break block40;
                            this.logMessage("Failed to refresh resources, trace follows...", t, 2);
                        }
                    }
                    if (deployments[i].m_extractedConfig == null || deployments[i].m_logicalArchivePath == null) {
                        this.logMessage("Failed to start the container", 1);
                        LaunchContainer.releaseResources(deployments[i]);
                        System.exit(8);
                    }
                    if (deployments[i].m_useCachedConfig) {
                        this.logMessage("Using cached container configuration", Boolean.getBoolean("sonicsw.mf.configureFromCache") ? 3 : 2);
                    }
                    if (System.getProperty("sonicsw.mf.devSingleJVM", "false").equals("true")) {
                        String publicHost;
                        String privateHost;
                        LaunchContainer.releaseResources(deployments[i]);
                        ContainerUtil.storeCachePassword(new File(deployments[i].m_cacheHostDirectoryName), deployments[i].m_extractedConfig.m_cachePassword);
                        this.logMessage("System property \"sonicsw.mf.devSingleJVM=true\" - container will be started using launcher's JVM", 4);
                        boolean skipEC2 = Boolean.getBoolean("sonicsw.mf.skipEC2Checks");
                        boolean traceEC2 = Boolean.getBoolean("sonicsw.mf.traceEC2Checks");
                        int timeoutEC2 = Integer.getInteger("sonicsw.mf.timeoutEC2Checks", 2000);
                        HostHelper hostHelper = new HostHelper(this.m_logger, skipEC2, traceEC2, timeoutEC2);
                        if (System.getProperty("sonicsw.mf.privateHost") == null && (privateHost = hostHelper.getPrivateHost()) != null) {
                            System.setProperty("sonicsw.mf.privateHost", privateHost);
                        }
                        if (System.getProperty("sonicsw.mf.publicHost") == null && (publicHost = hostHelper.getPublicHost()) != null) {
                            System.setProperty("sonicsw.mf.publicHost", publicHost);
                        }
                        new Agent(deployments[i].m_cacheHostDirectoryName, deployments[i].m_containerName, deployments[i].m_containerID);
                        return;
                    }
                    if (i != deployments.length - 1) continue;
                    String upgradeVersion = null;
                    boolean dsFilesMissing = false;
                    if (deployments.length == 1 && generateScriptOnly) {
                        DeployContainerResources dcr = deployments[0];
                        dsFilesMissing = dcr.mfDSLaunchFilesMissing();
                        if (dcr.mfDirectoryJARMissing()) {
                            LauncherJARBuilder.createMFdirectoryJAR(dcr.getArchiveRoot(), dcr.getMFDirectory());
                            this.logMessage("...Missing \" " + dcr.getMFDirectory().getAbsolutePath() + "\" retrieved", 3);
                        }
                        LauncherFilesInstaller launcherInstaller = new LauncherFilesInstaller();
                        upgradeVersion = launcherInstaller.installLauncherFiles(dcr.getArchiveRoot());
                    }
                    String workingDir = deployments[deployments.length - 1].getWorkingDir();
                    StartContainerCommand startCommand = LaunchContainer.createStartCommand(deployments, bootFileName + ".plt", this.m_logger, generateScriptOnly, null, false, upgradeVersion != null || dsFilesMissing);
                    if (upgradeVersion != null) {
                        this.updateSetVersionScript(upgradeVersion);
                        this.logMessage("Upgrading the launcher to version " + upgradeVersion + " and restarting...", 3);
                    } else if (dsFilesMissing) {
                        this.logMessage("Restarting after retrieving missing Directory Service file(s)", 3);
                    } else {
                        this.logMessage("The container working directory is \"" + workingDir + '\"', 3);
                    }
                    if (generateScriptOnly) {
                        this.generateStartContainerScript(workingDir, startCommand.getCommandString(), startCommand.getNativePath());
                        if (!IContainer.SIGNAL_MODE) continue;
                        System.out.print("\u00070\u0007");
                        System.out.flush();
                        continue;
                    }
                    this.startContainer(deployments[i].getContainerName(), workingDir, startCommand.getCommandArray());
                    continue;
                }
                catch (Throwable t) {
                    int exitCode = t instanceof CacheIsLocked ? 13 : 15;
                    this.logMessage("", t, 1);
                    LaunchContainer.releaseResources(deployments);
                    if (IContainer.SIGNAL_MODE) {
                        System.out.print("\u0007" + exitCode + '\u0007');
                        System.out.flush();
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    System.exit(exitCode);
                    continue;
                }
                finally {
                    LaunchContainer.releaseResources(deployments[i]);
                }
            }
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
            if (this.m_logger != null && this.m_logger instanceof CILogger) {
                ((CILogger)this.m_logger).close();
            }
        }
    }

    private void updateSetVersionScript(String carVersion) throws IOException {
        if (ON_WINDOWS) {
            StringBuffer sb = new StringBuffer();
            sb.append("set SONIC_LAUNCHER_VERSION=").append(carVersion);
            this.createScript("set_launcher_version.bat", sb.toString());
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("#!/bin/sh").append("\n");
            sb.append("SONIC_LAUNCHER_VERSION=").append(carVersion);
            this.createScript("set_launcher_version.sh", sb.toString());
        }
    }

    private void createScript(String scriptPath, String text) throws IOException {
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(scriptPath, false)), true);
        writer.println(text);
        writer.close();
    }

    private static StartContainerCommand createStartCommand(DeployContainerResources[] deployments, String platformArgsFile, ILogger logger, boolean generateScriptOnly, HashMap additionalProps, boolean specifyLibPath, boolean doRestart) throws Exception {
        int lastIndex = deployments.length - 1;
        String jvmHome = deployments[lastIndex].getJVMHome();
        if (jvmHome == null) {
            jvmHome = DEFAULT_JVM_HOME;
        }
        StartContainerCommand startCommand = new StartContainerCommand(deployments, jvmHome, logger, doRestart);
        deployments[lastIndex].getLocalFileReferences();
        GeneratePlatformArguments generatePlatformArgs = new GeneratePlatformArguments(jvmHome, deployments[lastIndex].m_classpath.getLaunchClasspath(), platformArgsFile, logger);
        deployments[lastIndex].mergePlatformDependentArgs(generatePlatformArgs.getJVMArguments());
        deployments[lastIndex].mergePlatformProps(generatePlatformArgs.getSystemProprties(), !deployments[lastIndex].m_useCachedConfig);
        deployments[lastIndex].m_systemProps.addProps(additionalProps);
        startCommand.createExecCommand(generateScriptOnly, specifyLibPath);
        if ((deployments[lastIndex].m_traceMask & 0x1000) != 0) {
            logger.logMessage("Container startup command:" + IContainer.NEWLINE + startCommand, 7);
        }
        return startCommand;
    }

    public static ArrayList prepareCacheForActivatedContainer(IConnectorClient connector, IDirectoryAdminService ds, ILogger logger, String domainName, String containerName, String containerID, String containerWorkDirDirectoryName, String cacheHostDirectoryName, String cachePassword, HashMap activationProps) throws Exception {
        LaunchConnector preconnectedConnector = new LaunchConnector((ConnectorClient)connector);
        return LaunchContainer.internalPrepareCacheForActivatedContainer(preconnectedConnector, ds, logger, domainName, containerName, containerID, containerWorkDirDirectoryName, cacheHostDirectoryName, cachePassword, activationProps);
    }

    public static ArrayList prepareCacheForActivatedContainer(JMSConnectorClient connector, IDirectoryAdminService ds, ILogger logger, String domainName, String containerName, String containerID, String containerWorkDirDirectoryName, String cacheHostDirectoryName, String cachePassword, HashMap activationProps) throws Exception {
        return LaunchContainer.internalPrepareCacheForActivatedContainer(connector, ds, logger, domainName, containerName, containerID, containerWorkDirDirectoryName, cacheHostDirectoryName, cachePassword, activationProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList internalPrepareCacheForActivatedContainer(IRemoteMBeanServer connector, IDirectoryAdminService ds, ILogger logger, String domainName, String containerName, String containerID, String containerWorkDirDirectoryName, String cacheHostDirectoryName, String cachePassword, HashMap activationProps) throws Exception {
        DeployContainerResources deployment = new DeployContainerResources(null);
        try {
            deployment.init(logger, domainName, containerName, containerID, containerWorkDirDirectoryName, cacheHostDirectoryName, cachePassword, true);
            try {
                deployment.getConfiguration(connector, ds);
                deployment.deployResources();
            }
            catch (Throwable t) {
                logger.logMessage("Resource refreshment for container \"" + containerName + "\" failed, trace follows...", t, 2);
            }
            if (deployment.m_extractedConfig == null || deployment.m_logicalArchivePath == null) {
                throw new Exception("Cannot start container \"" + containerName + "\"");
            }
            if (deployment.m_useCachedConfig) {
                logger.logMessage("Using cached container configuration for container \"" + containerName + "\"", 2);
            }
            StartContainerCommand startCommand = LaunchContainer.createStartCommand(new DeployContainerResources[]{deployment}, containerName + ".plt", logger, false, activationProps, true, false);
            ArrayList arrayList = startCommand.getCommandArray();
            return arrayList;
        }
        finally {
            LaunchContainer.releaseResources(deployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startContainer(String containerName, String workingDir, ArrayList startContainerCommand) throws Exception {
        Thread shutdownThread = this.setShutdownThread();
        ContainerProcess containerProc = new ContainerProcess(startContainerCommand, containerName, workingDir, this.m_logger);
        containerProc.exec();
        int containerExitCode = containerProc.waitFor();
        Object object = this.m_shutdownThreadLockObj;
        synchronized (object) {
            this.m_shutdownRequested = true;
            this.m_shutdownThreadLockObj.notifyAll();
        }
        Runtime.getRuntime().halt(containerExitCode);
    }

    private void generateStartContainerScript(String workingDir, String startContainerCommand, String nativePath) throws Exception {
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.m_launchScriptPath, false)), true);
        String cdCommand = null;
        String commentPrefix = null;
        if (BAT_LAUNCH_SCRIPT) {
            cdCommand = "cd /d \"" + workingDir + "\"";
            commentPrefix = "rem ";
        } else {
            cdCommand = "cd \"" + workingDir + "\"";
            commentPrefix = "# ";
        }
        writer.println(commentPrefix + "Warning: This script is generated and invoked by LaunchContainer." + " It may not be modified or invoked directly.");
        if (ON_WINDOWS && !BAT_LAUNCH_SCRIPT) {
            cdCommand = cdCommand.replace('\\', '/');
            startContainerCommand = startContainerCommand.replace('\\', '/');
        }
        writer.println(cdCommand);
        writer.println(LaunchContainer.appendPathLine(nativePath));
        writer.println(startContainerCommand);
    }

    private static void releaseResources(DeployContainerResources deployment) {
        deployment.releaseResources();
    }

    private static void releaseResources(DeployContainerResources[] deployments) {
        for (int i = 0; i < deployments.length; ++i) {
            deployments[i].releaseResources();
        }
    }

    private Thread setShutdownThread() {
        Thread shutdownThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LaunchContainer.this.m_shutdownThreadLockObj;
                synchronized (object) {
                    try {
                        while (!LaunchContainer.this.m_shutdownRequested) {
                            LaunchContainer.this.m_shutdownThreadLockObj.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        return shutdownThread;
    }

    void logMessage(String message, int severityLevel) {
        this.m_logger.logMessage(message, severityLevel);
    }

    void logMessage(String message, Throwable t, int severityLevel) {
        this.m_logger.logMessage(message, t, severityLevel);
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Starts a container.");
        System.out.println();
        System.out.println("Usage: <java> [-Dsonic.home=<home>] [-Dsonicsw.mf.password=<password>] <boot file> [<ds xml boot file>");
        System.out.println();
        System.out.println("  <boot file>  Container XML or INI configuration file.");
        System.out.println();
        System.out.println("  <ds xml boot file>  If the container hosts the DS (optional).");
        System.out.println();
        System.out.println("  <home> The directory above the sonic lib directory (not required in a Centralized Install setup).");
        System.out.println();
        System.out.println("  <password> Password to decrypt disk based configuration information (optional).");
        System.out.flush();
    }

    static {
        PATH_VAR_NAME = LaunchContainer.getPathVarName();
        BAT_LAUNCH_SCRIPT = ON_WINDOWS;
        String shOnWindows = System.getProperty("sonicsw.mf.generate.sh");
        if (shOnWindows != null) {
            BAT_LAUNCH_SCRIPT = !shOnWindows.equalsIgnoreCase("true");
        }
    }
}

