/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.util.LockFile;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.ci.ContainerProcess;
import com.sonicsw.mf.framework.agent.ci.ILauncherContainerDriver;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import javax.management.ObjectName;

public final class LauncherContainerDriver
implements ILauncherContainerDriver {
    private static String INSTALL_AND_START_LOG = "winservice_install_and_start.log";
    private static String INSTALL_AND_START_ERROR_LOG = "winservice_install_and_start_error.log";
    private static String CONTAINER_LAUNCH_ERROR_LOG = "container_launch_error.log";
    private static final String INSTALL_AND_START_SCRIPT_NAME = "winservice_install_and_start.bat";
    private static final String LAUNCH_CONTAINER_BAT_SCRIPT_NAME = "launchcontainer.bat";
    private static final String LAUNCH_CONTAINER_SH_SCRIPT_NAME = "launchcontainer.sh";
    private static final String FAILED_TO_INSTALL_WS_ERROR_TEXT = "Failed to start the Windows Service install process: Exit error ";
    private static final String FAILED_TO_LAUNCH_BAT_ERROR_TEXT = "Failed to start windows cmd to launch the container: Exit error ";
    private static final String FILELOG_SUFFIX = ".log";
    private static final String RESTART_LOG_ENTRY = "Restart initiated";
    private static final String STARTUP_COMPLETE_LOG_ENTRY = "startup complete";
    private static final String SHUTDOWN_EXIT_LOG_ENTRY = "(info) Exiting...";
    private static String INSTALL_AND_START_INSTRUCTIONS;
    private static String START_WS_LOG;
    private static String START_WS_ERROR_LOG;
    private static final String FAILED_TO_START_WS_ERROR_TEXT = "Failed to start the Windows Service start process: Exit error ";
    private static final String START_WS_SCRIPT_NAME = "winservice_start.bat";
    private static String START_WS_INSTRUCTIONS;
    File m_containerDir;
    File m_logFile;
    String m_containerDSPath;
    String m_containerName;
    String m_fullContainerName;
    String m_domainName;

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("The com.sonicsw.mf.framework.agent.ci.LauncherContainerDriver container shutdown programs requires 3 arguments: ");
            System.err.println("Working directory path, synchronous (true | false) and forced shutdown (true | false)");
            throw new Exception("Bad Arguments");
        }
        File workingDir = new File(args[0]);
        boolean synchronous = new Boolean(args[1]);
        boolean force = new Boolean(args[2]);
        LauncherContainerDriver.shutdownLocalContainer(workingDir, synchronous, force);
    }

    LauncherContainerDriver(File containerDir) throws IOException {
        File containerINI = new File(containerDir, "container.ini");
        Properties props = ContainerUtil.readProperties(new FileInputStream(containerINI));
        this.init(containerDir, props.getProperty("DOMAIN_NAME"), props.getProperty("CONTAINER_PATH"));
    }

    LauncherContainerDriver(File containerDir, String domainName, String containerDSPath) {
        this.init(containerDir, domainName, containerDSPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(File containerDir, String domainName, String containerDSPath) {
        File tempFile;
        this.m_containerDir = containerDir;
        this.m_domainName = domainName;
        this.m_containerDSPath = containerDSPath;
        this.m_containerName = new File(this.m_containerDSPath).getName();
        this.m_fullContainerName = this.m_domainName + "." + this.m_containerName;
        String fullDefaultLogName = this.m_fullContainerName + FILELOG_SUFFIX;
        String logLocation = null;
        File logLocationFile = new File(this.m_containerDir, "log_location");
        if (logLocationFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(logLocationFile)));){
                String line = reader.readLine();
                if (line != null && (line = line.trim()).length() > 0) {
                    logLocation = line;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        File logDir = null;
        logDir = logLocation != null ? ((tempFile = new File(logLocation)).isAbsolute() ? tempFile : new File(this.m_containerDir, logLocation)) : new File(this.m_containerDir, fullDefaultLogName);
        this.m_logFile = new File(logDir, fullDefaultLogName);
    }

    @Override
    public void installAsWindowsServiceAndStart() throws Exception {
        String scriptPath = new File(this.m_containerDir, INSTALL_AND_START_SCRIPT_NAME).getAbsolutePath();
        this.writeScript(INSTALL_AND_START_INSTRUCTIONS, scriptPath);
        int logInitialLength = LauncherContainerDriver.countFileLines(this.m_logFile);
        this.startWindowsCMDProcess(INSTALL_AND_START_SCRIPT_NAME, INSTALL_AND_START_ERROR_LOG, FAILED_TO_INSTALL_WS_ERROR_TEXT);
        new LogWatcher(this.m_logFile, STARTUP_COMPLETE_LOG_ENTRY, logInitialLength).waitForTextFound();
    }

    @Override
    public void launchContainerAsWindowsService() throws Exception {
        String scriptPath = new File(this.m_containerDir, START_WS_SCRIPT_NAME).getAbsolutePath();
        this.writeScript(START_WS_INSTRUCTIONS, scriptPath);
        int logInitialLength = LauncherContainerDriver.countFileLines(this.m_logFile);
        this.startWindowsCMDProcess(START_WS_SCRIPT_NAME, START_WS_ERROR_LOG, FAILED_TO_START_WS_ERROR_TEXT);
        new LogWatcher(this.m_logFile, STARTUP_COMPLETE_LOG_ENTRY, logInitialLength).waitForTextFound();
    }

    @Override
    public void launchContainerWithBAT() throws Exception {
        int logInitialLength = LauncherContainerDriver.countFileLines(this.m_logFile);
        this.startWindowsCMDProcess(LAUNCH_CONTAINER_BAT_SCRIPT_NAME, CONTAINER_LAUNCH_ERROR_LOG, FAILED_TO_LAUNCH_BAT_ERROR_TEXT);
        new LogWatcher(this.m_logFile, STARTUP_COMPLETE_LOG_ENTRY, logInitialLength).waitForTextFound();
    }

    @Override
    public void launchContainerWithSH() throws Exception {
        ContainerProcess tempContainerProc = null;
        int logInitialLength = LauncherContainerDriver.countFileLines(this.m_logFile);
        String scriptPath = new File(this.m_containerDir, LAUNCH_CONTAINER_SH_SCRIPT_NAME).getAbsolutePath();
        try {
            ArrayList<String> execCommand = new ArrayList<String>();
            execCommand.add(scriptPath);
            tempContainerProc = new ContainerProcess(execCommand, this.m_containerDSPath, this.m_containerDir.getAbsolutePath(), null);
            tempContainerProc.exec();
        }
        catch (Throwable t) {
            LauncherContainerDriver.log(LauncherContainerDriver.printStackTrace(t, t.getMessage()), new File(this.m_containerDir, CONTAINER_LAUNCH_ERROR_LOG).getAbsolutePath());
        }
        final LogWatcher logWatcher = new LogWatcher(this.m_logFile, STARTUP_COMPLETE_LOG_ENTRY, logInitialLength);
        final ContainerProcess containerProc = tempContainerProc;
        Thread procThread = new Thread("com.sonicsw.mf.framework.agent.ci.LauncherContainerDriver.launchContainerWithSH process threasd"){

            @Override
            public void run() {
                try {
                    int exitCode = containerProc.waitFor();
                    if (exitCode != 0) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Failed to launch container: Exit error ").append(new Integer(exitCode).toString()).append(IContainer.NEWLINE);
                        String outMsg = containerProc.getOutput();
                        if (outMsg != null && outMsg.length() > 0) {
                            sb.append(outMsg).append(IContainer.NEWLINE);
                        }
                        if ((outMsg = containerProc.getError()) != null && outMsg.length() > 0) {
                            sb.append(outMsg);
                        }
                        logWatcher.setException(new Exception(sb.toString()));
                    }
                }
                catch (Exception e) {
                    logWatcher.setException(e);
                    return;
                }
            }
        };
        procThread.setDaemon(true);
        procThread.start();
        logWatcher.waitForTextFound();
    }

    @Override
    public void shutdown(JMSConnectorClient connector) throws Exception {
        LauncherContainerDriver.shutdownContainer(connector, this.m_domainName, this.m_containerName, this.m_logFile);
    }

    public static void shutdownContainer(JMSConnectorClient connector, String domainName, String containerName, File containerLog) throws Exception {
        int logInitialLength = LauncherContainerDriver.countFileLines(containerLog);
        ObjectName agentComponent = new ObjectName(domainName + '.' + containerName + ':' + "ID=AGENT");
        connector.invoke(agentComponent, "shutdown", new Object[0], new String[0]);
        new LogWatcher(containerLog, SHUTDOWN_EXIT_LOG_ENTRY, logInitialLength).waitForTextFound();
    }

    public static void restartContainer(JMSConnectorClient connector, String domainName, String containerName, File containerLog) throws Exception {
        LauncherContainerDriver.restartContainer(connector, domainName, containerName, containerLog, false);
    }

    public static void restartContainer(JMSConnectorClient connector, String domainName, String containerName, File containerLog, boolean cleanRestart) throws Exception {
        int logInitialLength = LauncherContainerDriver.countFileLines(containerLog);
        ObjectName agentComponent = new ObjectName(domainName + '.' + containerName + ':' + "ID=AGENT");
        connector.invoke(agentComponent, cleanRestart ? "cleanRestart" : "restart", new Object[0], new String[0]);
        new LogWatcher(containerLog, RESTART_LOG_ENTRY, logInitialLength).waitForTextFound();
        new LogWatcher(containerLog, STARTUP_COMPLETE_LOG_ENTRY, logInitialLength).waitForTextFound();
    }

    private void writeScript(String scriptText, String scriptPath) throws IOException {
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(scriptPath, false)), true);
        writer.println(scriptText);
        writer.close();
    }

    void startWindowsCMDProcess(String scriptName, String launchErrorLog, String errorText) {
        try {
            ArrayList<String> execCommand = new ArrayList<String>();
            execCommand.add("cmd.exe");
            execCommand.add("/C");
            execCommand.add("start");
            execCommand.add("cmd.exe");
            execCommand.add("/C");
            execCommand.add(scriptName);
            ContainerProcess cmdProcess = new ContainerProcess(execCommand, this.m_containerDSPath, this.m_containerDir.getAbsolutePath(), null);
            cmdProcess.exec();
            int exitCode = cmdProcess.waitFor();
            if (exitCode != 0) {
                StringBuffer sb = new StringBuffer();
                sb.append(errorText).append(new Integer(exitCode).toString()).append(IContainer.NEWLINE);
                String outMsg = cmdProcess.getOutput();
                if (outMsg != null && outMsg.length() > 0) {
                    sb.append(outMsg).append(IContainer.NEWLINE);
                }
                if ((outMsg = cmdProcess.getError()) != null && outMsg.length() > 0) {
                    sb.append(outMsg);
                }
                LauncherContainerDriver.log(sb.toString(), launchErrorLog);
            }
        }
        catch (Throwable t) {
            try {
                LauncherContainerDriver.log(LauncherContainerDriver.printStackTrace(t, t.getMessage()), new File(this.m_containerDir, launchErrorLog).getAbsolutePath());
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    private static void log(String msg, String fileName) throws Exception {
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(fileName, false)), true);
        writer.println(msg);
        writer.close();
    }

    private static String printStackTrace(Throwable exception, String message) {
        StringBuffer buffer = new StringBuffer(message);
        buffer.append(IContainer.NEWLINE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out, true);
        exception.printStackTrace(writer);
        byte[] data = out.toByteArray();
        try {
            out.close();
        }
        catch (IOException io) {
            // empty catch block
        }
        buffer.append(new String(data));
        return buffer.toString();
    }

    public static int countFileLines(File logFile) throws IOException {
        if (!logFile.exists()) {
            return 0;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));
        int count = 0;
        while (reader.readLine() != null) {
            ++count;
        }
        reader.close();
        return count;
    }

    public static boolean lookForText(String text, File logFile, int afterLine) throws IOException {
        return LauncherContainerDriver.lookForText(text, logFile, afterLine, null);
    }

    private static boolean lookForText(String text, File logFile, int afterLine, Boolean[] rolledOverPoniter) throws IOException {
        boolean logRolledOver;
        String line;
        if (!logFile.exists()) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));
        int lineNum = 0;
        int lineFound = 0;
        while ((line = reader.readLine()) != null) {
            ++lineNum;
            if (line.indexOf(text) == -1) continue;
            lineFound = lineNum;
        }
        reader.close();
        boolean bl = logRolledOver = lineNum < afterLine;
        if (rolledOverPoniter != null && logRolledOver) {
            rolledOverPoniter[0] = Boolean.TRUE;
        }
        return lineFound > afterLine || logRolledOver && lineFound > 0;
    }

    public static String getLineText(File logFile, int targetLineNum) throws IOException {
        String line;
        if (!logFile.exists() || targetLineNum <= 0) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));
        int lineNum = 0;
        while ((line = reader.readLine()) != null) {
            if (++lineNum != targetLineNum) continue;
            reader.close();
            return line;
        }
        reader.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutdownLocalContainer(File containerWD, boolean waitForShutdown, boolean force) throws Exception {
        File timestampFile = new File(containerWD, "start_timestamp");
        File shutdownFile = new File(containerWD, "shutdown_sonic_container");
        String startupTimestamp = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(timestampFile)));
            startupTimestamp = reader.readLine().trim();
        }
        catch (Exception e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        if (startupTimestamp == null) {
            return false;
        }
        String doForce = force ? "true" : "false";
        shutdownFile.delete();
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(shutdownFile, false)), true);
        writer.println(startupTimestamp);
        writer.println(doForce);
        writer.close();
        if (!waitForShutdown) {
            return true;
        }
        LauncherContainerDriver.waitForContainerToShutdown(containerWD);
        return true;
    }

    public static void waitForContainerToShutdown(File containerWD) throws Exception {
        LockFile containerRunningLock = new LockFile(new File(containerWD, "container_running.lock").getAbsolutePath());
        while (!containerRunningLock.lock()) {
            Thread.sleep(2000L);
        }
        containerRunningLock.unlock();
    }

    static {
        START_WS_LOG = "start_ws.log";
        START_WS_ERROR_LOG = "winservice_start_error.log";
        StringBuffer sb = new StringBuffer();
        sb.append("call .\\winservice /install > ").append(INSTALL_AND_START_LOG).append(IContainer.NEWLINE);
        sb.append("sleep 5").append(IContainer.NEWLINE);
        sb.append("call .\\winservice /start >> ").append(INSTALL_AND_START_LOG);
        INSTALL_AND_START_INSTRUCTIONS = sb.toString();
        StringBuffer wsSB = new StringBuffer();
        wsSB.append("call .\\winservice /start >> ").append(START_WS_LOG);
        START_WS_INSTRUCTIONS = wsSB.toString();
    }

    public static class LogWatcher {
        private File m_logFile;
        private String m_text;
        private boolean m_found;
        private boolean m_stop;
        private Exception m_exception;
        private int m_initialLength;
        private boolean m_logRolledOver;

        public LogWatcher(File logFile, String text, int initialLength) {
            this.m_logFile = logFile;
            this.m_text = text;
            this.m_found = false;
            this.m_stop = false;
            this.m_exception = null;
            this.m_initialLength = initialLength;
            this.m_logRolledOver = false;
            Thread watchThread = new Thread("com.sonicsw.mf.framework.agent.ci.LauncherContainerDriver log watcher"){

                @Override
                public void run() {
                    try {
                        while (!LogWatcher.this.m_stop) {
                            Boolean[] rolledOverPointer = !LogWatcher.this.m_logRolledOver ? new Boolean[1] : null;
                            boolean textFound = LauncherContainerDriver.lookForText(LogWatcher.this.m_text, LogWatcher.this.m_logFile, LogWatcher.this.m_initialLength, rolledOverPointer);
                            if (!textFound && !LogWatcher.this.m_logRolledOver && rolledOverPointer[0] != null) {
                                LogWatcher.this.m_initialLength = 0;
                                LogWatcher.this.m_logRolledOver = true;
                            }
                            if (textFound) {
                                LogWatcher.this.setFound();
                                return;
                            }
                            Thread.sleep(5000L);
                        }
                    }
                    catch (Exception e) {
                        LogWatcher.this.setException(e);
                        return;
                    }
                }
            };
            watchThread.setDaemon(true);
            watchThread.start();
        }

        public void waitForTextFound() throws Exception {
            this.waitForTextFound(-1L);
        }

        public synchronized void waitForTextFound(long waitPeriod) throws Exception {
            long waitCounter = 0L;
            while (!this.m_found && this.m_exception == null) {
                try {
                    this.wait(1000L);
                    waitCounter += 1000L;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (waitPeriod > 0L && waitCounter >= waitPeriod) {
                    this.m_stop = true;
                    throw new Exception("The \"" + this.m_text + "\" text was not found in log \"" + this.m_logFile.getAbsolutePath() + "\" after " + waitPeriod + " millis");
                }
                if (this.m_exception == null) continue;
                throw this.m_exception;
            }
        }

        private synchronized void setFound() {
            this.m_found = true;
            this.notifyAll();
        }

        final synchronized void setException(Exception e) {
            this.m_exception = e;
            this.notifyAll();
        }
    }
}

