/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.framework.agent.ContainerSetup;
import com.sonicsw.mf.framework.agent.ci.ILauncherContainerDriver;
import com.sonicsw.mf.framework.agent.ci.ILauncherDriver;
import com.sonicsw.mf.framework.agent.ci.LauncherContainerDriver;
import com.sonicsw.mf.framework.agent.ci.LauncherFilesInstaller;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public final class LauncherDriver
implements ILauncherDriver {
    String m_sonicHome;
    String m_version;
    File m_launcherDir;

    public static void mainInstallTest(String[] args) throws Exception {
        LauncherDriver launcher = new LauncherDriver("C:/test");
        launcher.install("C:/Sonic8.0/Archives/MF/8.0/MFcontainer.car");
    }

    public static void main(String[] args) throws Exception {
        LauncherDriver launcher = new LauncherDriver("C:/test");
        launcher.install("C:/Sonic8.0/Archives/MF/8.0/MFcontainer.car");
        Properties props = new Properties();
        props.put("WINDOWS_SERVICE_NAME", "AutoTestContainer");
        props.put("DOMAIN_NAME", "Domain1");
        props.put("CREATE_IF_DOES_NOT_EXIST", "true");
        props.put("CONTAINER_PATH", "/Containers/AutoTestContainer");
        props.put("ConnectionURLs", "tcp://localhost:2506");
        props.put("DefaultPassword", "Administrator");
        props.put("DefaultUser", "Administrator");
        ILauncherContainerDriver containerDriver = launcher.setupContainer(props);
        containerDriver.launchContainerWithBAT();
        Thread.sleep(10000L);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("ConnectionURLs", "tcp://localhost:2506");
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        JMSConnectorClient connector = new JMSConnectorClient();
        connector.connect(address);
        containerDriver.shutdown(connector);
    }

    public LauncherDriver(String sonicHome) {
        this.m_sonicHome = sonicHome;
    }

    @Override
    public void install(String archivePath) throws IOException {
        this.m_version = new LauncherFilesInstaller().installLauncherFiles(archivePath, this.m_sonicHome, true);
        this.setlauncherDir();
    }

    @Override
    public void initFromExistingInstall(String version) {
        this.m_version = version;
        this.setlauncherDir();
    }

    @Override
    public String getLauncherVersion() {
        return this.m_version;
    }

    @Override
    public File getLauncherDir() {
        return this.m_launcherDir;
    }

    @Override
    public ILauncherContainerDriver setupContainer(Properties containerProperties) throws Exception {
        File containerDir = ContainerSetup.setupContainer(this.m_launcherDir.getAbsolutePath(), containerProperties);
        return new LauncherContainerDriver(containerDir, containerProperties.getProperty("DOMAIN_NAME"), containerProperties.getProperty("CONTAINER_PATH"));
    }

    @Override
    public ILauncherContainerDriver getContainer(String containerFolderPath) throws IOException {
        return new LauncherContainerDriver(new File(containerFolderPath));
    }

    private void setlauncherDir() {
        File homeDir = new File(this.m_sonicHome);
        this.m_launcherDir = new File(homeDir, "Launcher/" + this.m_version);
    }
}

