/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.util.ZipSerializer;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ci.LauncherFilesInstaller;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;

public final class LauncherJARBuilder {
    private static final String EXT_PACK = ".pack";
    static final String MF_DIR_JAR_PATH = "lib/MFdirectory.jar";
    private static final String SONICSW_HOME = System.getProperty("sonicsw.home");
    private static final String CONTAINER_ARCHIVE_TO_DIRECTORY_JAR_MAP = "launch/maps/car_to_mfdirectory_map";
    private static final String LINE_DELIM = ": ";
    private static final int LINE_DELIM_LENGTH = ": ".length();
    private static final String EXCLUDE_PHRASE = "exclude";
    private HashMap<String, ArrayList<String>> m_jarMaps = new HashMap();
    private File m_archiveSourceRoot;
    private File m_jarFileToBuild;
    private File m_mapFile;
    private ArrayList<String> m_exclusions = new ArrayList();
    private byte[] m_buffer;

    public static void main(String[] args) throws IOException {
        LauncherJARBuilder.createMFdirectoryJAR();
    }

    public static boolean createMFdirectoryJAR() throws IOException {
        if (IContainer.CURRENT_LAUNCHER_VERSION == null) {
            return false;
        }
        File launcherHomeDir = new File(new File(SONICSW_HOME), IContainer.LAUNCHER_DIR);
        File MFdirectoryJAR = new File(launcherHomeDir, MF_DIR_JAR_PATH);
        if (MFdirectoryJAR.exists()) {
            return false;
        }
        String rootMFContainerPath = System.getProperty("sonicsw.mf.container_archive_root");
        if (rootMFContainerPath == null) {
            throw new IOException("The \"sonicsw.mf.container_archive_root\" system property was not defined");
        }
        File rootMFContainerArchive = new File(rootMFContainerPath);
        File carToMFdirectoryMap = new File(rootMFContainerArchive, CONTAINER_ARCHIVE_TO_DIRECTORY_JAR_MAP);
        new LauncherJARBuilder(carToMFdirectoryMap, rootMFContainerArchive, MFdirectoryJAR).buildJAR();
        return true;
    }

    static boolean mfDirectoryJARIsMissing() throws IOException {
        if (IContainer.CURRENT_LAUNCHER_VERSION == null) {
            return false;
        }
        File launcherHomeDir = new File(new File(SONICSW_HOME), IContainer.LAUNCHER_DIR);
        File MFdirectoryJAR = new File(launcherHomeDir, MF_DIR_JAR_PATH);
        return !MFdirectoryJAR.exists();
    }

    static void createMFdirectoryJAR(File rootMFContainerArchive, File MFdirectoryJAR) throws IOException {
        File carToMFdirectoryMap = new File(rootMFContainerArchive, CONTAINER_ARCHIVE_TO_DIRECTORY_JAR_MAP);
        new LauncherJARBuilder(carToMFdirectoryMap, rootMFContainerArchive, MFdirectoryJAR).buildJAR();
    }

    LauncherJARBuilder(File mapFile, File archiveSourceRoot, File jarFileToBuild) {
        this.m_exclusions.add("META-INF/");
        this.m_buffer = new byte[1024];
        this.m_jarFileToBuild = jarFileToBuild;
        this.m_mapFile = mapFile;
        this.m_archiveSourceRoot = archiveSourceRoot;
    }

    public void buildJAR() throws IOException {
        this.readMap(this.m_mapFile);
        this.createJAR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMap(File mapFile) throws IOException {
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(mapFile)));
            while ((line = reader.readLine()) != null) {
                int delimIndex = line.indexOf(LINE_DELIM);
                if (delimIndex == -1) continue;
                String src = line.substring(0, delimIndex).trim();
                String target = line.substring(delimIndex + LINE_DELIM_LENGTH).trim();
                if (src.equalsIgnoreCase(EXCLUDE_PHRASE)) {
                    this.m_exclusions.add(target);
                    continue;
                }
                ArrayList<String> targets = this.m_jarMaps.get(src);
                if (targets == null) {
                    targets = new ArrayList();
                }
                targets.add(target);
                this.m_jarMaps.put(src, targets);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJAR() throws IOException {
        if (this.m_jarFileToBuild.exists() && !this.m_jarFileToBuild.delete()) {
            throw new IOException("\"" + this.m_jarFileToBuild.getAbsolutePath() + "\" already exists and cannot be deleted");
        }
        String jarName = this.m_jarFileToBuild.getName();
        int dotIndex = jarName.lastIndexOf(".");
        String tmpName = (dotIndex == -1 ? jarName : jarName.substring(0, dotIndex)) + "_tmp";
        File tempDestination = new File(this.m_jarFileToBuild.getParentFile(), tmpName);
        this.clearDestination(tempDestination);
        if (tempDestination.exists()) {
            throw new IOException("Could not delete \"" + tempDestination.getAbsolutePath() + "\" ");
        }
        try {
            for (String source : this.m_jarMaps.keySet()) {
                ArrayList<String> targets = this.m_jarMaps.get(source);
                this.processSource(source, targets, tempDestination);
            }
            new ZipSerializer(tempDestination).zipDir(this.m_jarFileToBuild);
        }
        finally {
            this.clearDestination(tempDestination);
        }
    }

    private void processSource(String source, ArrayList<String> targets, File tempDestination) throws IOException {
        File unpackedFile = this.getSourceFile(source);
        JarFile jarFile = new JarFile(unpackedFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            File parentToCreate;
            JarEntry entry = entries.nextElement();
            if (!this.entryIsInTargetList(entry, targets)) continue;
            File copyFile = new File(tempDestination, entry.getName());
            File file = parentToCreate = entry.isDirectory() ? copyFile : copyFile.getParentFile();
            if (!parentToCreate.exists() && !parentToCreate.mkdirs()) {
                throw new IOException("Could not create " + parentToCreate.getAbsolutePath());
            }
            if (entry.isDirectory()) continue;
            this.createFileFromJAR(jarFile.getInputStream(entry), copyFile);
        }
        jarFile.close();
    }

    private File getSourceFile(String source) throws FileNotFoundException, IOException {
        File srcFile = LauncherFilesInstaller.findCacheFile(this.m_archiveSourceRoot, source);
        if (srcFile == null) {
            throw new FileNotFoundException(source);
        }
        if (!srcFile.getName().endsWith(EXT_PACK)) {
            return srcFile;
        }
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        File unpackedFile = new File(this.m_archiveSourceRoot, source.toString().concat(".jar"));
        FileOutputStream fos = new FileOutputStream(unpackedFile);
        JarOutputStream jout = new JarOutputStream(new BufferedOutputStream(fos));
        unpacker.unpack(srcFile, jout);
        jout.close();
        return unpackedFile;
    }

    private boolean entryIsInTargetList(JarEntry entry, ArrayList<String> targets) {
        int i;
        String entryName = entry.getName();
        if (entryName.toUpperCase().endsWith(".TXT")) {
            return false;
        }
        for (i = 0; i < this.m_exclusions.size(); ++i) {
            if (!entryName.startsWith(this.m_exclusions.get(i))) continue;
            return false;
        }
        for (i = 0; i < targets.size(); ++i) {
            boolean directoryTarget;
            String entryParent;
            File entryFile = new File(entryName);
            File targetFile = new File(targets.get(i));
            String targetName = targetFile.getName();
            String targetParent = targetFile.getParent();
            if (targetParent == null) {
                targetParent = "";
            }
            if ((entryParent = entryFile.getParent()) == null) {
                entryParent = "";
            }
            if (!((directoryTarget = targetName.equals("*")) ? entryFile.getPath().startsWith(targetParent) : entryParent.equals(targetParent) && entryFile.getName().endsWith(targetName.substring(1)))) continue;
            return true;
        }
        return false;
    }

    private void createFileFromJAR(InputStream stream0, File createdFile) throws IOException {
        int numRead;
        BufferedInputStream is = new BufferedInputStream(stream0, this.m_buffer.length);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(createdFile), this.m_buffer.length);
        while ((numRead = is.read(this.m_buffer)) > 0) {
            os.write(this.m_buffer, 0, numRead);
        }
        is.close();
        os.close();
    }

    private void clearDestination(File fileToDelete) {
        if (fileToDelete.isDirectory()) {
            String[] files = fileToDelete.list();
            for (int i = 0; i < files.length; ++i) {
                this.clearDestination(new File(fileToDelete, files[i]));
            }
            fileToDelete.delete();
        } else {
            fileToDelete.delete();
        }
    }
}

