/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.agent.cache.IConfigCache;
import com.sonicsw.mf.framework.agent.cache.IConfigCacheView;
import com.sonicsw.mf.framework.agent.cache.LatestVersionMissingException;
import com.sonicsw.mf.framework.agent.ci.DeployContainerResources;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

final class PopulateCacheResources {
    private IDirectoryAdminService m_ds;
    private IConfigCache m_configCache;
    private IConfigCacheView m_configCacheView;
    private String[] m_resourceList;
    private ILogger m_logger;

    PopulateCacheResources(IDirectoryAdminService ds, IConfigCache configCache, String[] resourceList, ILogger logger) {
        this.m_ds = ds;
        this.m_configCache = configCache;
        this.m_resourceList = resourceList;
        this.m_logger = logger;
    }

    void updateCache() throws Exception {
        this.m_configCacheView = this.m_configCache.getCacheView();
        ArrayList updateRequiredList = this.getUpdateList();
        if (!updateRequiredList.isEmpty()) {
            this.logMessage("Updating the container cache...", 3);
        }
        this.updateResources(updateRequiredList);
        if (!updateRequiredList.isEmpty()) {
            this.logMessage("Cache update is done.", 3);
        }
    }

    private ArrayList getUpdateList() throws Exception {
        ArrayList<String> updateList = new ArrayList<String>();
        if (this.m_resourceList.length == 0) {
            return updateList;
        }
        IElement[] envelopeElements = this.m_ds.getElementsByLogicalNames(this.m_resourceList);
        for (int i = 0; i < envelopeElements.length; ++i) {
            if (envelopeElements[i] == null) {
                this.logMessage("Could not find file \"" + DeployContainerResources.sonicfsPrefix + this.m_resourceList[i] + "\" in the Directory Service", 2);
                continue;
            }
            IElementIdentity dsID = envelopeElements[i].getIdentity();
            IElement cacheElement = this.m_configCacheView.getElement(dsID.getName());
            boolean cacheObsolete = false;
            if (cacheElement == null || cacheElement.getIdentity().getVersion() < dsID.getVersion()) {
                cacheObsolete = true;
            } else {
                File file = null;
                try {
                    file = this.m_configCacheView.getFileByLogicalName(this.m_resourceList[i], false);
                }
                catch (LatestVersionMissingException e) {
                    // empty catch block
                }
                if (file == null) {
                    cacheObsolete = true;
                }
            }
            if (!cacheObsolete) continue;
            updateList.add(this.m_resourceList[i]);
            this.m_configCache.setElement((IBasicElement)envelopeElements[i]);
        }
        return updateList;
    }

    private void logMessage(String message, int sevirityLevel) {
        this.m_logger.logMessage(message, sevirityLevel);
    }

    private void updateResources(ArrayList updateRequiredList) throws Exception {
        HashSet<String> blobsSeen = new HashSet<String>();
        for (int i = 0; i < updateRequiredList.size(); ++i) {
            String logicalName = (String)updateRequiredList.get(i);
            IBlob blob = this.m_ds.getBlobByLogicalName(logicalName);
            if (blob == null) continue;
            if (blob.getBlobStream() == null) {
                throw new Exception("The data of file \"" + logicalName + "\" is missing from the Directory Service.");
            }
            IDirElement blobElement = blob.getElement();
            String storageName = blobElement.getIdentity().getName();
            if (blobsSeen.contains(storageName)) continue;
            String archiveName = blobElement.getArchiveName();
            if (archiveName == null) {
                archiveName = logicalName;
            }
            this.m_configCache.setBlobByLogicalName(archiveName, blob, false, true);
            blobsSeen.add(storageName);
            this.logMessage("Stored \"" + archiveName + "\" in the cache.", 3);
        }
    }
}

