/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.ci.CILogger;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;

final class SetCIConfigUtility {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String m_containerBootFileName;
    private String m_containerName;
    private JMSConnectorClient m_connector;
    private IDirectoryAdminService m_ds;
    private String m_containerID;
    private ExtractedContainerConfig m_bootExtractedConfig;
    private static ILogger m_logger = new CILogger("Centralized Install Configuration Utility");
    ExtractedContainerConfig m_extractedConfig;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java com.sonicsw.mf.framework.agent.ci.SetCIConfigUtility <container boot file> <attributes file>");
            System.exit(1);
        }
        try {
            new SetCIConfigUtility(args[0], args[1]);
        }
        catch (Throwable t) {
            SetCIConfigUtility.logMessage("", t, 1);
            System.exit(1);
        }
    }

    SetCIConfigUtility(String containerBootFileName, String attributesFile) throws Exception {
        File containerBootFile = new File(containerBootFileName);
        this.m_containerBootFileName = containerBootFile.getAbsolutePath();
        if (!(containerBootFile.exists() && containerBootFile.isFile() && containerBootFile.canRead())) {
            String problem = !containerBootFile.exists() ? " not found." : " cannot be read";
            String errMessage = "Bootfile " + containerBootFileName + problem;
            SetCIConfigUtility.logMessage(errMessage, 1);
            throw new Exception(errMessage);
        }
        SetCIConfigUtility.logMessage("Open container boot file \"" + containerBootFile.getAbsolutePath() + '\"', 3);
        IDirElement containerConfiguration = ContainerUtil.importConfiguration(containerBootFile, IContainer.PASSWORD);
        this.m_containerID = containerConfiguration.getIdentity().getName();
        IAttributeSet configAttributes = containerConfiguration.getAttributes();
        this.m_bootExtractedConfig = new ExtractedContainerConfig();
        this.extractConfigInfo(configAttributes, this.m_bootExtractedConfig);
        this.m_containerName = SetCIConfigUtility.createContainerFullName(this.m_bootExtractedConfig);
        SetCIConfigUtility.logMessage("Updating container configuration \"" + this.m_containerName + "\"...", 3);
        this.createDSProxy(this.createConnector(configAttributes), this.m_bootExtractedConfig.m_domainName);
        ExtractedContainerConfig dsExtractedConfig = new ExtractedContainerConfig();
        this.populateProperties(attributesFile);
        SetCIConfigUtility.logMessage("...configuration update complete", 3);
        System.exit(0);
    }

    private void populateProperties(String attFileName) throws Exception {
        String line;
        SetCIConfigUtility.logMessage("Update container configuration ID \"" + this.m_containerID + "\" in the Directory Service from file \"" + attFileName + "\"", 3);
        IDirElement configElement = this.m_ds.getElement(this.m_containerID, true);
        IAttributeSet configAtts = configElement.getAttributes();
        IAttributeSet jvmArgs = (IAttributeSet)configAtts.getAttribute("JVM_ARGUMENTS");
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(attFileName)));
        boolean updated = false;
        while ((line = reader.readLine()) != null) {
            updated = true;
            int eqIndex = line.indexOf(61);
            String key = line.substring(0, eqIndex);
            String value = line.substring(eqIndex + 1);
            SetCIConfigUtility.logMessage("Set " + key + " to " + value, 3);
            if (key.startsWith("JVM_ARGUMENTS")) {
                if (jvmArgs == null) {
                    jvmArgs = configAtts.createAttributeSet("JVM_ARGUMENTS");
                }
                jvmArgs.setStringAttribute(key.substring("JVM_ARGUMENTS".length() + 1), value);
                continue;
            }
            configAtts.setStringAttribute(key, value);
        }
        if (updated) {
            this.m_ds.setElement(configElement.doneUpdate(), null);
        }
    }

    private void createDSProxy(JMSConnectorClient connector, String domainName) throws Exception {
        this.m_ds = new DirectoryServiceProxy(connector, new ObjectName(domainName + "." + "DIRECTORY SERVICE:ID=DIRECTORY SERVICE"));
        this.m_ds.getDirectoryServiceVersion();
    }

    private void extractConfigInfo(IAttributeSet containerAttrs, ExtractedContainerConfig containerConfig) throws Exception {
        containerConfig.m_domainName = (String)containerAttrs.getAttribute("DOMAIN_NAME");
        if (containerConfig.m_domainName == null) {
            containerConfig.m_domainName = "Domain1";
        }
        containerConfig.m_containerName = (String)containerAttrs.getAttribute("CONTAINER_NAME");
        containerConfig.m_classpath = (String)containerAttrs.getAttribute("CLASSPATH");
        containerConfig.m_deployTraceMask = (Integer)containerAttrs.getAttribute("TRACE_MASK");
        if (containerConfig.m_deployTraceMask == null) {
            containerConfig.m_deployTraceMask = new Integer(0);
        }
        IAttributeSet cacheAttrs = (IAttributeSet)containerAttrs.getAttribute("CACHE");
        containerConfig.m_cacheHostDirectoryName = (String)cacheAttrs.getAttribute("CACHE_DIRECTORY");
        if (containerConfig.m_cacheHostDirectoryName == null) {
            containerConfig.m_cacheHostDirectoryName = "./container.cache";
        }
        containerConfig.m_cachePassword = (String)cacheAttrs.getAttribute("PASSWORD");
        IAttributeSet jvmArgs = (IAttributeSet)containerAttrs.getAttribute("JVM_ARGUMENTS");
        containerConfig.m_jvmArgs = jvmArgs != null ? jvmArgs.getAttributes() : new HashMap();
    }

    private JMSConnectorClient createConnector(IAttributeSet configAttributes) throws Exception {
        Integer socketConnectTimeout;
        Integer connectTimeout;
        IAttributeSet connectionAttrs = (IAttributeSet)configAttributes.getAttribute("CONNECTION");
        Map factoryAttrs = (Map)connectionAttrs.getAttributes().clone();
        factoryAttrs.remove("MANAGEMENT_NODE");
        factoryAttrs.remove("REQUEST_TIMEOUT");
        factoryAttrs.remove("CONNECT_TIMEOUT");
        factoryAttrs.remove("SOCKET_CONNECT_TIMEOUT");
        Hashtable<String, String> env = new Hashtable<String, String>(factoryAttrs);
        if (env.get("ConnectionURLs") == null) {
            env.put("ConnectionURLs", "tcp://localhost:2506");
        }
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        String managementNode = (String)connectionAttrs.getAttribute("MANAGEMENT_NODE");
        if (managementNode != null && managementNode.length() > 0) {
            address.setManagementNode(managementNode);
        }
        JMSConnectorClient connector = new JMSConnectorClient();
        Integer requestTimeout = (Integer)connectionAttrs.getAttribute("REQUEST_TIMEOUT");
        if (requestTimeout != null) {
            connector.setRequestTimeout(requestTimeout * 1000);
        }
        if ((connectTimeout = (Integer)connectionAttrs.getAttribute("CONNECT_TIMEOUT")) != null) {
            connector.setConnectTimeout(connectTimeout * 1000);
        }
        if ((socketConnectTimeout = (Integer)connectionAttrs.getAttribute("SOCKET_CONNECT_TIMEOUT")) != null) {
            connector.setSocketConnectTimeout(socketConnectTimeout * 1000);
        }
        SetCIConfigUtility.logMessage("Connecting to the Directory Service to refresh the container's resources", 3);
        connector.connect(address);
        this.m_connector = connector;
        return connector;
    }

    static void logMessage(String message, int severityLevel) {
        m_logger.logMessage(message, severityLevel);
    }

    static void logMessage(String message, Throwable t, int severityLevel) {
        m_logger.logMessage(message, t, severityLevel);
    }

    private static String createContainerFullName(ExtractedContainerConfig extractedConfig) {
        return SetCIConfigUtility.createContainerFullName(extractedConfig.m_domainName, extractedConfig.m_containerName);
    }

    private static String createContainerFullName(String domainName, String containerName) {
        return domainName + "." + containerName;
    }

    private static class ExtractedContainerConfig
    implements Serializable {
        String m_domainName = null;
        String m_containerName = null;
        String m_classpath = null;
        Integer m_deployTraceMask = null;
        String m_cacheHostDirectoryName = null;
        String m_cachePassword = null;
        HashMap m_jvmArgs;

        private ExtractedContainerConfig() {
        }

        ExtractedContainerConfig deepClone() {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(out);
                objectOut.writeObject(this);
                byte[] bytes = out.toByteArray();
                objectOut.close();
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                ObjectInputStream objectIn = new ObjectInputStream(in);
                return (ExtractedContainerConfig)objectIn.readObject();
            }
            catch (Exception e) {
                throw new Error("deepClone failed.");
            }
        }
    }
}

