/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.IDirectoryAdminNotifications;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementChangeHandler;
import com.sonicsw.mf.common.config.IEnvelope;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.elementversion.IArrayElementNotificationListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

class LocalListener
implements IDirectoryAdminNotifications,
IArrayElementNotificationListener {
    private HashSet m_globalChangeHandlers = new HashSet();
    private HashMap m_elementChangeHandlers = new HashMap();

    LocalListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerElementChangeHandler(IElementChangeHandler handler) {
        HashSet hashSet = this.m_globalChangeHandlers;
        synchronized (hashSet) {
            this.m_globalChangeHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerElementChangeHandler(String elementName, IElementChangeHandler handler) {
        HashMap hashMap = this.m_elementChangeHandlers;
        synchronized (hashMap) {
            HashSet<IElementChangeHandler> handlers = (HashSet<IElementChangeHandler>)this.m_elementChangeHandlers.get(elementName);
            if (handlers == null) {
                handlers = new HashSet<IElementChangeHandler>();
            }
            handlers.add(handler);
            this.m_elementChangeHandlers.put(elementName, handlers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterElementChangeHandler(IElementChangeHandler handler) {
        HashSet hashSet = this.m_globalChangeHandlers;
        synchronized (hashSet) {
            this.m_globalChangeHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterElementChangeHandler(String elementName, IElementChangeHandler handler) {
        HashMap hashMap = this.m_elementChangeHandlers;
        synchronized (hashMap) {
            HashSet handlers = (HashSet)this.m_elementChangeHandlers.get(elementName);
            if (handlers == null) {
                return;
            }
            handlers.remove(handler);
            if (handlers.isEmpty()) {
                this.m_elementChangeHandlers.remove(elementName);
            } else {
                this.m_elementChangeHandlers.put(elementName, handlers);
            }
        }
    }

    public void elementsChanged(IBasicElement[] elements) {
        this.handleElementsChanged(elements);
    }

    public void elementsChanged(IDirElement[] elements) {
        this.handleElementsChanged((IBasicElement[])elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleElementsChanged(IBasicElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            boolean reportChange = true;
            boolean replacement = false;
            IBasicElement currentElement = elements[i];
            if (currentElement instanceof IEnvelope) {
                IEnvelope envelope = (IEnvelope)currentElement;
                reportChange = envelope.getProperty("DRE") == null;
                replacement = envelope.getProperty("R") != null;
                currentElement = envelope.getEnvelopedElement();
            }
            if (!reportChange) continue;
            ElementChange elementChange = new ElementChange(currentElement, replacement);
            HashSet handlers = null;
            HashSet hashSet = this.m_globalChangeHandlers;
            synchronized (hashSet) {
                handlers = (HashSet)this.m_globalChangeHandlers.clone();
            }
            String elementName = currentElement.getIdentity().getName();
            HashSet elementHandlers = null;
            HashMap hashMap = this.m_elementChangeHandlers;
            synchronized (hashMap) {
                elementHandlers = (HashSet)this.m_elementChangeHandlers.get(elementName);
            }
            if (elementHandlers != null) {
                Iterator iterator = elementHandlers.iterator();
                while (iterator.hasNext()) {
                    handlers.add(iterator.next());
                }
            }
            for (IElementChangeHandler handler : handlers) {
                try {
                    handler.handleElementChange((IElementChange)elementChange);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private final class ElementChange
    implements IElementChange {
        IBasicElement m_element;
        boolean m_replacement;

        ElementChange(IBasicElement element, boolean replacement) {
            this.m_element = element;
            this.m_replacement = replacement;
        }

        public IBasicElement getElement() {
            return this.m_element;
        }

        public short getChangeType() {
            if (this.m_element instanceof IDeltaElement) {
                return 1;
            }
            if (((IElement)this.m_element).isDeleted()) {
                return 2;
            }
            if (this.m_replacement) {
                return 3;
            }
            return 0;
        }
    }
}

