/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IValidationElementChange;
import com.sonicsw.mf.common.config.impl.DeltaElement;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.ElementIdentity;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;

final class ModificationItem
implements IValidationElementChange {
    static final int CREATE = 1;
    static final int DELETE = 2;
    static final int MODIFY = 3;
    static final int DELETE_NO_BEFORE_IMAGE = 4;
    int m_type;
    DeltaElement m_delta;
    Element m_beforeImage;
    Element m_newElement;
    Element m_deletedElement;
    String m_deletedLogicalName;
    IBasicElement m_modification;
    DirectoryService m_ds;
    ElementIdentity m_elementID;
    boolean m_skipValidation = false;

    IBasicElement getModification() {
        if (this.m_modification != null) {
            return this.m_modification;
        }
        if (this.m_elementID != null) {
            if (this.m_ds == null) {
                throw new IllegalStateException("m_ds should not be null.");
            }
            try {
                return this.m_ds.getElement(this.m_elementID.getName(), false);
            }
            catch (DirectoryServiceException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.toString());
            }
        }
        return null;
    }

    IElementIdentity getModificationID() {
        if (this.m_modification != null) {
            return this.m_modification.getIdentity();
        }
        return this.m_elementID;
    }

    ModificationItem(DeltaElement delta, Element beforeImage) {
        this.m_type = 3;
        this.m_delta = delta;
        this.m_modification = this.m_delta;
        this.m_beforeImage = beforeImage;
        this.m_newElement = null;
        this.m_deletedElement = null;
        this.m_deletedLogicalName = null;
        this.m_elementID = null;
        this.m_ds = null;
    }

    ModificationItem(Element element) {
        this.m_type = 1;
        this.m_delta = null;
        this.m_beforeImage = null;
        this.m_newElement = element;
        this.m_modification = this.m_newElement;
        this.m_deletedElement = null;
        this.m_deletedLogicalName = null;
        this.m_elementID = null;
        this.m_ds = null;
    }

    ModificationItem(DirectoryService ds, ElementIdentity elementID) {
        this.m_type = 1;
        this.m_delta = null;
        this.m_beforeImage = null;
        this.m_newElement = null;
        this.m_modification = null;
        this.m_deletedElement = null;
        this.m_deletedLogicalName = null;
        this.m_elementID = elementID;
        this.m_ds = ds;
    }

    ModificationItem(Element beforeImage, Element deletedElement, String deletedLogicalName, boolean skipValidation) {
        this.m_type = 2;
        this.m_delta = null;
        this.m_beforeImage = beforeImage;
        this.m_newElement = null;
        this.m_deletedElement = deletedElement;
        this.m_modification = this.m_deletedElement;
        this.m_deletedLogicalName = deletedLogicalName;
        this.m_elementID = null;
        this.m_ds = null;
        this.m_skipValidation = skipValidation;
    }

    ModificationItem(Element deletedElement, boolean noBefore) {
        if (!noBefore) {
            throw new Error();
        }
        this.m_type = 4;
        this.m_delta = null;
        this.m_beforeImage = null;
        this.m_newElement = null;
        this.m_deletedElement = deletedElement;
        this.m_modification = this.m_deletedElement;
        this.m_deletedLogicalName = null;
        this.m_elementID = null;
        this.m_ds = null;
    }

    public IBasicElement getElement() {
        return this.getModification();
    }

    public short getChangeType() {
        switch (this.m_type) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw new Error();
    }

    public IElement getBeforeImage() {
        return this.m_beforeImage;
    }

    public boolean skipValidation() {
        return this.m_skipValidation;
    }
}

