/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.view.impl.LogicalNameSpace;
import com.sonicsw.mf.framework.directory.impl.IDCache;
import com.sonicsw.mf.framework.directory.impl.IModificationManager;
import com.sonicsw.mf.framework.directory.storage.IStorage;
import com.sonicsw.mf.framework.directory.storage.StorageException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.RandomAccessFile;

public final class TransactionManager {
    public static boolean _for_testing_only_error_before_commit = false;
    public static boolean _for_testing_only_error_after_commit = false;
    public static final String TRANSACTION_FILE = "tr";
    private static final int COMMIT_NOTE = 2;
    private static final int ROLLBACK_NOTE = 1;
    private File m_dsLocation;
    private IStorage[] m_storages;
    private int m_numParticipants = 0;
    private boolean m_doSync;
    private RandomAccessFile m_trFile;
    private FileDescriptor m_trFileDesc;
    private IModificationManager m_modManager;
    private IDCache m_idCache;
    private LogicalNameSpace m_logicalNameSpace;
    private String m_dsStorageType;

    TransactionManager(File dsLocation, IStorage[] storages, boolean doSync, IModificationManager modManager, String dsStorageType) throws DirectoryServiceException {
        this.m_storages = storages;
        this.m_dsStorageType = dsStorageType;
        this.m_doSync = doSync;
        this.m_dsLocation = dsLocation;
        this.m_modManager = modManager;
        if (this.m_dsStorageType.equals("FS_STORAGE")) {
            this.createCommitFile(dsLocation);
            if (this.hasCommitNote()) {
                this.doCommit(true);
            } else {
                this.doRollback(true);
            }
        }
    }

    void setLogicalNameSpace(LogicalNameSpace nameSpace) {
        this.m_logicalNameSpace = nameSpace;
    }

    void setCache(IDCache idCache) {
        this.m_idCache = idCache;
    }

    void join() throws DirectoryServiceException {
        try {
            if (this.m_numParticipants++ == 0) {
                this.m_idCache.startTransaction();
                for (int i = 0; i < this.m_storages.length; ++i) {
                    this.m_storages[i].startTransaction();
                }
            }
        }
        catch (StorageException e) {
            throw new DirectoryServiceException(e.toString(), (Throwable)e);
        }
    }

    void leave(boolean ok) throws DirectoryServiceException {
        this.leave(ok, null, true);
    }

    void leave(boolean ok, boolean fireTriggers) throws DirectoryServiceException {
        this.leave(ok, null, fireTriggers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leave(boolean ok, IModificationManager modManager0, boolean fireTriggers) throws DirectoryServiceException {
        IModificationManager modManager;
        IModificationManager iModificationManager = modManager = modManager0 != null ? modManager0 : this.m_modManager;
        if (this.m_numParticipants == 0) {
            throw new Error();
        }
        if (this.m_numParticipants == 1) {
            DirectoryServiceException exception = null;
            if (ok) {
                try {
                    if (fireTriggers) {
                        modManager.onDelete();
                        modManager.onUpdate();
                        modManager.onCreate();
                        modManager.validate();
                    }
                    if (_for_testing_only_error_before_commit && this.m_dsStorageType.equals("FS_STORAGE")) {
                        throw new Error("_for_testing_only_error_before_commit = true");
                    }
                    if (this.m_dsStorageType.equals("FS_STORAGE")) {
                        this.writeCommitNote();
                    }
                    if (_for_testing_only_error_after_commit && this.m_dsStorageType.equals("FS_STORAGE")) {
                        throw new Error("_for_testing_only_error_after_commit = true");
                    }
                }
                catch (DirectoryServiceException e) {
                    exception = e;
                    ok = false;
                }
                finally {
                    this.m_numParticipants = 0;
                }
                if (ok) {
                    modManager.audit();
                    if (this.m_logicalNameSpace != null) {
                        this.m_logicalNameSpace.storeUpdates();
                    }
                    this.doCommit(false);
                    if (fireTriggers) {
                        modManager.afterCreate();
                        modManager.afterUpdate();
                        modManager.afterDelete();
                    }
                    if (this.m_logicalNameSpace != null) {
                        this.m_logicalNameSpace.doNotify();
                    }
                    modManager.doNotify();
                }
            }
            if (!ok) {
                try {
                    modManager.reset();
                    this.doRollback(false);
                    if (this.m_logicalNameSpace != null) {
                        this.m_logicalNameSpace.reset();
                    }
                    if (exception != null) {
                        throw exception;
                    }
                }
                finally {
                    this.m_numParticipants = 0;
                }
            }
        } else {
            --this.m_numParticipants;
        }
    }

    void openFiles() throws DirectoryServiceException {
        if (this.m_dsStorageType.equals("FS_STORAGE")) {
            this.createCommitFile(this.m_dsLocation);
        }
    }

    void closeFiles() throws DirectoryServiceException {
        if (this.m_dsStorageType.equals("FS_STORAGE")) {
            this.closeCommitFile();
        }
    }

    void close() throws DirectoryServiceException {
        if (this.m_dsStorageType.equals("FS_STORAGE")) {
            this.closeCommitFile();
        }
        try {
            for (int i = 0; i < this.m_storages.length; ++i) {
                this.m_storages[i].closeTransactionManager();
            }
        }
        catch (StorageException e) {
            throw new DirectoryServiceException(e.toString(), (Throwable)e);
        }
    }

    private void doRollback(boolean recovery) throws DirectoryServiceException {
        if (!recovery) {
            this.m_idCache.rollBackTransaction();
        }
        try {
            for (int i = 0; i < this.m_storages.length; ++i) {
                this.m_storages[i].rollbackTransaction();
            }
        }
        catch (StorageException e) {
            throw new DirectoryServiceException(e.toString(), (Throwable)e);
        }
    }

    private void doCommit(boolean recovery) throws DirectoryServiceException {
        if (_for_testing_only_error_before_commit && this.m_dsStorageType.equals("PSE_STORAGE")) {
            throw new Error("_for_testing_only_error_before_commit = true");
        }
        if (!recovery) {
            this.m_idCache.commitTransaction();
        }
        try {
            for (int i = 0; i < this.m_storages.length; ++i) {
                this.m_storages[i].commitTransaction();
            }
        }
        catch (StorageException e) {
            throw new DirectoryServiceException(e.toString(), (Throwable)e);
        }
        if (_for_testing_only_error_after_commit && this.m_dsStorageType.equals("PSE_STORAGE")) {
            throw new Error("_for_testing_only_error_after_commit = true");
        }
        if (this.m_dsStorageType.equals("FS_STORAGE")) {
            this.writeRollbackNote();
        }
    }

    private void closeCommitFile() throws DirectoryServiceException {
        try {
            this.m_trFile.close();
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString(), (Throwable)e);
        }
    }

    private void createCommitFile(File dsLocation) throws DirectoryServiceException {
        try {
            File trFilePath = new File(dsLocation, TRANSACTION_FILE);
            boolean fileExists = trFilePath.exists();
            this.m_trFile = new RandomAccessFile(trFilePath, "rw");
            this.m_trFileDesc = this.m_trFile.getFD();
            if (fileExists) {
                this.m_trFile.seek(0L);
                return;
            }
            this.writeRollbackNote();
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString(), (Throwable)e);
        }
    }

    private void writeCommitNote() throws DirectoryServiceException {
        this.writeNote(2);
    }

    private void writeRollbackNote() throws DirectoryServiceException {
        this.writeNote(1);
    }

    private void writeNote(int note) throws DirectoryServiceException {
        try {
            this.m_trFile.writeInt(note);
            if (this.m_doSync) {
                this.m_trFileDesc.sync();
            }
            this.m_trFile.seek(0L);
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString(), (Throwable)e);
        }
    }

    private boolean hasCommitNote() throws DirectoryServiceException {
        try {
            boolean hasCommit = this.m_trFile.readInt() == 2;
            this.m_trFile.seek(0L);
            return hasCommit;
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString(), (Throwable)e);
        }
    }
}

