/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.storage.pse;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectReference;
import com.odi.util.HashPersistent;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.agent.EncryptionException;
import com.sonicsw.mf.framework.agent.PBE;
import com.sonicsw.mf.framework.directory.storage.DSEncryptionException;
import com.sonicsw.mf.framework.directory.storage.PackedDirUtil;
import com.sonicsw.mf.framework.directory.storage.pse.ByteArrayWrapper;
import com.sonicsw.mf.framework.directory.storage.pse.DSBlob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DSElement
implements IPersistent,
IPersistentHooks {
    private int ODITheHashCode = HashPersistent.getNextHashCode();
    private String m_elementName;
    private ByteArrayWrapper m_element;
    private ByteArrayWrapper m_id;
    DSBlob m_blob;
    private transient boolean m_keepBlob;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = DSElement.getClassInfoInstance();

    public DSElement(String name, IDirElement el, String password) throws Exception {
        this.m_keepBlob = false;
        this.m_elementName = name;
        if (this.m_elementName == null) {
            System.out.println("!!!!!Created an element with no name");
        } else {
            char[] chars = this.m_elementName.toCharArray();
            int encodedLength = ObjectAccess.UTF8Length((char[])chars, (int)chars.length);
            if (encodedLength >= 256) {
                throw new IllegalArgumentException("Invalid storage element key name (encoded length " + encodedLength + " >= " + 256 + "): \"" + name + '\"');
            }
        }
        if (el != null) {
            ByteArrayOutputStream elByteStream = new ByteArrayOutputStream();
            ByteArrayOutputStream idByteStream = new ByteArrayOutputStream();
            IElementIdentity id = el.getIdentity();
            ObjectOutputStream elOStream = new ObjectOutputStream(elByteStream);
            ObjectOutputStream idOStream = new ObjectOutputStream(idByteStream);
            if (password == null) {
                elOStream.writeObject(el);
                idOStream.writeObject(id);
            } else {
                elOStream.writeObject(this.convertObjectToBytes(el, password));
                idOStream.writeObject(this.convertObjectToBytes(id, password));
            }
            elOStream.flush();
            idOStream.flush();
            elOStream.close();
            idOStream.close();
            this.m_element = new ByteArrayWrapper(elByteStream.toByteArray());
            this.m_id = new ByteArrayWrapper(idByteStream.toByteArray());
        }
    }

    public String getElementName() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.m_elementName;
    }

    public void setElementName(String name) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this.m_elementName != null) {
            ObjectStore.destroy((Object)this.m_elementName);
        }
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this.m_elementName = name;
    }

    public byte[] getElement() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this.m_element != null) {
            return this.m_element.getBytes();
        }
        return null;
    }

    public DSBlob getBlob() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.m_blob;
    }

    public void setBlob(DSBlob blob) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this.m_blob != null) {
            ObjectStore.destroy((IPersistent)this.m_blob);
        }
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this.m_blob = blob;
    }

    public IDirElement getIDirElement(String password) throws Exception {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this.m_element != null) {
            IDirElement el;
            byte[] abyte0 = this.m_element.getBytes();
            if (abyte0 != null) {
                ObjectStore.fetch((byte[])abyte0);
            }
            ByteArrayInputStream elByteStream = new ByteArrayInputStream(abyte0);
            ObjectInputStream elInputStream = new ObjectInputStream(elByteStream);
            if (password == null) {
                try {
                    el = (IDirElement)elInputStream.readObject();
                }
                catch (ClassCastException castE) {
                    throw new DSEncryptionException("Directory Service data is encrypted and requires a password");
                }
            } else {
                el = (IDirElement)this.readEncryptedData(elInputStream, password);
            }
            return el;
        }
        return null;
    }

    public IElementIdentity getElementIdentity(String password) throws Exception {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this.m_id != null) {
            IElementIdentity id;
            byte[] abyte0 = this.m_id.getBytes();
            if (abyte0 != null) {
                ObjectStore.fetch((byte[])abyte0);
            }
            ByteArrayInputStream idByteStream = new ByteArrayInputStream(abyte0);
            ObjectInputStream idInputStream = new ObjectInputStream(idByteStream);
            if (password == null) {
                try {
                    id = (IElementIdentity)idInputStream.readObject();
                }
                catch (ClassCastException castE) {
                    throw new DSEncryptionException("Directory Service data is encrypted and needs a password");
                }
            } else {
                id = (IElementIdentity)this.readEncryptedData(idInputStream, password);
            }
            return id;
        }
        return null;
    }

    public void setElement(byte[] element) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this.m_element != null) {
            ObjectStore.destroy((IPersistent)this.m_element);
        }
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this.m_element = new ByteArrayWrapper(element);
    }

    public String getParentDirectory() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        String parentName = "";
        try {
            parentName = new EntityName(this.m_elementName).getParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parentName;
    }

    public String getGroupName() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        EntityName myEName = null;
        try {
            myEName = new EntityName(this.m_elementName);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        if (myEName != null && PackedDirUtil.underPackedDir(myEName)) {
            return myEName.getParentEntity().createChild(this.hashFunction(myEName.getBaseName())).getName();
        }
        return null;
    }

    private String hashFunction(String elementName) {
        int fileIndex = elementName.hashCode();
        if (fileIndex < 0) {
            fileIndex *= -1;
        }
        int a0 = fileIndex;
        int a1 = a0 / 256;
        int a2 = a1 / 256;
        int a3 = a2 / 256;
        fileIndex = (a0 & 0xFF ^ a1 & 0xFF ^ a2 & 0xFF ^ a3 & 0xFF) % 64;
        return "_MF" + new Integer(fileIndex).toString();
    }

    private byte[] convertObjectToBytes(Object data, String password) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(out);
        objectOut.writeObject(data);
        byte[] abyte0 = out.toByteArray();
        if (abyte0 != null) {
            ObjectStore.fetch((byte[])abyte0);
        }
        byte[] encBytes = PBE.encrypt(abyte0, password);
        out.close();
        return encBytes;
    }

    private Object readEncryptedData(ObjectInputStream input, String password) throws Exception {
        Object inS = input.readObject();
        byte[] abyte0 = null;
        try {
            abyte0 = (byte[])inS;
        }
        catch (ClassCastException castE) {
            throw new DSEncryptionException("Directory Service data is not encrypted and a password was provided.");
        }
        if (abyte0 != null) {
            ObjectStore.fetch((byte[])abyte0);
        }
        byte[] bytes = null;
        try {
            bytes = PBE.decrypt(abyte0, password);
        }
        catch (EncryptionException encrE) {
            throw new DSEncryptionException("Given password is incorrect.", encrE);
        }
        if (bytes != null) {
            ObjectStore.fetch((byte[])bytes);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream object = new ObjectInputStream(in);
        return object.readObject();
    }

    public void preDestroyPersistent() {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        ObjectStore.destroy((Object)this.m_elementName);
        this.m_elementName = null;
        ObjectStore.destroy((IPersistent)this.m_element);
        this.m_element = null;
        ObjectStore.destroy((IPersistent)this.m_id);
        this.m_id = null;
        if (this.m_blob != null && !this.m_keepBlob) {
            ObjectStore.destroy((IPersistent)this.m_blob);
            this.m_blob = null;
        }
        this.m_keepBlob = false;
    }

    public void keepBlob(boolean keepBlob) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this.m_keepBlob = keepBlob;
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectreference) {
        this.ODIref = objectreference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte byte0) {
        this.ODIObjectState = byte0;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        DSElement dselement = (DSElement)super.clone();
        dselement.ODITheHashCode = dselement.ODIComputeHashCode();
        dselement.ODIref = null;
        dselement.ODIObjectState = 0;
        return dselement;
    }

    public void postInitializeContents() {
    }

    public void preFlushContents() {
    }

    public void preClearContents() {
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.ODITheHashCode;
    }

    private int ODIComputeHashCode() {
        return HashPersistent.getNextHashCode();
    }

    public void initializeContents(GenericObject genericobject) {
        ClassInfo classinfo = myOdiClassInfoInstance;
        this.ODITheHashCode = genericobject.getIntField(1, classinfo);
        this.m_elementName = genericobject.getStringField(2, classinfo);
        this.m_element = (ByteArrayWrapper)genericobject.getClassField(3, classinfo);
        this.m_id = (ByteArrayWrapper)genericobject.getClassField(4, classinfo);
        this.m_blob = (DSBlob)genericobject.getClassField(5, classinfo);
    }

    public void flushContents(GenericObject genericobject) {
        ClassInfo classinfo = myOdiClassInfoInstance;
        genericobject.setIntField(1, this.ODITheHashCode, classinfo);
        genericobject.setStringField(2, this.m_elementName, classinfo);
        genericobject.setClassField(3, (Object)this.m_element, classinfo);
        genericobject.setClassField(4, (Object)this.m_id, classinfo);
        genericobject.setClassField(5, (Object)this.m_blob, classinfo);
    }

    public void clearContents() {
        this.ODITheHashCode = 0;
        this.m_elementName = null;
        this.m_element = null;
        this.m_id = null;
        this.m_blob = null;
    }

    public DSElement(ClassInfo classinfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        try {
            return ClassInfo.get(Class.forName("com.sonicsw.mf.framework.directory.storage.pse.DSElement"));
        }
        catch (ClassNotFoundException classnotfoundexception) {
            return null;
        }
    }
}

