/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.security;

import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.security.AuthenticationPrincipalMap;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

abstract class AbstractPermissionsMap
extends HashMap {
    private static final boolean DEBUG = System.getProperty("com.sonicsw.debugFGS") != null;
    AuthenticationPrincipalMap m_authenticationPrincipalMap;
    IFrameworkComponentContext m_context;
    private String m_configID;
    static final int ALLOW = 1;
    static final int DENY = -1;
    static final int NONE = 0;

    AbstractPermissionsMap(IFrameworkComponentContext context, AuthenticationPrincipalMap authenticationPrincipalMap, String configID) {
        IElement permissions;
        block3: {
            this.m_context = context;
            this.m_authenticationPrincipalMap = authenticationPrincipalMap;
            this.m_configID = configID;
            permissions = null;
            try {
                permissions = context.getConfiguration(configID, true);
            }
            catch (MFRuntimeException e) {
                if (e.getLinkedException() != null && e.getLinkedException() instanceof DirectoryDoesNotExistException) break block3;
                throw e;
            }
        }
        if (permissions == null) {
            return;
        }
        this.initPermissionsMap(permissions);
    }

    private void initPermissionsMap(IElement permissions) {
        IAttributeSet attributes = permissions.getAttributes();
        HashMap pathMap = attributes.getAttributes();
        for (Map.Entry entry : pathMap.entrySet()) {
            this.addPermissions((String)entry.getKey(), (IAttributeSet)entry.getValue());
        }
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        IBasicElement element = elementChange.getElement();
        if (!element.getIdentity().getName().equals(this.m_configID)) {
            return;
        }
        switch (elementChange.getChangeType()) {
            case 1: {
                IDeltaElement changeElement = (IDeltaElement)element;
                IDeltaAttributeSet changes = (IDeltaAttributeSet)changeElement.getDeltaAttributes();
                this.handleNewPermissions(changes);
                this.handleModifiedPermissions(changes);
                this.handleDeletedPermissions(changes);
                break;
            }
            case 0: {
                this.initPermissionsMap((IElement)element);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void handleNewPermissions(IDeltaAttributeSet changes) {
        String[] newPermissions = changes.getNewAttributesNames();
        for (int i = 0; i < newPermissions.length; ++i) {
            try {
                IAttributeSet pathPermissionsAttrs = (IAttributeSet)changes.getNewValue(newPermissions[i]);
                this.addPermissions(newPermissions[i], pathPermissionsAttrs);
                continue;
            }
            catch (NotModifiedAttException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleModifiedPermissions(IDeltaAttributeSet changes) {
        String[] modifiedPermissions = changes.getModifiedAttributesNames();
        for (int i = 0; i < modifiedPermissions.length; ++i) {
            try {
                IDeltaAttributeSet pathPermissionsAttrs = (IDeltaAttributeSet)changes.getNewValue(modifiedPermissions[i]);
                this.handleNewPermission(modifiedPermissions[i], pathPermissionsAttrs);
                this.handleModifiedPermission(modifiedPermissions[i], pathPermissionsAttrs);
                this.handleDeletedPermission(modifiedPermissions[i], pathPermissionsAttrs);
                continue;
            }
            catch (NotModifiedAttException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleDeletedPermissions(IDeltaAttributeSet changes) {
        String[] deletedPermissions = changes.getDeletedAttributesNames();
        for (int i = 0; i < deletedPermissions.length; ++i) {
            this.deletePermissions(deletedPermissions[i]);
        }
    }

    private void handleNewPermission(String path, IDeltaAttributeSet changes) {
        String[] newPermissions = changes.getNewAttributesNames();
        for (int i = 0; i < newPermissions.length; ++i) {
            try {
                this.addPermission(path, newPermissions[i], (IAttributeSet)changes.getNewValue(newPermissions[i]));
                continue;
            }
            catch (NotModifiedAttException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleModifiedPermission(String path, IDeltaAttributeSet changes) {
        String[] modifiedPermissions = changes.getModifiedAttributesNames();
        for (int i = 0; i < modifiedPermissions.length; ++i) {
            try {
                Object permissionAttrs = changes.getNewValue(modifiedPermissions[i]);
                if (DEBUG) {
                    System.out.println("AbstractPermissionsMap.handleModifiedPermission(): [use deletePermission() & addPermission()]");
                }
                this.deletePermission(path, modifiedPermissions[i]);
                if (permissionAttrs instanceof IAttributeSet) {
                    this.addPermission(path, modifiedPermissions[i], (IAttributeSet)permissionAttrs);
                    continue;
                }
                this.addPermission(path, modifiedPermissions[i], (IDeltaAttributeSet)permissionAttrs);
                continue;
            }
            catch (NotModifiedAttException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleDeletedPermission(String path, IDeltaAttributeSet changes) {
        String[] deletedPermissions = changes.getDeletedAttributesNames();
        for (int i = 0; i < deletedPermissions.length; ++i) {
            this.deletePermission(path, deletedPermissions[i]);
        }
    }

    private synchronized void addPermissions(String escapedPath, IAttributeSet permissionsSet) {
        HashMap permissionMap = permissionsSet.getAttributes();
        if (permissionMap.isEmpty()) {
            super.remove(escapedPath);
            return;
        }
        for (Map.Entry entry : permissionMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof IAttributeSet)) continue;
            this.addPermission(escapedPath, (String)entry.getKey(), (IAttributeSet)value);
        }
    }

    private synchronized void addPermission(String escapedPath, String principal, IAttributeSet permissionAttributes) {
        this.addPermission(escapedPath, principal, (String)permissionAttributes.getAttribute("VALUE"));
    }

    private synchronized void addPermission(String escapedPath, String principal, IDeltaAttributeSet permissionAttributes) throws NotModifiedAttException {
        this.addPermission(escapedPath, principal, (String)permissionAttributes.getNewValue("VALUE"));
    }

    private synchronized void addPermission(String escapedPath, String principal, String delimitedValue) {
        HashMap<String, Permission> permissions = (HashMap<String, Permission>)super.get(escapedPath);
        if (permissions == null) {
            permissions = new HashMap<String, Permission>();
            super.put(escapedPath, permissions);
        }
        Permission permission = new Permission(delimitedValue);
        permissions.put(principal, permission);
        if (DEBUG) {
            System.out.println("AbstractPermissionsMap.addPermission(): path=" + this.unescapePath(escapedPath) + ", principal=" + principal + ", scope=" + permission.permissionScope + ", permission=" + permission.permissionValue);
        }
    }

    private synchronized void deletePermissions(String escapedPath) {
        super.remove(escapedPath);
        if (DEBUG) {
            System.out.println("AbstractPermissionsMap.deletePermissions(): path=" + this.unescapePath(escapedPath));
        }
    }

    private synchronized void deletePermission(String escapedPath, String principal) {
        HashMap permissions = (HashMap)super.get(escapedPath);
        if (permissions == null) {
            return;
        }
        permissions.remove(principal);
        if (DEBUG) {
            System.out.println("AbstractPermissionsMap.deletePermission(): path=" + this.unescapePath(escapedPath) + ", principal=" + principal);
        }
    }

    boolean hasPermission(String principal, String path, int requiredPermission, int scope) {
        String[] groups = this.m_authenticationPrincipalMap.getGroups(principal);
        return this.hasPermission(principal, path, groups, requiredPermission, scope);
    }

    boolean hasPermission(String principal, String path, String[] groups, int requiredPermission, int scope) {
        int result = -1;
        while (true) {
            if ((result = this.checkPermission(principal, path, groups, requiredPermission, scope)) == 1) {
                return true;
            }
            if (result == -1) {
                return false;
            }
            if (path.equals("/")) break;
            path = this.getParentPath(path);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int checkPermission(String principal, String path, String[] groups, int requiredPermission, int scope) {
        int result = 0;
        try {
            HashMap permissions = (HashMap)super.get(this.escapePath(path));
            if (permissions != null && !permissions.isEmpty()) {
                Permission permission = null;
                permission = (Permission)permissions.get(principal);
                if (permission != null && (result = this.checkPermission(permission, scope, requiredPermission)) != 0) {
                    int n = result;
                    return n;
                }
                boolean foundDeny = false;
                for (int i = 0; i < groups.length; ++i) {
                    permission = (Permission)permissions.get(groups[i]);
                    if (permission == null) continue;
                    result = this.checkPermission(permission, scope, requiredPermission);
                    if (result == 1) {
                        int n = 1;
                        return n;
                    }
                    if (result != -1) continue;
                    foundDeny = true;
                }
                if (foundDeny) {
                    int n = -1;
                    return n;
                }
            }
            int n = result;
            return n;
        }
        finally {
            if (DEBUG) {
                System.out.println("AbstractPermissionsMap.checkPermission(): principal=" + principal + ", path=" + path + ", requiredPermission=" + requiredPermission + ", scope=" + scope + ", result=" + result);
            }
        }
    }

    int checkPermission(Permission permission, int scope, int requiredPermission) {
        if ((permission.permissionScope & scope) != scope) {
            return 0;
        }
        if ((permission.permissionValue & requiredPermission) > 0) {
            return 1;
        }
        if ((permission.permissionValue & requiredPermission << 1) > 0) {
            return -1;
        }
        return 0;
    }

    String getParentPath(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.substring(0, path.lastIndexOf(47) + 1);
    }

    void cleanup() {
        block2: {
            try {
                this.m_context.getConfiguration(this.m_configID, false);
            }
            catch (MFRuntimeException e) {
                if (e.getLinkedException() != null || e.getLinkedException() instanceof DirectoryDoesNotExistException) break block2;
                throw e;
            }
        }
        super.clear();
    }

    private String escapePath(String path) {
        path = path.replaceAll("/", "_0x2F_");
        path = path.replaceAll(" ", "_0x20_");
        return path;
    }

    private String unescapePath(String escapedPath) {
        escapedPath = escapedPath.replaceAll("_0x2F_", "/");
        escapedPath = escapedPath.replaceAll("_0x20_", " ");
        return escapedPath;
    }

    final class Permission {
        int permissionValue;
        int permissionScope;

        private Permission(String delimitedValue) {
            StringTokenizer tokenizer = new StringTokenizer(delimitedValue, ":");
            try {
                this.permissionScope = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                this.permissionValue = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }
}

