/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.security;

import com.sonicsw.mf.common.IXMLFragment;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IFSElementChange;
import com.sonicsw.mf.common.util.ObjectNameHelper;
import com.sonicsw.mf.framework.IAuditManager;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.agent.TaskScheduler;
import com.sonicsw.mf.framework.security.CheckedAPI;
import java.lang.reflect.Array;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.xerces.impl.dv.util.Base64;

public class AuditManager
implements IAuditManager {
    private static final boolean DEBUG = System.getProperty("sonicsw.mf.debugFGS") != null;
    private static final String EXTENDED_AUDIT_BEHAVIOR_PROPERTY = "sonicsw.mf.auditExt";
    private static final HashMap<String, ArrayList<String>> EXTENDED_AUDIT_BEHAVIOR_MAP = new HashMap();
    private static final String DOMAIN_CONFIG_ID = "/domain/domain";
    private static final String CONFIGURE_LOGGER = "sonicmf.audit.configure";
    private static final String MANAGE_LOGGER = "sonicmf.audit.manage";
    private IFrameworkComponentContext m_context;
    private MBeanServer m_mBeanServer;
    private String m_containerConfigID;
    private boolean m_auditConfigureEvents = false;
    private boolean m_auditManageEvents = false;
    private boolean m_enableCentralizedAudit = false;
    private static final int MAX_EVENT_QUEUE_SIZE = 250;
    private ArrayList<Runnable> m_configureEventQueue = new ArrayList();
    private ArrayList<Runnable> m_manageEventQueue = new ArrayList();
    private Thread m_configureEventLogger;
    private Thread m_manageEventLogger;
    private String m_defaultAuditConfig;
    private String m_localAuditConfig;
    private String m_lastAuditConfig = "";
    private static final String[] CONFIGURE_ACTIONS = new String[]{"create", "update", "delete", "rename"};
    public static final int CREATE_ACTION = 0;
    public static final int UPDATE_ACTION = 1;
    public static final int DELETE_ACTION = 2;
    public static final int RENAME_ACTION = 3;
    private static final String ANONYMOUS_USER = "anonymous";
    private String m_agentManager;
    private static final String RECORD_AUDIT_EVENT_OPERATION_NAME = "recordAuditEvent";
    private static final String[] RECORD_AUDIT_EVENT_OPERATION_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), String.class.getName()};
    private final SimpleDateFormat m_dateTimeFormatter = new SimpleDateFormat("yy/MM/dd HH:mm:ss");

    public AuditManager(IFrameworkComponentContext context, MBeanServer mBeanServer) {
        this.m_context = context;
        this.m_mBeanServer = mBeanServer;
        this.m_agentManager = this.m_context.getComponentName().getDomainName() + '.' + "AGENT MANAGER" + ":ID=" + "AGENT MANAGER";
        this.initAuditManager();
    }

    private void initAuditManager() {
        Boolean enableCentralizedAudit;
        Boolean auditManageEvents;
        IElement domainConfiguration = null;
        try {
            domainConfiguration = this.m_context.getConfiguration(DOMAIN_CONFIG_ID, true);
        }
        catch (MFRuntimeException e) {
            // empty catch block
        }
        if (domainConfiguration == null) {
            return;
        }
        IAttributeSet domainAttributes = domainConfiguration.getAttributes();
        Boolean auditConfigureEvents = (Boolean)domainAttributes.getAttribute("AUDIT_CONFIGURE_EVENTS");
        boolean bl = this.m_auditConfigureEvents = auditConfigureEvents == null ? false : auditConfigureEvents;
        if (this.m_auditConfigureEvents && this.m_configureEventLogger == null) {
            this.m_configureEventLogger = new AsyncEventLogger("Configure", this.m_configureEventQueue);
            this.m_configureEventLogger.start();
            if (this.m_context.getContainer().isHostingComponent("DIRECTORY SERVICE")) {
                this.m_context.getContainer().logMessage(null, "Auditing of configure events enabled", 4);
            }
        }
        if (!this.m_auditConfigureEvents && this.m_configureEventLogger != null) {
            this.m_configureEventLogger.interrupt();
            this.m_configureEventLogger = null;
            if (this.m_context.getContainer().isHostingComponent("DIRECTORY SERVICE")) {
                this.m_context.getContainer().logMessage(null, "Auditing of configure events disabled", 4);
            }
        }
        boolean bl2 = this.m_auditManageEvents = (auditManageEvents = (Boolean)domainAttributes.getAttribute("AUDIT_MANAGE_EVENTS")) == null ? false : auditManageEvents;
        if (this.m_auditManageEvents && this.m_manageEventLogger == null) {
            this.m_manageEventLogger = new AsyncEventLogger("Manage", this.m_manageEventQueue);
            this.m_manageEventLogger.start();
            this.m_context.getContainer().logMessage(null, "Auditing of manage events enabled", 4);
        }
        if (!this.m_auditManageEvents && this.m_manageEventLogger != null) {
            this.m_manageEventLogger.interrupt();
            this.m_manageEventLogger = null;
            this.m_context.getContainer().logMessage(null, "Auditing of manage events disabled", 4);
        }
        this.m_enableCentralizedAudit = (enableCentralizedAudit = (Boolean)domainAttributes.getAttribute("ENABLE_CENTRALIZED_AUDIT")) == null ? false : enableCentralizedAudit;
        this.m_defaultAuditConfig = (String)domainAttributes.getAttribute("DEFAULT_MANAGEMENT_AUDIT_CONFIG");
        if (this.m_defaultAuditConfig != null && this.m_defaultAuditConfig.length() == 0) {
            this.m_defaultAuditConfig = null;
        }
        IElement containerConfiguration = this.m_context.getConfiguration(true);
        this.m_containerConfigID = containerConfiguration.getIdentity().getName();
        IAttributeSet containerAttrs = containerConfiguration.getAttributes();
        this.m_localAuditConfig = (String)containerAttrs.getAttribute("MANAGEMENT_AUDIT_CONFIG");
        if (this.m_localAuditConfig != null && this.m_localAuditConfig.length() == 0) {
            this.m_localAuditConfig = null;
        }
        String currentAuditConfig = this.m_localAuditConfig == null || this.m_localAuditConfig.length() == 0 ? this.m_defaultAuditConfig : this.m_localAuditConfig;
        this.initLog4j(currentAuditConfig);
    }

    private void initLog4j(String auditConfig) {
        URL url;
        if (!this.m_auditConfigureEvents && !this.m_auditManageEvents) {
            return;
        }
        if (auditConfig == null) {
            if (this.m_lastAuditConfig != null) {
                this.m_context.getContainer().logMessage(null, "Default audit destination(s) configuration will be used", 4);
            }
        } else {
            if (auditConfig.equals(this.m_lastAuditConfig)) {
                return;
            }
            if (this.m_lastAuditConfig == null || !auditConfig.equals(this.m_lastAuditConfig)) {
                this.m_context.getContainer().logMessage(null, "Audit destination(s) configuration file used: " + auditConfig, 4);
            }
        }
        if (this.m_lastAuditConfig != null && this.m_lastAuditConfig.length() > 0 && !this.m_lastAuditConfig.equals(auditConfig)) {
            url = null;
            try {
                url = new URL(this.m_lastAuditConfig);
                if (url.getProtocol().equals("sonicfs")) {
                    this.m_context.unregisterFileChangeInterest(this.m_lastAuditConfig);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.m_lastAuditConfig = auditConfig;
        if (auditConfig == null || auditConfig.length() == 0) {
            PropertyConfigurator.configure((Properties)this.createDefaultAuditConfig());
            return;
        }
        url = null;
        try {
            url = new URL(auditConfig);
        }
        catch (Throwable e) {
            this.m_context.getContainer().logMessage(null, "Exception occurred while attempting to load log4j configuration file " + auditConfig + ", trace follows...", e, 1);
        }
        if (null != url && "sonicfs".equals(url.getProtocol())) {
            this.m_context.registerFileChangeInterest(auditConfig);
        }
        try {
            if (auditConfig.endsWith(".xml")) {
                DOMConfigurator.configure((URL)url);
            } else {
                PropertyConfigurator.configure((URL)url);
            }
        }
        catch (Throwable e) {
            this.m_context.getContainer().logMessage(null, "Exception occurred while attempting to load log4j configuration file " + auditConfig + ", trace follows...", e, 1);
            this.initLog4j(null);
        }
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        IElementIdentity id = elementChange.getElement().getIdentity();
        String configID = id.getName();
        if ((configID.startsWith(DOMAIN_CONFIG_ID) || elementChange.getElement().getIdentity().getName().equals(this.m_containerConfigID)) && elementChange.getChangeType() == 1) {
            this.initAuditManager();
        }
    }

    public synchronized void handleFileChange(IFSElementChange fileChange) {
        if (this.m_lastAuditConfig != null && this.m_lastAuditConfig.length() > 0) {
            URL url = null;
            try {
                url = new URL(this.m_lastAuditConfig);
            }
            catch (Throwable e) {
                this.m_context.getContainer().logMessage(null, "Exception occurred while handling a dynamic configuration change " + this.m_lastAuditConfig + ", trace follows...", e, 1);
            }
            if (fileChange.getChangeType() == 2) {
                this.m_context.getContainer().logMessage(null, "Audit configuration file " + this.m_lastAuditConfig + " has been deleted; correct before container restart", 2);
                return;
            }
            if (url != null && fileChange.getLogicalPath().equals(url.getPath())) {
                this.initAuditManager();
            }
        }
    }

    private void appendPath(StringBuilder sb, String path, String type) {
        if (path != null && path.length() > 0) {
            sb.append("<audit:path type=\"").append(type).append("\">").append(path).append("</audit:path>");
        }
    }

    public void recordConfigureEvent(String[] logicalPaths, String[] storagePaths, int[] actions, String[] details) {
        if (!this.m_auditConfigureEvents) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.addEventElementHeader(sb, "info");
        for (int i = 0; i < logicalPaths.length; ++i) {
            sb.append("<audit:configure>");
            this.appendPath(sb, logicalPaths[i], "logical");
            this.appendPath(sb, storagePaths[i], "storage");
            sb.append("<audit:action>").append(CONFIGURE_ACTIONS[actions[i]]).append("</audit:action>");
            sb.append("<audit:details>").append(details[i]).append("</audit:details>");
            sb.append("</audit:configure>");
        }
        this.addEventElementTrailer(sb);
        this.recordEvent(CONFIGURE_LOGGER, true, this.m_configureEventQueue, sb.toString());
    }

    public void recordConfigurePermissionDeniedEvent(String logicalPath, String storagePath, int requiredPermission) {
        if (!this.m_auditConfigureEvents) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.addEventElementHeader(sb, "warning");
        sb.append("<audit:configurePermissionDenied").append(" requiredPermission=\"").append(this.getConfigurePermissionDescription(requiredPermission)).append("\">");
        this.appendPath(sb, logicalPath, "logical");
        this.appendPath(sb, storagePath, "storage");
        sb.append("</audit:configurePermissionDenied>");
        this.addEventElementTrailer(sb);
        this.recordEvent(CONFIGURE_LOGGER, true, this.m_configureEventQueue, sb.toString());
    }

    public void recordManageEvent(ObjectName objectName, MBeanInfo mBeanInfo, String operationName, Object[] params, Object returnValue) {
        if (!this.m_auditManageEvents) {
            return;
        }
        if (mBeanInfo == null && DEBUG) {
            System.out.println("AuditManager.recordManageEvent(): Called with MBeanInfo, stack dump follows...");
            Thread.dumpStack();
        }
        if (!this.isAuditableAction(objectName, mBeanInfo, operationName)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.addEventElementHeader(sb, "info");
        sb.append("<audit:manage>");
        sb.append("<audit:target>").append(objectName == null ? "[MBeanServer]" : objectName.getCanonicalName()).append("</audit:target>");
        sb.append("<audit:operation>").append(operationName).append("</audit:operation>");
        for (int i = 0; i < params.length; ++i) {
            sb.append("<audit:param index=\"").append(i).append("\">");
            this.appendXMLFragment(sb, params[i]);
            sb.append("</audit:param>");
        }
        if (returnValue != null) {
            sb.append("<audit:return>");
            this.appendXMLFragment(sb, returnValue);
            sb.append("</audit:return>");
        }
        sb.append("</audit:manage>");
        this.addEventElementTrailer(sb);
        this.recordEvent(MANAGE_LOGGER, false, this.m_manageEventQueue, sb.toString());
    }

    public void recordManagePermissionDeniedEvent(ObjectName objectName, String operationName, int requiredPermission) {
        if (!this.m_auditManageEvents) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.addEventElementHeader(sb, "warning");
        sb.append("<audit:managePermissionDenied").append(" requiredPermission=\"").append(this.getManagePermissionDescription(requiredPermission)).append("\">");
        sb.append("<audit:target>").append(objectName == null ? "[MBeanServer]" : objectName.getCanonicalName()).append("</audit:target>");
        sb.append("<audit:operation>").append(operationName).append("</audit:operation>");
        sb.append("</audit:managePermissionDenied>");
        this.addEventElementTrailer(sb);
        this.recordEvent(MANAGE_LOGGER, false, this.m_manageEventQueue, sb.toString());
    }

    private Properties createDefaultAuditConfig() {
        String auditFilePrefix = this.m_context.getComponentName().getDomainName() + '.' + this.m_context.getComponentName().getContainerName() + '.';
        Properties log4jProperties = new Properties();
        log4jProperties.setProperty("log4j.rootLogger", "DEBUG, ROOT");
        log4jProperties.setProperty("log4j.appender.ROOT", "org.apache.log4j.varia.NullAppender");
        log4jProperties.setProperty("log4j.appender.ROOT.layout", "org.apache.log4j.PatternLayout");
        log4jProperties.setProperty("log4j.appender.ROOT.layout.ConversionPattern", "%n");
        log4jProperties.setProperty("log4j.logger.sonicmf.audit.configure", "DEBUG, CONFIGURE");
        log4jProperties.setProperty("log4j.appender.CONFIGURE", "org.apache.log4j.DailyRollingFileAppender");
        log4jProperties.setProperty("log4j.appender.CONFIGURE.layout", "com.sonicsw.mf.framework.security.AuditXMLLayout");
        log4jProperties.setProperty("log4j.appender.CONFIGURE.layout.PrettyXML", "false");
        log4jProperties.setProperty("log4j.appender.CONFIGURE.File", auditFilePrefix + "configure.audit");
        log4jProperties.setProperty("log4j.appender.CONFIGURE.BufferedIO", "false");
        log4jProperties.setProperty("log4j.appender.CONFIGURE.DatePattern", "'.'yyyy-MM-dd");
        log4jProperties.setProperty("log4j.appender.CONFIGURE.ImmediateFlush", "true");
        log4jProperties.setProperty("log4j.additivity.CONFIGURE", "true");
        log4jProperties.setProperty("log4j.logger.sonicmf.audit.manage", " DEBUG, MANAGE");
        log4jProperties.setProperty("log4j.appender.MANAGE", "org.apache.log4j.DailyRollingFileAppender");
        log4jProperties.setProperty("log4j.appender.MANAGE.layout", "com.sonicsw.mf.framework.security.AuditXMLLayout");
        log4jProperties.setProperty("log4j.appender.MANAGE.layout.PrettyXML", "false");
        log4jProperties.setProperty("log4j.appender.MANAGE.File", auditFilePrefix + "manage.audit");
        log4jProperties.setProperty("log4j.appender.MANAGE.BufferedIO", "false");
        log4jProperties.setProperty("log4j.appender.MANAGE.DatePattern", "'.'yyyy-MM-dd");
        log4jProperties.setProperty("log4j.appender.MANAGE.ImmediateFlush", "true");
        log4jProperties.setProperty("log4j.additivity.MANAGE", "true");
        return log4jProperties;
    }

    private String getConfigurePermissionDescription(int requiredPermission) {
        switch (requiredPermission) {
            case 1: {
                return "Read";
            }
            case 4: {
                return "Write";
            }
            case 16: {
                return "Delete";
            }
            case 64: {
                return "Set permissions";
            }
        }
        return "Unknown";
    }

    private String getManagePermissionDescription(int requiredPermission) {
        switch (requiredPermission) {
            case 1: {
                return "Life cycle control";
            }
            case 4: {
                return "Enable/disable metrics";
            }
            case 16: {
                return "Subscribe to notifications";
            }
            case 64: {
                return "Set attributes";
            }
            case 256: {
                return "Other actions";
            }
            case 1024: {
                return "Get information";
            }
        }
        return "Unknown";
    }

    private boolean isAuditableAction(ObjectName objectName, MBeanInfo mBeanInfo, String operationName) {
        if (objectName == null) {
            return CheckedAPI.isMBeanServerAPI(operationName);
        }
        if (CheckedAPI.isLifeCycleAPI(operationName)) {
            return true;
        }
        if (CheckedAPI.isEnableDisableMetricsAPI(operationName)) {
            return true;
        }
        if (CheckedAPI.isSetAttributesAPI(operationName)) {
            return true;
        }
        boolean isMFComponent = ObjectNameHelper.isMFComponentName((ObjectName)objectName);
        if (isMFComponent && CheckedAPI.isMBeanActionAPI(mBeanInfo, operationName)) {
            if (ObjectNameHelper.getMFComponentName((ObjectName)objectName).equals("DIRECTORY SERVICE")) {
                if (CheckedAPI.isCheckedDSAPI(operationName)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        for (Map.Entry<String, ArrayList<String>> entry : EXTENDED_AUDIT_BEHAVIOR_MAP.entrySet()) {
            ObjectName name;
            try {
                name = new ObjectName(entry.getKey());
            }
            catch (MalformedObjectNameException e) {
                this.m_context.logMessage("Invalid JMX ObjectName specified in sonicsw.mf.auditExt property, trace follows...", (Throwable)e, 2);
                continue;
            }
            ArrayList<String> auditableItems = entry.getValue();
            for (ObjectInstance mBeanInstance : this.m_mBeanServer.queryMBeans(name, null)) {
                if (!mBeanInstance.getObjectName().equals(objectName)) continue;
                if (auditableItems.contains(operationName)) {
                    return true;
                }
                String impact = null;
                if (mBeanInfo == null) continue;
                MBeanOperationInfo[] operationInfos = mBeanInfo.getOperations();
                for (int i = 0; i < operationInfos.length; ++i) {
                    if (!operationInfos[i].getName().equals(operationName)) continue;
                    if (operationInfos[i].getImpact() == 1) {
                        impact = "ACTION";
                    }
                    if (operationInfos[i].getImpact() == 2) {
                        impact = "ACTION_INFO";
                    }
                    if (operationInfos[i].getImpact() == 0) {
                        impact = "INFO";
                    }
                    if (operationInfos[i].getImpact() != 3) break;
                    impact = "UNKNOWN";
                    break;
                }
                if (impact == null || !auditableItems.contains(impact)) continue;
                return true;
            }
        }
        return false;
    }

    private StringBuilder addEventElementHeader(StringBuilder sb, String level) {
        String dateTime = null;
        dateTime = this.m_dateTimeFormatter.format(new Date(System.currentTimeMillis()));
        String user = TaskScheduler.getCurrentUserID();
        if (user == null || user.length() == 0) {
            user = ANONYMOUS_USER;
        }
        sb.append("<audit:event");
        sb.append(" dateTime=\"").append(dateTime);
        sb.append("\" level=\"").append(level);
        sb.append("\" user=\"").append(user);
        sb.append("\">");
        return sb;
    }

    private StringBuilder addEventElementTrailer(StringBuilder sb) {
        sb.append("</audit:event>");
        return sb;
    }

    private void appendXMLFragment(StringBuilder sb, Object object) {
        if (object == null) {
            sb.append("null");
            return;
        }
        if (object instanceof IXMLFragment) {
            sb.append(((IXMLFragment)object).toXMLFragment());
            return;
        }
        if (object instanceof Collection) {
            object = ((Collection)object).toArray();
        }
        if (object.getClass().isArray()) {
            Class<?> componentType = object.getClass().getComponentType();
            if (!componentType.isPrimitive()) {
                Object[] array = object;
                sb.append("<list>");
                for (Object element : array) {
                    sb.append("<item>");
                    this.appendXMLFragment(sb, element);
                    sb.append("</item>");
                }
                sb.append("</list>");
            } else if (object instanceof byte[]) {
                sb.append("<bytes>");
                sb.append(Base64.encode((byte[])((byte[])object)));
                sb.append("</bytes>");
            } else {
                sb.append("<array length=\"");
                sb.append(Array.getLength(object));
                sb.append("\" type=\"");
                sb.append(object.getClass().getComponentType().getName());
                sb.append("\"/>");
            }
            return;
        }
        if (object instanceof Map) {
            sb.append("<map>");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                sb.append("<item>");
                sb.append("<key>");
                this.appendXMLFragment(sb, entry.getKey());
                sb.append("</key>");
                sb.append("<value>");
                this.appendXMLFragment(sb, entry.getValue());
                sb.append("</value>");
                sb.append("</item>");
            }
            sb.append("</map>");
            return;
        }
        if (object instanceof Attribute) {
            sb.append("<attribute name=\"").append(((Attribute)object).getName()).append("\">");
            sb.append(this.escapeReservedXMLCharacters(((Attribute)object).getValue().toString()));
            sb.append("</attribute>");
            return;
        }
        sb.append(this.escapeReservedXMLCharacters(object.toString()));
    }

    private String escapeReservedXMLCharacters(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public void recordEvent(String loggerName, String eventMessage) {
        if (loggerName.equals(CONFIGURE_LOGGER)) {
            this.recordEvent(loggerName, true, this.m_configureEventQueue, eventMessage);
        } else if (loggerName.equals(MANAGE_LOGGER)) {
            this.recordEvent(loggerName, false, this.m_manageEventQueue, eventMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordEvent(final String loggerName, final boolean isConfigureEvent, ArrayList<Runnable> eventQueue, final String eventMessage) {
        if (this.m_enableCentralizedAudit) {
            try {
                this.m_context.invoke(this.m_agentManager, RECORD_AUDIT_EVENT_OPERATION_NAME, new Object[]{this.m_context.getComponentName().getCanonicalName(), loggerName, eventMessage}, RECORD_AUDIT_EVENT_OPERATION_SIGNATURE, false, 0L);
            }
            catch (Exception e) {
                this.m_context.getContainer().logMessage(null, "Failed to record audit event at Domain Manager, trace follows...", (Throwable)e, 1);
            }
        }
        Runnable logTask = new Runnable(){

            @Override
            public void run() {
                if (isConfigureEvent ? !AuditManager.this.m_auditConfigureEvents : !AuditManager.this.m_auditManageEvents) {
                    return;
                }
                Logger logger = Logger.getLogger((String)loggerName);
                logger.info((Object)eventMessage);
            }
        };
        ArrayList<Runnable> arrayList = eventQueue;
        synchronized (arrayList) {
            eventQueue.add(logTask);
            eventQueue.notifyAll();
        }
    }

    public boolean configureAuditingEnabled() {
        return this.m_auditConfigureEvents;
    }

    static {
        String auditExt = System.getProperty(EXTENDED_AUDIT_BEHAVIOR_PROPERTY);
        if (auditExt != null) {
            StringTokenizer nameAuditingPairs = new StringTokenizer(auditExt, ";");
            while (nameAuditingPairs.hasMoreTokens()) {
                String auditingString;
                StringTokenizer nameAuditingPair = new StringTokenizer(nameAuditingPairs.nextToken(), "|");
                String name = nameAuditingPair.nextToken();
                if (name.length() <= 0 || (auditingString = nameAuditingPair.nextToken()).length() <= 0) continue;
                ArrayList<String> auditableItems = new ArrayList<String>();
                StringTokenizer auditingItems = new StringTokenizer(auditingString, ",");
                while (auditingItems.hasMoreTokens()) {
                    auditableItems.add(auditingItems.nextToken());
                }
                EXTENDED_AUDIT_BEHAVIOR_MAP.put(name, auditableItems);
            }
        }
    }

    private final class AsyncEventLogger
    extends Thread {
        private ArrayList<Runnable> eventQueue;

        private AsyncEventLogger(String type, ArrayList<Runnable> eventQueue) {
            super("Async " + type + " Audit Event Logger");
            super.setDaemon(true);
            this.eventQueue = eventQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!AsyncEventLogger.interrupted()) {
                Runnable logTask = null;
                ArrayList<Runnable> arrayList = this.eventQueue;
                synchronized (arrayList) {
                    while (this.eventQueue.size() > 250) {
                        this.eventQueue.remove(0);
                    }
                    if (!this.eventQueue.isEmpty()) {
                        logTask = this.eventQueue.remove(0);
                    }
                }
                if (AsyncEventLogger.interrupted()) {
                    return;
                }
                if (logTask != null) {
                    try {
                        logTask.run();
                    }
                    catch (Throwable e) {
                        AuditManager.this.m_context.getContainer().logMessage(null, "Failed to record audit event, trace follows...", e, 1);
                    }
                    continue;
                }
                arrayList = this.eventQueue;
                synchronized (arrayList) {
                    if (AsyncEventLogger.interrupted()) {
                        return;
                    }
                    if (this.eventQueue.isEmpty()) {
                        try {
                            this.eventQueue.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            }
        }
    }
}

