/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.security;

import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mx.util.IEmptyArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class AuthenticationPrincipalMap
extends HashMap {
    private HashMap m_usersByConfigIDMap = new HashMap();
    private HashMap m_groupsByConfigIDMap = new HashMap();
    private HashMap m_externalGroupsToInternalGroups = new HashMap();
    private IComponentContext m_context;
    private String m_descriptorPath;
    private String m_usersDir;
    private String m_externalUsersDir;
    private String m_groupsDir;
    private String m_externalGroupsDir;
    private boolean m_externalDomain = false;
    private static final boolean DEBUG = System.getProperty("com.sonicsw.debugFGS") != null;

    protected AuthenticationPrincipalMap(IComponentContext context, String authenticationDomainDirectory, boolean external) {
        int i;
        this.m_context = context;
        this.m_externalDomain = external;
        this.m_descriptorPath = authenticationDomainDirectory + '/' + "_MFDomainDescriptor";
        this.updateGroupMap();
        this.m_usersDir = authenticationDomainDirectory + '/' + "_MFUsers";
        IElement[] userElements = this.getElements(this.m_usersDir);
        for (int i2 = 0; i2 < userElements.length; ++i2) {
            this.addUser(userElements[i2]);
        }
        this.m_externalUsersDir = authenticationDomainDirectory + "/external/" + "_MFUsers";
        if (this.m_externalDomain) {
            IElement[] externalUserElements = this.getElements(this.m_externalUsersDir);
            for (i = 0; i < externalUserElements.length; ++i) {
                this.addUser(externalUserElements[i]);
            }
        }
        this.m_groupsDir = authenticationDomainDirectory + '/' + "_MFGroups";
        IElement[] groupElements = this.getElements(this.m_groupsDir);
        for (i = 0; i < groupElements.length; ++i) {
            this.addGroup(groupElements[i]);
        }
        this.m_externalGroupsDir = authenticationDomainDirectory + "/external/" + "_MFGroups";
        if (this.m_externalDomain) {
            IElement[] externalGroupElements = this.getElements(this.m_externalGroupsDir);
            for (int i3 = 0; i3 < externalGroupElements.length; ++i3) {
                this.addGroup(externalGroupElements[i3]);
            }
        }
    }

    private IElement[] getElements(String dir) {
        boolean loggedFailure = false;
        while (true) {
            try {
                IElement[] elements = this.m_context.getConfigurations(dir, true);
                if (loggedFailure) {
                    this.m_context.logMessage("...security principal information retrieved", 3);
                }
                return elements;
            }
            catch (MFRuntimeException e) {
                Exception linkedException = e.getLinkedException();
                if (linkedException == null) {
                    throw e;
                }
                if (linkedException instanceof InvokeTimeoutCommsException) {
                    throw e;
                }
                if (linkedException instanceof InvokeTimeoutException) {
                    if (((IFrameworkComponentContext)this.m_context).getContainer().isClosing()) {
                        throw e;
                    }
                    if (loggedFailure) continue;
                    this.m_context.logMessage("Timeout while retrieving security principal information, retrying...", 2);
                    loggedFailure = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        IBasicElement element = elementChange.getElement();
        String configID = element.getIdentity().getName();
        if (configID.startsWith(this.m_usersDir) || configID.startsWith(this.m_externalUsersDir)) {
            switch (elementChange.getChangeType()) {
                case 0: {
                    this.addUser((IElement)element);
                    break;
                }
                case 2: {
                    this.removeUser(configID);
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    String user = (String)this.m_usersByConfigIDMap.remove(configID);
                    ArrayList groupList = (ArrayList)super.get(user);
                    this.removeUser(configID);
                    IElement replacementElement = this.m_context.getConfiguration(configID, true);
                    this.addUserForElementReplacedAction(replacementElement, groupList);
                    break;
                }
            }
        } else if (configID.startsWith(this.m_groupsDir) || configID.startsWith(this.m_externalGroupsDir)) {
            switch (elementChange.getChangeType()) {
                case 0: {
                    this.addGroup((IElement)element);
                    break;
                }
                case 2: {
                    this.removeGroup(configID);
                    break;
                }
                case 1: {
                    this.updateGroup((IDeltaElement)element);
                    break;
                }
                case 3: {
                    this.removeGroup(configID);
                    IElement replacementElement = this.m_context.getConfiguration(configID, true);
                    this.addGroup(replacementElement);
                    break;
                }
            }
        } else if (configID.equals(this.m_descriptorPath)) {
            this.updateGroupMap();
        }
    }

    public synchronized String[] getGroups(String user) {
        List groupList = (List)super.get(user);
        if (groupList == null) {
            if (DEBUG) {
                System.out.println("get groups: user " + user + " not found (or associated group info' missing)!");
            }
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }
        HashSet groupSetIncludingMappings = new HashSet(groupList);
        for (String group : groupList) {
            HashSet mappedGroups = (HashSet)this.m_externalGroupsToInternalGroups.get(group);
            if (mappedGroups == null) continue;
            Iterator internalGroups = mappedGroups.iterator();
            while (internalGroups.hasNext()) {
                groupSetIncludingMappings.add(internalGroups.next());
            }
        }
        return groupSetIncludingMappings.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    public short getPrincipalType(String principal) {
        if (super.containsKey(principal)) {
            return 1;
        }
        if (this.m_groupsByConfigIDMap.containsValue(principal)) {
            return 2;
        }
        return 0;
    }

    private void addUser(IElement userElement) {
        IAttributeSet userAttributes = userElement.getAttributes();
        String user = (String)userAttributes.getAttribute("USER_NAME");
        this.m_usersByConfigIDMap.put(userElement.getIdentity().getName(), user);
        ArrayList groupList = (ArrayList)super.get(user);
        if (groupList == null) {
            groupList = new ArrayList();
            super.put(user, groupList);
        }
        if (DEBUG) {
            System.out.println("add user (1): " + user);
        }
    }

    private void addUserForElementReplacedAction(IElement userElement, ArrayList groupListReplaceElement) {
        IAttributeSet userAttributes = userElement.getAttributes();
        String user = (String)userAttributes.getAttribute("USER_NAME");
        this.m_usersByConfigIDMap.put(userElement.getIdentity().getName(), user);
        ArrayList groupList = (ArrayList)super.get(user);
        if (groupList == null) {
            groupList = new ArrayList();
        }
        if (groupListReplaceElement == null) {
            groupListReplaceElement = new ArrayList();
        }
        groupList.addAll(groupListReplaceElement);
        HashSet tempSet = new HashSet(groupList);
        groupList.clear();
        groupList.addAll(tempSet);
        super.put(user, groupList);
        if (DEBUG) {
            System.out.println("add user (1): " + user);
        }
    }

    private void addGroup(IElement groupElement) {
        IAttributeSet groupMembers;
        IAttributeSet groupAttributes = groupElement.getAttributes();
        String group = (String)groupAttributes.getAttribute("GROUP_NAME");
        this.m_groupsByConfigIDMap.put(groupElement.getIdentity().getName(), group);
        if (DEBUG) {
            System.out.println("add group: " + group + " [" + groupElement.getIdentity().getName() + "]");
        }
        if ((groupMembers = (IAttributeSet)groupAttributes.getAttribute("GROUP_MEMBERS")) == null) {
            return;
        }
        for (String user : groupMembers.getAttributes().keySet()) {
            ArrayList<String> groupList = (ArrayList<String>)super.get(user);
            if (groupList == null) {
                groupList = new ArrayList<String>();
                super.put(user, groupList);
            }
            if (DEBUG) {
                System.out.println("add group: " + group + ", user: " + user);
            }
            if (groupList.contains(group)) continue;
            groupList.add(group);
        }
    }

    private void removeUser(String configID) {
        String user = (String)this.m_usersByConfigIDMap.remove(configID);
        if (DEBUG) {
            System.out.println("remove user: " + user);
        }
        super.remove(user);
    }

    private void removeGroup(String configID) {
        String group = (String)this.m_groupsByConfigIDMap.remove(configID);
        if (DEBUG) {
            System.out.println("remove group: " + group + " [" + configID + "]");
        }
        for (Map.Entry entry : super.entrySet()) {
            ArrayList groupList = (ArrayList)entry.getValue();
            if (DEBUG) {
                System.out.println("remove group: " + group + ", user: " + entry.getKey());
            }
            if (!groupList.contains(group)) continue;
            groupList.remove(group);
        }
    }

    private void updateGroup(IDeltaElement deltaElement) {
        String group = (String)this.m_groupsByConfigIDMap.get(deltaElement.getIdentity().getName());
        IDeltaAttributeSet deltaAttributes = (IDeltaAttributeSet)deltaElement.getDeltaAttributes();
        String[] modifiedAttributeNames = deltaAttributes.getModifiedAttributesNames();
        for (int i = 0; i < modifiedAttributeNames.length; ++i) {
            if (!modifiedAttributeNames[i].equals("GROUP_MEMBERS")) continue;
            try {
                ArrayList groupList;
                int j;
                IDeltaAttributeSet membersDelta = (IDeltaAttributeSet)deltaAttributes.getNewValue("GROUP_MEMBERS");
                String[] users = null;
                users = membersDelta.getDeletedAttributesNames();
                for (j = 0; j < users.length; ++j) {
                    groupList = (ArrayList)super.get(users[j]);
                    if (groupList != null && groupList.contains(group)) {
                        groupList.remove(group);
                    }
                    if (!DEBUG) continue;
                    System.out.println("removed user: " + users[j] + " from group: " + group + " [" + deltaElement.getIdentity().getName() + "]");
                }
                users = membersDelta.getModifiedAttributesNames();
                for (j = 0; j < users.length; ++j) {
                    if (!DEBUG) continue;
                    System.out.println("modified user: " + users[j] + " in group: " + group + " [" + deltaElement.getIdentity().getName() + "]");
                }
                users = membersDelta.getNewAttributesNames();
                for (j = 0; j < users.length; ++j) {
                    groupList = (ArrayList)super.get(users[j]);
                    if (groupList == null) {
                        groupList = new ArrayList();
                        super.put(users[j], groupList);
                    }
                    if (!groupList.contains(group)) {
                        groupList.add(group);
                    }
                    if (!DEBUG) continue;
                    System.out.println("new user: " + users[j] + " in group: " + group + " [" + deltaElement.getIdentity().getName() + "]");
                }
            }
            catch (NotModifiedAttException e) {
                e.printStackTrace();
            }
            return;
        }
        String[] newAttributeNames = deltaAttributes.getNewAttributesNames();
        for (int i = 0; i < newAttributeNames.length; ++i) {
            if (!newAttributeNames[i].equals("GROUP_MEMBERS")) continue;
            try {
                for (String user : ((IAttributeSet)deltaAttributes.getNewValue("GROUP_MEMBERS")).getAttributes().keySet()) {
                    ArrayList<String> groupList = (ArrayList<String>)super.get(user);
                    if (groupList == null) {
                        groupList = new ArrayList<String>();
                        super.put(user, groupList);
                    }
                    if (!groupList.contains(group)) {
                        groupList.add(group);
                    }
                    if (!DEBUG) continue;
                    System.out.println("new user: " + user + " in group: " + group + " [" + deltaElement.getIdentity().getName() + "]");
                }
            }
            catch (NotModifiedAttException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    private void updateGroupMap() {
        this.m_externalGroupsToInternalGroups.clear();
        IElement authenticationDomainDescriptor = this.m_context.getConfiguration(this.m_descriptorPath, true);
        IAttributeSet descriptorAttributes = authenticationDomainDescriptor.getAttributes();
        IAttributeSet groupMap = (IAttributeSet)descriptorAttributes.getAttribute("GROUP_MAP");
        if (groupMap != null) {
            for (Map.Entry groupMapping : groupMap.getAttributes().entrySet()) {
                String internalGroup = (String)groupMapping.getKey();
                StringTokenizer externalGroupList = new StringTokenizer((String)groupMapping.getValue(), ",");
                while (externalGroupList.hasMoreTokens()) {
                    String externalGroup = externalGroupList.nextToken();
                    HashSet<String> internalGroups = (HashSet<String>)this.m_externalGroupsToInternalGroups.get(externalGroup);
                    if (internalGroups == null) {
                        internalGroups = new HashSet<String>();
                        this.m_externalGroupsToInternalGroups.put(externalGroup, internalGroups);
                    }
                    internalGroups.add(internalGroup);
                }
            }
        }
    }

    void cleanup() {
        this.m_context.getConfigurations(this.m_usersDir, false);
        if (this.m_externalDomain) {
            this.m_context.getConfigurations(this.m_externalUsersDir, false);
        }
        this.m_context.getConfigurations(this.m_groupsDir, false);
        if (this.m_externalDomain) {
            this.m_context.getConfigurations(this.m_externalGroupsDir, false);
        }
        this.m_usersByConfigIDMap.clear();
        this.m_groupsByConfigIDMap.clear();
        super.clear();
    }
}

