/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.security;

import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.security.AbstractPermissionsMap;
import com.sonicsw.mf.framework.security.AuthenticationPrincipalMap;

public class ConfigurePermissionsMap
extends AbstractPermissionsMap {
    private static final String CONFIGURE_PERMISSIONS_CONFIG_ID = "/permissions/configure";

    public ConfigurePermissionsMap(IFrameworkComponentContext context, AuthenticationPrincipalMap authenticationPrincipalMap) {
        super(context, authenticationPrincipalMap, CONFIGURE_PERMISSIONS_CONFIG_ID);
    }

    boolean hasPermission(String principal, String path, int requiredPermission, boolean isLogical) {
        String[] groups = this.m_authenticationPrincipalMap.getGroups(principal);
        boolean isFolder = path.endsWith("/");
        int scope = path.equals("/") && !isLogical ? 8 : (isFolder ? 1 : 4);
        int result = this.checkPermission(principal, path, groups, requiredPermission, scope);
        if (result == 1) {
            return true;
        }
        if (result == -1) {
            return false;
        }
        if (path.equals("/")) {
            return false;
        }
        String parentPath = this.getParentPath(path);
        result = this.checkPermission(principal, parentPath, groups, requiredPermission, scope = isFolder ? 2 : 8);
        if (result == 1) {
            return true;
        }
        if (result == -1) {
            return false;
        }
        if (parentPath.equals("/")) {
            return false;
        }
        parentPath = this.getParentPath(parentPath);
        return super.hasPermission(principal, parentPath, groups, requiredPermission, scope |= 2);
    }
}

