/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.security;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.util.ObjectNameHelper;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.security.AbstractPermissionsMap;
import com.sonicsw.mf.framework.security.AuthenticationPrincipalMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;

public class ManagePermissionsMap
extends AbstractPermissionsMap {
    private HashMap m_containerNameToConfigIDMap = new HashMap();
    private static final String MANAGE_PERMISSIONS_CONFIG_ID = "/permissions/manage";

    public ManagePermissionsMap(IFrameworkComponentContext context, AuthenticationPrincipalMap authenticationPrincipalMap) {
        super(context, authenticationPrincipalMap, MANAGE_PERMISSIONS_CONFIG_ID);
        IElement containerConfiguration = context.getConfiguration(true);
        this.mapContainerNameToConfigID(containerConfiguration);
    }

    @Override
    public synchronized void handleElementChange(IElementChange elementChange) {
        IBasicElement element = elementChange.getElement();
        if (element.getIdentity().getType().equals("MF_CONTAINER")) {
            switch (elementChange.getChangeType()) {
                case 1: {
                    element = this.m_context.getConfiguration(element.getIdentity().getName(), true);
                    this.mapContainerNameToConfigID((IElement)element);
                    break;
                }
                case 0: {
                    this.mapContainerNameToConfigID((IElement)element);
                    break;
                }
                case 2: {
                    this.unmapContainerNameToConfigID(element.getIdentity().getName());
                    break;
                }
            }
        } else {
            super.handleElementChange(elementChange);
        }
    }

    private synchronized void mapContainerNameToConfigID(IElement containerConfiguration) {
        String containerConfigID = containerConfiguration.getIdentity().getName();
        IAttributeSet containerAttrs = containerConfiguration.getAttributes();
        String containerName = (String)containerAttrs.getAttribute("CONTAINER_NAME");
        this.unmapContainerNameToConfigID(containerConfigID);
        this.m_containerNameToConfigIDMap.put(containerName, containerConfigID);
    }

    private synchronized void unmapContainerNameToConfigID(String containerConfigID) {
        Iterator containers = this.m_containerNameToConfigIDMap.entrySet().iterator();
        while (containers.hasNext()) {
            Map.Entry entry = containers.next();
            if (!entry.getValue().equals(containerConfigID)) continue;
            containers.remove();
            break;
        }
    }

    private synchronized void getOtherContainerConfigIDs() {
        IElement[] containerConfigs = this.m_context.getConfigurations("/containers", true);
        for (int i = 0; i < containerConfigs.length; ++i) {
            this.mapContainerNameToConfigID(containerConfigs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasPermission(String principal, ObjectName objectName, int requiredPermission) {
        String containerName = ObjectNameHelper.getMFContainerName((ObjectName)objectName);
        String containerConfigID = null;
        ManagePermissionsMap managePermissionsMap = this;
        synchronized (managePermissionsMap) {
            containerConfigID = (String)this.m_containerNameToConfigIDMap.get(containerName);
            if (containerConfigID == null) {
                this.getOtherContainerConfigIDs();
                containerConfigID = (String)this.m_containerNameToConfigIDMap.get(containerName);
            }
        }
        String logicalPath = this.m_context.storageToLogical(containerConfigID);
        String componentName = ObjectNameHelper.getMFComponentName((ObjectName)objectName);
        String[] groups = this.m_authenticationPrincipalMap.getGroups(principal);
        boolean isContainer = componentName.equals("AGENT");
        int scope = 8;
        int result = -1;
        if (isContainer) {
            scope = 2;
        } else {
            scope = 8;
            String hybridPath = logicalPath + ":ID=" + componentName;
            result = this.checkPermission(principal, hybridPath, groups, requiredPermission, scope);
            if (result == 1) {
                return true;
            }
            if (result == -1) {
                return false;
            }
            scope = 16;
        }
        result = this.checkPermission(principal, logicalPath, groups, requiredPermission, scope);
        if (result == 1) {
            return true;
        }
        if (result == -1) {
            return false;
        }
        String parentPath = this.getParentPath(logicalPath);
        result = this.checkPermission(principal, parentPath, groups, requiredPermission, scope = isContainer ? 4 : 16);
        if (result == 1) {
            return true;
        }
        if (result == -1) {
            return false;
        }
        if (parentPath.equals("/")) {
            return false;
        }
        parentPath = this.getParentPath(parentPath);
        return super.hasPermission(principal, parentPath, groups, requiredPermission, scope |= 1);
    }
}

