/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.security;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.runtime.ICollectiveOpStatus;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.CollectiveOpStatus;
import com.sonicsw.mf.common.runtime.impl.ComponentIdentity;
import com.sonicsw.mf.common.security.ConfigurePermissionDeniedException;
import com.sonicsw.mf.common.security.ManagePermissionDeniedException;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mf.common.util.ObjectNameHelper;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.IPermissionsManager;
import com.sonicsw.mf.framework.agent.TaskScheduler;
import com.sonicsw.mf.framework.security.AuthenticationPrincipalMap;
import com.sonicsw.mf.framework.security.CheckedAPI;
import com.sonicsw.mf.framework.security.ConfigurePermissionsMap;
import com.sonicsw.mf.framework.security.ManagePermissionsMap;
import com.sonicsw.mf.jmx.client.MFNotification;
import com.sonicsw.mx.util.IEmptyArray;
import java.util.ArrayList;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class PermissionsManager
implements IPermissionsManager {
    private static final boolean DEBUG = System.getProperty("com.sonicsw.debugFGS") != null;
    private static final String DOMAIN_CONFIG_ID = "/domain/domain";
    private IFrameworkComponentContext m_context;
    private String m_authenticationDomain;
    private AuthenticationPrincipalMap m_authenticationPrincipalMap;
    private ManagePermissionsMap m_managePolicyMap;
    private ConfigurePermissionsMap m_configurePolicyMap;
    private IComponentIdentity m_dsID;
    private Object m_lock = new Object();
    private int m_checkers = 0;
    private int m_traceMask;

    public PermissionsManager(IFrameworkComponentContext context) {
        this.m_context = context;
        this.configurePermissionsManager();
    }

    public boolean isPermissionsCheckingEnabled() {
        return this.m_authenticationPrincipalMap != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configurePermissionsManager() {
        IElement domainConfiguration = null;
        try {
            domainConfiguration = this.m_context.getConfiguration(DOMAIN_CONFIG_ID, true);
        }
        catch (MFRuntimeException mFRuntimeException) {
            // empty catch block
        }
        if (domainConfiguration == null) {
            return;
        }
        Object object = this.m_lock;
        synchronized (object) {
            while (this.m_checkers > 0) {
                try {
                    this.m_lock.wait(10000L);
                    if (!this.m_context.getContainer().isClosing()) continue;
                    return;
                }
                catch (InterruptedException e) {
                }
            }
            try {
                IAttributeSet domainAttributes = domainConfiguration.getAttributes();
                Reference authenticationDomainReference = (Reference)domainAttributes.getAttribute("AUTHENTICATION_DOMAIN");
                if (authenticationDomainReference == null || authenticationDomainReference.getElementName() == null || authenticationDomainReference.getElementName().length() == 0) {
                    if (this.m_authenticationPrincipalMap != null) {
                        this.disablePermissionsManager();
                    }
                } else {
                    this.enablePermissionsManager(authenticationDomainReference);
                }
            }
            finally {
                this.m_lock.notifyAll();
            }
        }
    }

    private void enablePermissionsManager(Reference authenticationDomainReference) {
        String authenticationDomain = authenticationDomainReference.getElementName();
        if (this.m_authenticationDomain != null) {
            if (authenticationDomain.equals(this.m_authenticationDomain)) {
                return;
            }
            this.m_context.getContainer().logMessage(null, "Management permissions checking will be temporarily disabled while it is reconfigured", 2);
            this.disablePermissionsManager();
        } else if (authenticationDomain == null || authenticationDomain.length() == 0) {
            return;
        }
        this.initPrincipalMap(authenticationDomainReference);
        this.initConfigurePermissionsMap();
        this.initManagePermissionsMap();
        this.m_authenticationDomain = authenticationDomain;
        this.m_context.getContainer().logMessage(null, "Management permissions checking enabled", 4);
    }

    private void disablePermissionsManager() {
        this.m_authenticationPrincipalMap.cleanup();
        this.m_authenticationPrincipalMap = null;
        if (this.m_configurePolicyMap != null) {
            this.m_configurePolicyMap.cleanup();
            this.m_configurePolicyMap = null;
        }
        this.m_managePolicyMap.cleanup();
        this.m_managePolicyMap = null;
        this.m_authenticationDomain = null;
        this.m_context.getContainer().logMessage(null, "Management permissions checking disabled", 4);
    }

    private void initPrincipalMap(Reference authenticationDomain) {
        String authenticationDomainDir = authenticationDomain.getElementName();
        IElement domain = this.m_context.getConfiguration(authenticationDomainDir, true);
        IAttributeSet domainSet = domain.getAttributes();
        Boolean external = (Boolean)domainSet.getAttribute("EXTERNAL");
        boolean externalValue = false;
        if (external != null) {
            externalValue = external;
        }
        authenticationDomainDir = authenticationDomainDir.substring(0, authenticationDomainDir.indexOf("_MFDomainDescriptor") - 1);
        this.m_authenticationPrincipalMap = new AuthenticationPrincipalMap((IComponentContext)this.m_context, authenticationDomainDir, externalValue);
    }

    private void initConfigurePermissionsMap() {
        Boolean hostsDS;
        IElement containerConfiguration = this.m_context.getConfiguration(true);
        IAttributeSet containerAttributes = containerConfiguration.getAttributes();
        Integer traceMask = (Integer)containerAttributes.getAttribute("TRACE_MASK");
        if (traceMask != null) {
            this.setTraceMask(traceMask);
        }
        if ((hostsDS = (Boolean)containerAttributes.getAttribute("HOSTS_DIRECTORY_SERVICE")) != null && hostsDS.booleanValue()) {
            this.m_configurePolicyMap = new ConfigurePermissionsMap(this.m_context, this.m_authenticationPrincipalMap);
            CanonicalName dsName = new CanonicalName(this.m_context.getComponentName().getDomainName() + "." + this.m_context.getComponentName().getContainerName() + ":ID=" + "DIRECTORY SERVICE");
            this.m_dsID = new ComponentIdentity(dsName, null);
        }
    }

    private void initManagePermissionsMap() {
        this.m_managePolicyMap = new ManagePermissionsMap(this.m_context, this.m_authenticationPrincipalMap);
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        IElementIdentity id = elementChange.getElement().getIdentity();
        String configID = id.getName();
        if (configID.startsWith(DOMAIN_CONFIG_ID)) {
            this.handleDomainChanges(elementChange);
        } else if (this.m_authenticationPrincipalMap != null) {
            this.m_authenticationPrincipalMap.handleElementChange(elementChange);
            if (this.m_managePolicyMap != null) {
                this.m_managePolicyMap.handleElementChange(elementChange);
            }
            if (this.m_configurePolicyMap != null) {
                this.m_configurePolicyMap.handleElementChange(elementChange);
            }
        }
    }

    private void handleDomainChanges(IElementChange elementChange) {
        if (elementChange.getChangeType() != 1) {
            return;
        }
        this.configurePermissionsManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurePermissionCheck(IComponentContext context, String path, boolean isLogicalPath, int requiredPermission) throws ManagementPermissionDeniedException {
        if (!isLogicalPath && path.startsWith("/_MFContext")) {
            return;
        }
        Object object = this.m_lock;
        synchronized (object) {
            ++this.m_checkers;
        }
        try {
            if (this.m_authenticationPrincipalMap == null) {
                return;
            }
            if (!TaskScheduler.isExecutionThread()) {
                if (DEBUG) {
                    System.out.println("PermissionsManager.configurePermissionCheck(): Called from non-task thread, stack dump follows...");
                    Thread.dumpStack();
                }
                return;
            }
            String principal = TaskScheduler.getCurrentUserID();
            if (principal == null || principal.length() == 0) {
                if (DEBUG) {
                    System.out.println("PermissionsManager.configurePermissionCheck(): No user identity associated with configure request: principal=" + principal + ", path=" + path + ": stack dump follows...");
                    Thread.dumpStack();
                }
                if ((this.m_traceMask & 0x2000) > 0) {
                    this.m_context.getContainer().logMessage("DIRECTORY SERVICE", "Permission denied: no user identity associated with mangement request", 7);
                }
                throw new ManagementPermissionDeniedException("No user identity associated with mangement request, check management security settings");
            }
            if (principal.equals("Administrator")) {
                return;
            }
            if (!this.m_configurePolicyMap.hasPermission(principal, path, requiredPermission, isLogicalPath)) {
                if (isLogicalPath) {
                    this.recordConfigurePermissionDenied(context, principal, path, null, requiredPermission);
                } else {
                    this.recordConfigurePermissionDenied(context, principal, null, path, requiredPermission);
                }
                throw new ConfigurePermissionDeniedException("Permission denied: user identity=" + principal + ", path=" + path + ", isLogicalPath=" + isLogicalPath + ", permission=" + requiredPermission, isLogicalPath ? path : null, requiredPermission);
            }
        }
        finally {
            object = this.m_lock;
            synchronized (object) {
                --this.m_checkers;
                this.m_lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void managePermissionCheck(ObjectName objectName, String operationName, MBeanInfo mBeanInfo) throws ManagementPermissionDeniedException {
        Object object = this.m_lock;
        synchronized (object) {
            ++this.m_checkers;
        }
        try {
            boolean isMFComponent;
            if (this.m_authenticationPrincipalMap == null) {
                return;
            }
            if (!TaskScheduler.isExecutionThread()) {
                if (DEBUG) {
                    System.out.println("PermissionsManager.managePermissionCheck(): Called from non-task thread: " + objectName.getCanonicalName() + ", operationName=" + operationName + ": stack dump follows...");
                    Thread.dumpStack();
                }
                return;
            }
            String principal = TaskScheduler.getCurrentUserID();
            boolean bl = isMFComponent = objectName != null && ObjectNameHelper.isMFComponentName((ObjectName)objectName);
            if (principal == null || principal.length() == 0) {
                if (DEBUG) {
                    System.out.println("PermissionsManager.managePermissionCheck(): No user identity associated with mangement request: principal=" + principal + ", " + objectName == null ? "MBeanServer" : objectName.getCanonicalName() + ", operationName=" + operationName + ": stack dump follows...");
                    Thread.dumpStack();
                }
                if ((this.m_traceMask & 0x2000) > 0) {
                    this.m_context.getContainer().logMessage(isMFComponent ? objectName.getKeyProperty("ID") : null, "Permission denied: no user identity associated with mangement request", 7);
                }
                throw new ManagementPermissionDeniedException("No user identity associated with mangement request, check management security settings");
            }
            if (principal.equals("Administrator")) {
                return;
            }
            int requiredPermission = 1024;
            ObjectName checkName = objectName;
            if (!isMFComponent) {
                try {
                    checkName = new ObjectName(this.m_context.getComponentName().getCanonicalName());
                }
                catch (MalformedObjectNameException e) {
                    e.printStackTrace();
                }
            }
            if (objectName == null) {
                if (CheckedAPI.isMBeanServerAPI(operationName)) {
                    requiredPermission = 256;
                } else if (CheckedAPI.isMBeanServerInfo(operationName)) {
                    requiredPermission = 1024;
                }
            } else if (CheckedAPI.isLifeCycleAPI(operationName)) {
                requiredPermission = 1;
            } else if (CheckedAPI.isEnableDisableMetricsAPI(operationName)) {
                requiredPermission = 4;
            } else if (CheckedAPI.isSetAttributesAPI(operationName)) {
                requiredPermission = 64;
            } else if (CheckedAPI.isNotificationSubscriptionAPI(operationName)) {
                requiredPermission = 16;
            } else {
                if (isMFComponent && objectName.getKeyProperty("ID").equals("DIRECTORY SERVICE") && !CheckedAPI.isCheckedDSAPI(operationName)) {
                    return;
                }
                if (mBeanInfo == null) {
                    try {
                        mBeanInfo = (MBeanInfo)this.m_context.invoke(objectName.getCanonicalName(), "getMBeanInfo", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY, true, -1L);
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        MFRuntimeException mfre = new MFRuntimeException();
                        mfre.setLinkedException(e);
                        throw mfre;
                    }
                }
                if (CheckedAPI.isMBeanActionAPI(mBeanInfo, operationName)) {
                    requiredPermission = 256;
                }
            }
            if (!this.m_managePolicyMap.hasPermission(principal, checkName, requiredPermission)) {
                this.recordManagePermissionDenied("AGENT", principal, objectName, operationName, requiredPermission);
                throw new ManagePermissionDeniedException("Permission denied: user identity=" + principal + ", target=" + (objectName == null ? "[MBeanServer]" : objectName.getCanonicalName()) + ", operation=" + operationName + ", permission=" + requiredPermission, objectName == null ? "[MBeanServer]" : objectName.getCanonicalName(), requiredPermission);
            }
        }
        finally {
            object = this.m_lock;
            synchronized (object) {
                --this.m_checkers;
                this.m_lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectiveOpStatus managePermissionCheck(ObjectName[] objectNames, String operationName) {
        Object object = this.m_lock;
        synchronized (object) {
            ++this.m_checkers;
        }
        try {
            if (this.m_authenticationPrincipalMap == null) {
                object = null;
                return object;
            }
            if (!TaskScheduler.isExecutionThread()) {
                if (DEBUG) {
                    System.out.println("PermissionsManager.managePermissionCheck(): Called from non-task thread: operationName=" + operationName + ": stack dump follows...");
                    Thread.dumpStack();
                }
                object = null;
                return object;
            }
            String principal = TaskScheduler.getCurrentUserID();
            if (principal == null || principal.length() == 0) {
                if (DEBUG) {
                    System.out.println("PermissionsManager.managePermissionCheck(): No user identity associated with mangement request: principal=" + principal + ", operationName=" + operationName + ": stack dump follows...");
                    Thread.dumpStack();
                }
                if ((this.m_traceMask & 0x2000) > 0) {
                    this.m_context.getContainer().logMessage("AGENT MANAGER", "Permission denied: no user identity associated with mangement request", 7);
                }
                throw new ManagePermissionDeniedException("No user identity associated with mangement request, check management security settings", null, 0);
            }
            if (principal.equals("Administrator")) {
                CollectiveOpStatus collectiveOpStatus = null;
                return collectiveOpStatus;
            }
            CollectiveOpStatus collectiveResults = new CollectiveOpStatus(objectNames.length);
            int requiredPermission = 1024;
            if (CheckedAPI.isLifeCycleAPI(operationName)) {
                requiredPermission = 1;
            } else if (CheckedAPI.isEnableDisableMetricsAPI(operationName)) {
                requiredPermission = 4;
            } else if (CheckedAPI.isSetAttributesAPI(operationName)) {
                requiredPermission = 64;
            } else if (CheckedAPI.isNotificationSubscriptionAPI(operationName)) {
                requiredPermission = 16;
            } else {
                ArrayList<String> targets = new ArrayList<String>();
                for (int i = 0; i < objectNames.length; ++i) {
                    String target = objectNames[i].getCanonicalName();
                    if (target.endsWith("DIRECTORY SERVICE") && !CheckedAPI.isCheckedDSAPI(operationName)) continue;
                    targets.add(target);
                }
                ICollectiveOpStatus collectiveOpStatus = null;
                if (!targets.isEmpty()) {
                    try {
                        collectiveOpStatus = this.m_context.invoke((String[])targets.toArray(), "getMBeanInfo", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY, true, -1L);
                    }
                    catch (Exception e) {
                        MFRuntimeException exception = new MFRuntimeException("Failed invoke [" + operationName + "] on collection");
                        exception.setLinkedException(e);
                        throw exception;
                    }
                }
                for (int i = 0; i < collectiveOpStatus.getCount(); ++i) {
                    if (collectiveOpStatus.operationIsSuccessful(i)) {
                        requiredPermission = 1024;
                        MBeanInfo mBeanInfo = (MBeanInfo)collectiveOpStatus.getReturnValue(i);
                        MBeanOperationInfo[] operationInfos = mBeanInfo.getOperations();
                        for (int j = 0; j < operationInfos.length; ++j) {
                            if (!operationInfos[j].getName().equals(operationName)) continue;
                            if (operationInfos[j].getImpact() != 1 && operationInfos[j].getImpact() != 2) break;
                            requiredPermission = 256;
                            break;
                        }
                        ObjectName objectName = null;
                        try {
                            objectName = new ObjectName(collectiveOpStatus.getComponentName(i));
                        }
                        catch (MalformedObjectNameException e) {
                            e.printStackTrace();
                        }
                        if (this.m_managePolicyMap.hasPermission(principal, objectName, requiredPermission)) continue;
                        this.recordManagePermissionDenied("AGENT MANAGER", principal, objectName, operationName, requiredPermission);
                        ManagePermissionDeniedException exception = new ManagePermissionDeniedException("Permission denied: user identity=" + principal + ", target=" + (objectName == null ? null : objectName.getCanonicalName()) + ", operation=" + operationName + ", permission=" + requiredPermission, objectName == null ? null : objectName.getCanonicalName(), requiredPermission);
                        collectiveResults.addResult(collectiveOpStatus.getComponentName(i), null, (Throwable)exception);
                        continue;
                    }
                    collectiveResults.addResult(collectiveOpStatus.getComponentName(i), collectiveOpStatus.getReturnValue(i), collectiveOpStatus.getThrowable(i));
                }
                CollectiveOpStatus collectiveOpStatus2 = collectiveResults;
                return collectiveOpStatus2;
            }
            for (int i = 0; i < objectNames.length; ++i) {
                if (this.m_managePolicyMap.hasPermission(principal, objectNames[i], requiredPermission)) continue;
                this.recordManagePermissionDenied("AGENT MANAGER", principal, objectNames[i], operationName, requiredPermission);
                ManagePermissionDeniedException exception = new ManagePermissionDeniedException("Permission denied: user identity=" + principal + ", target=" + objectNames[i].getCanonicalName() + ", operation=" + operationName + ", permission=" + requiredPermission, objectNames[i].getCanonicalName(), requiredPermission);
                collectiveResults.addResult(objectNames[i].getCanonicalName(), null, (Throwable)exception);
            }
            CollectiveOpStatus collectiveOpStatus = collectiveResults;
            return collectiveOpStatus;
        }
        finally {
            Object object2 = this.m_lock;
            synchronized (object2) {
                --this.m_checkers;
                this.m_lock.notifyAll();
            }
        }
    }

    public short getPrincipalType(String principal) {
        if (this.m_authenticationPrincipalMap == null) {
            return 0;
        }
        return this.m_authenticationPrincipalMap.getPrincipalType(principal);
    }

    public boolean isSuperUser() {
        String userID;
        return TaskScheduler.isExecutionThread() && (userID = TaskScheduler.getCurrentUserID()) != null && userID.equals("Administrator");
    }

    public int getTraceMask() {
        return this.m_traceMask;
    }

    public void setTraceMask(int traceMask) {
        this.m_traceMask = traceMask;
    }

    private void recordConfigurePermissionDenied(IComponentContext context, String principal, String logicalPath, String storagePath, int requiredPermission) {
        if ((this.m_traceMask & 0x2000) > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("Configure permission denied: user identity=").append(principal);
            if (logicalPath != null && logicalPath.length() > 0) {
                sb.append(", logicalPath=").append(logicalPath);
            }
            if (storagePath != null && storagePath.length() > 0) {
                sb.append(", storagePath=").append(storagePath);
            }
            sb.append(", permission=").append(requiredPermission);
            this.m_context.getContainer().logMessage("DIRECTORY SERVICE", sb.toString(), 7);
        }
        if (requiredPermission != 1) {
            this.sendConfigurePermissionDeniedNotification(context, principal, logicalPath, storagePath, requiredPermission);
            this.m_context.getAuditManager().recordConfigurePermissionDeniedEvent(logicalPath, storagePath, requiredPermission);
        }
    }

    private void recordManagePermissionDenied(String sourceID, String principal, ObjectName objectName, String operationName, int requiredPermission) {
        if ((this.m_traceMask & 0x2000) > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("Manage permission denied: user identity=").append(principal);
            sb.append(", target=").append(objectName == null ? "[MBeanServer]" : objectName.getCanonicalName());
            sb.append(", operation=").append(operationName);
            sb.append(", permission=").append(requiredPermission);
            this.m_context.getContainer().logMessage(sourceID, sb.toString(), 7);
        }
        this.sendManagePermissionDeniedNotification(principal, objectName == null ? "[MBeanServer]" : objectName.getCanonicalName(), operationName, requiredPermission);
        this.m_context.getAuditManager().recordManagePermissionDeniedEvent(objectName, operationName, requiredPermission);
    }

    private void sendConfigurePermissionDeniedNotification(IComponentContext context, String principal, String logicalPath, String storagePath, int requiredPermission) {
        INotification notification = context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[5], "ConfigurePermissionDenied", 2);
        ((MFNotification)notification).setSourceIdentity(this.m_dsID);
        notification.setLogType((short)4);
        notification.setAttribute("User", (Object)principal);
        if (logicalPath != null && logicalPath.length() > 0) {
            notification.setAttribute("LogicalPath", (Object)logicalPath);
        }
        if (storagePath != null && storagePath.length() > 0) {
            notification.setAttribute("StoragePath", (Object)storagePath);
        }
        notification.setAttribute("RequiredPermission", (Object)new Integer(requiredPermission));
        context.sendNotification(notification);
    }

    private void sendManagePermissionDeniedNotification(String principal, String target, String operationName, int requiredPermission) {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[5], "ManagePermissionDenied", 2);
        notification.setLogType((short)4);
        notification.setAttribute("User", (Object)principal);
        notification.setAttribute("Target", (Object)target);
        notification.setAttribute("Operation", (Object)operationName);
        notification.setAttribute("RequiredPermission", (Object)new Integer(requiredPermission));
        this.m_context.sendNotification(notification);
    }
}

