/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.interceptor.actional.soniclog;

import com.actional.lg.interceptor.sdk.ILogEntry;
import com.actional.lg.interceptor.sdk.LogEntryFactory;
import com.actional.lg.interceptor.sdk.UplinkConfig;
import com.sonicsw.mf.interceptor.actional.soniclog.SonicLoggingEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public final class SonicLogInterceptor {
    public static final String MAX_MSG_SIZE_ATTR = "com.progress.actional.interceptor.soniclog.maxMsgSize";
    public static final String DISABLE_LOG_OUTPUT_ATTR = "com.progress.actional.interceptor.soniclog.disableLogOutput";
    private static int MAX_MSG_SIZE_VALUE = -1;
    private static boolean DISABLE_LOG_OUTPUT_VALUE = false;

    private SonicLogInterceptor() {
    }

    public static void updateLoggingProperty(String name, Object value) {
        if (MAX_MSG_SIZE_ATTR.equals(name)) {
            MAX_MSG_SIZE_VALUE = value == null ? -1 : (Integer)value;
        } else if (DISABLE_LOG_OUTPUT_ATTR.equals(name)) {
            DISABLE_LOG_OUTPUT_VALUE = value == null ? false : (Boolean)value;
        }
    }

    public static boolean beforeLogMessage(String componentId, String message, int severity) {
        ILogEntry logEntry = LogEntryFactory.beginLogEntry();
        if (logEntry == null) {
            return false;
        }
        SonicLoggingEvent loggingEvent = new SonicLoggingEvent(componentId, message, severity);
        String className = loggingEvent.getClassName();
        if (className.startsWith("org.apache.log4j")) {
            return false;
        }
        String logMessage = loggingEvent.getMessage();
        if (MAX_MSG_SIZE_VALUE > 0 && logMessage.length() > MAX_MSG_SIZE_VALUE) {
            logMessage = logMessage.substring(0, MAX_MSG_SIZE_VALUE).concat("...");
        }
        logEntry.setLogMessage((Object)logMessage);
        logEntry.setLoggerName(loggingEvent.getComponentId());
        logEntry.setLogLevel(loggingEvent.getLevel());
        logEntry.setLogClassName(className);
        logEntry.setLogMethodName(loggingEvent.getMethodName());
        logEntry.setLogThreadID(loggingEvent.getThreadId());
        logEntry.setLogThreadName(loggingEvent.getThreadName());
        logEntry.setLogTime(loggingEvent.getTimestamp());
        boolean processed = logEntry.end();
        return DISABLE_LOG_OUTPUT_VALUE && processed && UplinkConfig.getCurrent().getAlive();
    }

    public static String throwableToString(Throwable th) {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        PrintStream pstream = new PrintStream(bstream);
        th.printStackTrace(pstream);
        return bstream.toString();
    }
}

