/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.interceptor.actional.soniclog;

import com.actional.lg.interceptor.sdk.LogLevel;

public class SonicLoggingEvent {
    private LogLevel level_;
    private String componentId_;
    private String message_;
    private String className_;
    private String methodName_;
    private String threadId_;
    private String threadName_;
    private long timestamp_;

    public SonicLoggingEvent(String _componentId, String _message, int _level) {
        this.componentId_ = _componentId;
        this.message_ = _message;
        this.level_ = this.mapLevel(_level);
        this.threadId_ = Long.toString(Thread.currentThread().getId());
        this.threadName_ = Thread.currentThread().getName();
        this.analyzeStack();
        this.timestamp_ = System.currentTimeMillis();
    }

    private LogLevel mapLevel(int _level) {
        switch (_level) {
            case 7: {
                return LogLevel.TRACE;
            }
            case 6: {
                return LogLevel.DEBUG;
            }
            case 5: {
                return LogLevel.DEBUG;
            }
            case 3: {
                return LogLevel.INFO;
            }
            case 2: {
                return LogLevel.WARNING;
            }
            case 1: {
                return LogLevel.ERROR;
            }
            case 4: {
                return LogLevel.CONFIG;
            }
        }
        return LogLevel.UNKNOWN;
    }

    private void analyzeStack() {
        Throwable th = new Throwable();
        StackTraceElement[] currentProc = null;
        try {
            currentProc = th.getStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        int stackDepth = currentProc.length;
        for (int i = 1; i < stackDepth; ++i) {
            String currentClassName = currentProc[i].getClassName();
            if (currentClassName.startsWith("com.sonicsw.mf.interceptor.actional.soniclog") || currentClassName.startsWith("com.sonicsw.mf.framework.agent") || currentClassName.startsWith("com.sonicsw.xqimpl")) continue;
            this.className_ = currentProc[i].getClassName();
            this.methodName_ = currentProc[i].getMethodName();
            break;
        }
    }

    public final String getClassName() {
        return this.className_;
    }

    public final LogLevel getLevel() {
        return this.level_;
    }

    public final String getMessage() {
        return this.message_;
    }

    public final String getMethodName() {
        return this.methodName_;
    }

    public final long getTimestamp() {
        return this.timestamp_;
    }

    public final String getComponentId() {
        return this.componentId_;
    }

    public final String getThreadId() {
        return this.threadId_;
    }

    public final String getThreadName() {
        return this.threadName_;
    }
}

