/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.mgmtapi.config.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.util.ValidName;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.security.IManagementSecurityConfigurator;
import com.sonicsw.mf.common.util.Container;
import com.sonicsw.mf.mgmtapi.config.IAgentManagerBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationDomainBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationGroupBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationUserBean;
import com.sonicsw.mf.mgmtapi.config.IBackupAgentManagerBean;
import com.sonicsw.mf.mgmtapi.config.IBackupDirectoryServiceBean;
import com.sonicsw.mf.mgmtapi.config.IComponentCollectionBean;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mf.mgmtapi.config.IContainerCollectionBean;
import com.sonicsw.mf.mgmtapi.config.IDirectoryServiceBean;
import com.sonicsw.mf.mgmtapi.config.gen.impl.AbstractContainerBean;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ContainerBean
extends AbstractContainerBean
implements IContainerBean {
    private static final String AM_RUNTIME_ID = "AGENT MANAGER";
    private static final String DS_RUNTIME_ID = "DIRECTORY SERVICE";
    private static boolean m_bEnableFT = false;
    private static String EXCLUDE_TEMPLATE_TYPE = "EXCLUDE_TEMPLATE_TYPE";
    private static volatile String CURRENT_FT_ROLE = "";

    public ContainerBean(MgmtBeanFactory factory) {
        super(factory);
    }

    @Override
    public void createBean(String viewName, String type, String cVersion, String pVersion) throws MgmtException {
        super.createBean(viewName, type, cVersion, pVersion);
        this.setContainerName(this.getConfigBeanNameTail());
        super.setDomainName(this.getMgmtBeanFactory().getDomain());
    }

    @Override
    public void loadBean(String viewPath, String type) throws MgmtException {
        super.loadBean(viewPath, type);
        CURRENT_FT_ROLE = this.isFaultTolerant() ? this.getFaultToleranceParameters().getFaultToleranceRole() : "";
    }

    @Override
    public void setDomainName(String value) throws MgmtException {
        throw new MgmtException("Can't set Domain Name - implied through Domain Connection");
    }

    protected void viewNameChange(String viewName) throws MgmtException {
        this.setContainerName(viewName.substring(viewName.lastIndexOf(47) + 1));
    }

    @Override
    public String generateBootFile() throws MgmtException {
        try {
            return this.getMgmtBeanFactory().exportContainerBootConfiguration(this, this.getDomainName());
        }
        catch (Exception e) {
            throw new MgmtException("Failed to generate boot file", e);
        }
    }

    @Override
    public void generateSetupFile(String targetFolder, String windowsServiceName) throws MgmtException {
        try {
            this.validatePath(targetFolder);
            String elementPath = this.getConfigBean().getName();
            IDirElement containerConfig = this.getMgmtBeanFactory().getConfigServerUtility().getDirectoryService().getFSElement(elementPath, false);
            Properties properties = new Properties();
            properties.setProperty("WINDOWS_SERVICE_NAME", windowsServiceName != null ? windowsServiceName : "");
            properties.setProperty("CONTAINER_PATH", elementPath);
            Container.bootConfigurationToSetupProp((IElement)containerConfig, (Properties)properties);
            targetFolder = targetFolder + File.separator + this.getConfigBeanNameTail() + ".setup";
            File setupINIFile = new File(targetFolder);
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(setupINIFile, false)), true);
            Set<Object> keys = properties.keySet();
            for (String string : keys) {
                String value = properties.getProperty(string);
                writer.println(string + "=" + value);
            }
            writer.close();
        }
        catch (Exception e) {
            throw new MgmtException("Failed to generate setup file", e);
        }
    }

    private void validatePath(String targetPath) throws MgmtException {
        File folder = new File(targetPath);
        if (!folder.exists() || !folder.isDirectory()) {
            throw new MgmtException("The target file path '" + targetPath + "' is not a valid directory path");
        }
    }

    @Override
    public IContainerBean createBackupContainer(String viewName) throws MgmtException {
        block10: {
            if (this.isNewBean()) {
                throw new MgmtException("Container " + this.getContainerName() + " should be saved first.");
            }
            this.verifyComponentsList();
            IContainerBean.IFaultToleranceType ftParams = null;
            boolean isNew = false;
            try {
                ftParams = this.getFaultToleranceParameters();
            }
            catch (Exception e) {
                ftParams = this.createFaultToleranceParameters();
                isNew = true;
            }
            IMgmtBeanBase backup = ftParams.getFaultTolerancePeerRef(null);
            if (backup != null) {
                throw new MgmtException("Can not create backup container - already exists");
            }
            try {
                m_bEnableFT = true;
                ContainerBean bean = (ContainerBean)this.clone(viewName);
                if (bean == null) break block10;
                IContainerBean.IFaultToleranceType backupFTParams = null;
                boolean isbNew = false;
                try {
                    backupFTParams = bean.getFaultToleranceParameters();
                }
                catch (Exception e) {
                    backupFTParams = this.createFaultToleranceParameters();
                    isbNew = true;
                }
                HashMap metaAttr = this.getConfigBean().getMetaAttributes();
                metaAttr.put(EXCLUDE_TEMPLATE_TYPE, Boolean.TRUE);
                this.getConfigBean().setMetaAttributes(metaAttr);
                backupFTParams.setFaultToleranceRole("BACKUP");
                backupFTParams.setFaultTolerancePeerRef(this);
                if (isbNew) {
                    bean.setFaultToleranceParameters(backupFTParams);
                }
                ftParams.setFaultToleranceRole("PRIMARY");
                ftParams.setFaultTolerancePeerRef(bean);
                if (isNew) {
                    this.setFaultToleranceParameters(ftParams);
                }
                m_bEnableFT = false;
                return bean;
            }
            catch (Exception e) {
                m_bEnableFT = false;
                throw new MgmtException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    protected void deleteBean() throws Exception {
        IContainerBean.IFaultToleranceType ftParams = null;
        try {
            ftParams = this.getFaultToleranceParameters();
            MgmtBeanFactory factory = this.getMgmtBeanFactory();
            if (ftParams.getFaultToleranceRole().equals("")) {
                super.deleteBean();
            }
            if (ftParams.getFaultToleranceRole().equals("PRIMARY")) {
                factory.deleteBean(ftParams.getFaultTolerancePeerRef());
                super.deleteBean();
            }
            if (ftParams.getFaultToleranceRole().equals("BACKUP")) {
                IContainerBean peerBean = (IContainerBean)ftParams.getFaultTolerancePeerRef();
                ((ContainerBean)peerBean).resetFT();
                HashMap metaAttr = peerBean.getConfigBean().getMetaAttributes();
                metaAttr.remove(EXCLUDE_TEMPLATE_TYPE);
                peerBean.getConfigBean().setMetaAttributes(metaAttr);
                super.deleteBean();
            }
            this.getMgmtBeanFactory().commit();
        }
        catch (Exception e) {
            super.deleteBean();
        }
    }

    private void resetFT() {
        IContainerBean.IFaultToleranceType ftParams = null;
        try {
            ftParams = this.getFaultToleranceParameters();
            if (ftParams.getFaultToleranceRole().equals("PRIMARY")) {
                m_bEnableFT = true;
                ftParams.setFaultToleranceRole("");
                ftParams.removeAttribute("FAULT_TOLERANCE_PEER_REF");
                m_bEnableFT = false;
            }
        }
        catch (Exception e) {
            m_bEnableFT = false;
        }
    }

    private void verifyComponentsList() throws MgmtException {
        String errorMessage = "Can't create backup broker. This container hosting ";
        IContainerBean.IComponentsType components = this.getComponents();
        List names = components.getKeyNames();
        if (names.isEmpty()) {
            return;
        }
        if (names.contains(DS_RUNTIME_ID)) {
            throw new MgmtException(errorMessage + DS_RUNTIME_ID);
        }
        if (names.contains(AM_RUNTIME_ID)) {
            throw new MgmtException(errorMessage + AM_RUNTIME_ID);
        }
        Iterator i = names.iterator();
        while (i.hasNext()) {
            IContainerBean.IStartupParams params = components.getEntry((String)i.next());
            IMgmtBeanBase refBean = params.getConfigRef();
            String type = refBean.getConfigBean().getConfigType().getName();
            if (type.equals("MQ_BROKER")) {
                throw new MgmtException(errorMessage + "broker component.");
            }
            if (!type.equals("MQ_BACKUPBROKER")) continue;
            throw new MgmtException(errorMessage + "backup broker component.");
        }
    }

    @Override
    public boolean isFaultTolerant() {
        try {
            return !this.getFaultToleranceParameters().getFaultToleranceRole().equals("");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public IMgmtBeanBase clone(String viewName) throws MgmtException {
        IContainerBean.IFaultToleranceType ftParams = null;
        try {
            ftParams = this.getFaultToleranceParameters();
            if (ftParams.getFaultToleranceRole().equals("PRIMARY") || ftParams.getFaultToleranceRole().equals("BACKUP")) {
                throw new MgmtException("Illegal operation.Primary or backup container can't be clone.");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ContainerBean cloneBean = (ContainerBean)super.clone(viewName);
        cloneBean.setContainerName(cloneBean.getConfigBeanNameTail());
        return cloneBean;
    }

    public static class DeploymentParameterType
    extends AbstractContainerBean.AbstractDeploymentParameterType
    implements IContainerBean.IDeploymentParameterType {
        public DeploymentParameterType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class LibraryParams
    extends AbstractContainerBean.AbstractLibraryParams
    implements IContainerBean.ILibraryParams {
        public LibraryParams(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class DeploymentParametersSet
    extends AbstractContainerBean.AbstractDeploymentParametersSet
    implements IContainerBean.IDeploymentParametersSet {
        public DeploymentParametersSet(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class LibrariesType
    extends AbstractContainerBean.AbstractLibrariesType
    implements IContainerBean.ILibrariesType {
        public LibrariesType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class ExtensionType
    extends AbstractContainerBean.AbstractExtensionType
    implements IContainerBean.IExtensionType {
        public ExtensionType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class StartupParams
    extends AbstractContainerBean.AbstractStartupParams
    implements IContainerBean.IStartupParams {
        public StartupParams(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }

        @Override
        public void setConfigRef(IMgmtBeanBase value) throws MgmtException {
            if (!this.validateComponentType(value)) {
                throw new MgmtException("Invalid component type.");
            }
            this.checkDuplicates(value);
            super.setReferenceAttribute("CONFIG_REF", value);
        }

        private void checkDuplicates(IMgmtBeanBase component) throws MgmtException {
            String duplicate = null;
            if (component instanceof IAgentManagerBean || component instanceof IBackupAgentManagerBean) {
                duplicate = ContainerBean.AM_RUNTIME_ID;
            }
            if (component instanceof IDirectoryServiceBean || component instanceof IBackupDirectoryServiceBean) {
                duplicate = ContainerBean.DS_RUNTIME_ID;
            }
            if (duplicate == null) {
                return;
            }
            List cNames = ((IMgmtMapBase)this.getParent()).getKeyNames();
            if (cNames.contains(duplicate)) {
                String type = duplicate.equals(ContainerBean.AM_RUNTIME_ID) ? "MF_AGENT_MANAGER" : "MF_DIRECTORY_SERVICE";
                throw new MgmtException(type + " can't be deployed twice to the container");
            }
        }

        private boolean validateComponentType(IMgmtBeanBase component) {
            return !(component instanceof IContainerBean) && !(component instanceof IComponentCollectionBean) && !(component instanceof IContainerCollectionBean) && !(component instanceof IAuthenticationDomainBean) && !(component instanceof IAuthenticationUserBean) && !(component instanceof IAuthenticationGroupBean);
        }
    }

    public static class ConnectionType
    extends AbstractContainerBean.AbstractConnectionType
    implements IContainerBean.IConnectionType {
        public ConnectionType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class FaultToleranceType
    extends AbstractContainerBean.AbstractFaultToleranceType
    implements IContainerBean.IFaultToleranceType {
        public FaultToleranceType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }

        @Override
        public void setFaultToleranceRole(String value) throws MgmtException {
            if (!m_bEnableFT) {
                throw new MgmtException("Illegal operation");
            }
            CURRENT_FT_ROLE = value;
            super.setFaultToleranceRole(value);
        }

        @Override
        public void setFaultTolerancePeerRef(IMgmtBeanBase value) throws MgmtException {
            if (!m_bEnableFT) {
                throw new MgmtException("Illegal operation");
            }
            super.setFaultTolerancePeerRef(value);
        }

        @Override
        public void setFaultDetectionInterval(int value) throws MgmtException {
            if (!((ContainerBean)this.m_parent).isFaultTolerant()) {
                throw new MgmtException("Illegal operation");
            }
            if (!this.isPrimaryFaultRole()) {
                throw new MgmtException("Cannot set FaultDetectionInterval for Backup Container");
            }
            super.setFaultDetectionInterval(value);
        }

        @Override
        public void setFaultDetectionTimeout(int value) throws MgmtException {
            if (!((ContainerBean)this.m_parent).isFaultTolerant()) {
                throw new MgmtException("Illegal operation");
            }
            if (!this.isPrimaryFaultRole()) {
                throw new MgmtException("Cannot set FaultDetectionTimeout for Backup Container");
            }
            super.setFaultDetectionTimeout(value);
        }

        @Override
        public void setFailureDetectionConnectionurls(String value) throws MgmtException {
            if (!((ContainerBean)this.m_parent).isFaultTolerant()) {
                throw new MgmtException("Illegal operation");
            }
            if (!this.isPrimaryFaultRole()) {
                throw new MgmtException("Cannot set Failure Detection ConnectionURLs for Backup Container");
            }
            super.setFailureDetectionConnectionurls(value);
        }

        @Override
        public void setFailureDetectionDefaultUser(String value) throws MgmtException {
            if (!((ContainerBean)this.m_parent).isFaultTolerant()) {
                throw new MgmtException("Illegal operation");
            }
            if (!this.isPrimaryFaultRole()) {
                throw new MgmtException("Cannot set Failure Detection DefaultUser for Backup Container");
            }
            super.setFailureDetectionDefaultUser(value);
        }

        @Override
        public void setFailureDetectionDefaultPassword(String value) throws MgmtException {
            if (!((ContainerBean)this.m_parent).isFaultTolerant()) {
                throw new MgmtException("Illegal operation");
            }
            if (!this.isPrimaryFaultRole()) {
                throw new MgmtException("Cannot set Failure Detection DefaultPassword for Backup Container");
            }
            super.setFailureDetectionDefaultPassword(value);
        }

        @Override
        public void setFailureDetectionConnectTimeout(int value) throws MgmtException {
            if (!((ContainerBean)this.m_parent).isFaultTolerant()) {
                throw new MgmtException("Illegal operation");
            }
            if (!this.isPrimaryFaultRole()) {
                throw new MgmtException("Cannot set Failure Detection ConnectTimeout for Backup Container");
            }
            super.setFailureDetectionConnectTimeout(value);
        }

        @Override
        public void setFailureDetectionSocketConnectTimeout(int value) throws MgmtException {
            if (!((ContainerBean)this.m_parent).isFaultTolerant()) {
                throw new MgmtException("Illegal operation");
            }
            if (!this.isPrimaryFaultRole()) {
                throw new MgmtException("Cannot set Failure Detection SocketConnectTimeout for Backup Container");
            }
            super.setFailureDetectionSocketConnectTimeout(value);
        }

        private boolean isPrimaryFaultRole() throws MgmtException {
            return "PRIMARY".equals(this.getFaultToleranceRole());
        }
    }

    public static class ExtensionsType
    extends AbstractContainerBean.AbstractExtensionsType
    implements IContainerBean.IExtensionsType {
        public ExtensionsType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class CentralConnectionType
    extends AbstractContainerBean.AbstractCentralConnectionType
    implements IContainerBean.ICentralConnectionType {
        public CentralConnectionType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class EnabledAlertParams
    extends AbstractContainerBean.AbstractEnabledAlertParams
    implements IContainerBean.IEnabledAlertParams {
        public EnabledAlertParams(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class EnabledAlertsType
    extends AbstractContainerBean.AbstractEnabledAlertsType
    implements IContainerBean.IEnabledAlertsType {
        public EnabledAlertsType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }

        @Override
        public void addEntry(String name, IContainerBean.IEnabledAlertParams value) throws MgmtException {
            if (name.endsWith(".*")) {
                throw new MgmtException("Cannot set alerts for a metric pattern containing wild cards '" + name + "'");
            }
            super.addEntry(name, value);
        }
    }

    public static class EnabledMetricsType
    extends AbstractContainerBean.AbstractEnabledMetricsType
    implements IContainerBean.IEnabledMetricsType {
        public EnabledMetricsType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class SystemPropertiesType
    extends AbstractContainerBean.AbstractSystemPropertiesType
    implements IContainerBean.ISystemPropertiesType {
        public SystemPropertiesType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class MetricsCollectionType
    extends AbstractContainerBean.AbstractMetricsCollectionType
    implements IContainerBean.IMetricsCollectionType {
        public MetricsCollectionType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class ComponentsType
    extends AbstractContainerBean.AbstractComponentsType
    implements IContainerBean.IComponentsType {
        public ComponentsType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }

        @Override
        public void add(String name, Object val) throws MgmtException {
            if (val instanceof IContainerBean.IStartupParams) {
                if (!CURRENT_FT_ROLE.equals("")) {
                    this.validateComponentType(((IContainerBean.IStartupParams)val).getConfigRef().getConfigBean().getConfigType().getName());
                }
            } else {
                throw new MgmtException("Invalid object type. Only IContainerBean.IStartupParams can be added to the components list");
            }
            this.validateComponentName(name, ((IContainerBean.IStartupParams)val).getConfigRef());
            super.add(name, val);
        }

        @Override
        public void addEntry(String name, IContainerBean.IStartupParams value) throws MgmtException {
            this.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException {
            IDirectoryFileSystemService ds = super.getMgmtBeanFactory().getConfigServerUtility().getDirectoryService();
            String componentPath = this.getConfigBean().getName() + ":ID=" + name;
            try {
                ((IManagementSecurityConfigurator)ds).removeManagementPermissions(new String[]{componentPath}, "manage");
            }
            catch (DirectoryServiceException e) {
                throw new MgmtException("You are not authorized to (un)set manage permissions already defined for this component, you are therefore not allowed to remove this component from its container", e);
            }
            super.deleteEntry(name);
        }

        private void validateComponentName(String name, IMgmtBeanBase component) throws MgmtException {
            try {
                ValidName.validate(name, 3);
            }
            catch (Exception e) {
                throw new MgmtException("Invalid format name.\nAllowed alpha-numeric, '-' and space characters.", e);
            }
            if (component instanceof IAgentManagerBean || component instanceof IBackupAgentManagerBean) {
                if (!name.equals(ContainerBean.AM_RUNTIME_ID)) {
                    throw new MgmtException("Invalid name. Valid name is - \"AGENT MANAGER\".");
                }
            } else if (component instanceof IDirectoryServiceBean || component instanceof IBackupDirectoryServiceBean) {
                if (!name.equals(ContainerBean.DS_RUNTIME_ID)) {
                    throw new MgmtException("Invalid name. Valid name is - \"DIRECTORY SERVICE\".");
                }
            } else if (name.equals(ContainerBean.AM_RUNTIME_ID) || name.equals(ContainerBean.DS_RUNTIME_ID)) {
                throw new MgmtException(name + " is reserved name.");
            }
        }

        private void validateComponentType(String type) throws MgmtException {
            if (type.equals("MQ_BROKER") || type.equals("MQ_BACKUPBROKER") || type.equals("MF_AGENT_MANAGER") || type.equals("MF_DIRECTORY_SERVICE")) {
                throw new MgmtException("Illegal component");
            }
        }
    }

    public static class CacheType
    extends AbstractContainerBean.AbstractCacheType
    implements IContainerBean.ICacheType {
        public CacheType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }

    public static class MonitoringType
    extends AbstractContainerBean.AbstractMonitoringType
    implements IContainerBean.IMonitoringType {
        public MonitoringType(IMgmtBase parent, String name, boolean isNew) throws MgmtException {
            super(parent, name, isNew);
        }
    }
}

