/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaAttributeList;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.impl.ConfigPathImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class BasicElementPrinter {
    protected String m_elementType = "DeltaElement";
    protected long m_version = -1L;
    protected String m_name;
    protected Set m_newAttributeNames = new HashSet();
    protected Set m_modifiedAttributeNames = new HashSet();
    protected Set m_deletedAttributeNames = new HashSet();

    public BasicElementPrinter(IBasicElement element) {
        this.m_name = element.getIdentity().getName();
        this.m_version = element.getIdentity().getVersion();
        this.parseElement(element);
    }

    protected final void parseElement(IBasicElement element) {
        if (element instanceof IDeltaElement) {
            Object obj = ((IDeltaElement)element).getDeltaAttributes();
            if (obj instanceof IDeltaAttributeSet) {
                this.parseDeltaAttributeSet((IDeltaAttributeSet)obj, new ConfigPathImpl());
            } else {
                System.err.println("Delta element contains attribute set.");
                Iterator names = ((IAttributeSet)obj).getAttributes().keySet().iterator();
                while (names.hasNext()) {
                    this.m_modifiedAttributeNames.add(new ConfigPathImpl((String)names.next()));
                }
            }
        }
    }

    protected void parseDeltaAttributeSet(IDeltaAttributeSet attrSet, IConfigPath path) {
        Object attrValue;
        int i;
        String[] attrNames = attrSet.getDeletedAttributesNames();
        for (i = 0; i < attrNames.length; ++i) {
            this.m_deletedAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
        }
        attrNames = attrSet.getNewAttributesNames();
        for (i = 0; i < attrNames.length; ++i) {
            attrValue = null;
            try {
                attrValue = attrSet.getNewValue(attrNames[i]);
            }
            catch (Exception e) {
                continue;
            }
            if (attrValue instanceof IDeltaAttributeSet) {
                this.parseDeltaAttributeSet((IDeltaAttributeSet)attrValue, new ConfigPathImpl(path).append(attrNames[i]));
                continue;
            }
            if (attrValue instanceof IDeltaAttributeList) {
                this.m_newAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
                continue;
            }
            this.m_newAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
        }
        attrNames = attrSet.getModifiedAttributesNames();
        for (i = 0; i < attrNames.length; ++i) {
            attrValue = null;
            try {
                attrValue = attrSet.getNewValue(attrNames[i]);
            }
            catch (Exception e) {
                continue;
            }
            if (attrValue instanceof IDeltaAttributeSet) {
                this.parseDeltaAttributeSet((IDeltaAttributeSet)attrValue, new ConfigPathImpl(path).append(attrNames[i]));
                continue;
            }
            if (attrValue instanceof IDeltaAttributeList) {
                this.m_modifiedAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
                continue;
            }
            if (attrValue instanceof IAttributeSet) {
                this.parseAttributeSet((IAttributeSet)attrValue, new ConfigPathImpl(path).append(attrNames[i]));
                continue;
            }
            this.m_modifiedAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
        }
    }

    protected void parseAttributeSet(IAttributeSet attrSet, IConfigPath path) {
        for (String attrName : attrSet.getAttributes().keySet()) {
            Object attrValue = attrSet.getAttribute(attrName);
            if (attrValue instanceof IAttributeSet) {
                this.parseAttributeSet((IAttributeSet)attrValue, new ConfigPathImpl(path).append(attrName));
                continue;
            }
            this.m_newAttributeNames.add(new ConfigPathImpl(path).append(attrName));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("IBasicElement:\n");
        buffer.append("{\n");
        buffer.append(this.m_name + " : " + this.m_version + "  [" + this.m_elementType + "] =\n");
        buffer.append("  NewAttributeNames:\n");
        buffer.append("  {\n");
        Iterator it = this.m_newAttributeNames.iterator();
        while (it.hasNext()) {
            buffer.append("    ").append(it.next()).append("\n");
        }
        buffer.append("  }\n");
        buffer.append("  ModifiedAttributeNames:\n");
        buffer.append("  {\n");
        it = this.m_modifiedAttributeNames.iterator();
        while (it.hasNext()) {
            buffer.append("    ").append(it.next()).append("\n");
        }
        buffer.append("  }\n");
        buffer.append("  DeletedAttributeNames:\n");
        buffer.append("  {\n");
        it = this.m_deletedAttributeNames.iterator();
        while (it.hasNext()) {
            buffer.append("    ").append(it.next()).append("\n");
        }
        buffer.append("  }\n");
        buffer.append("}\n");
        return buffer.toString();
    }
}

