/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementChangeHandler;
import com.sonicsw.mf.common.config.INameChangeHandler;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mx.config.ConfigChange;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.impl.CacheDispatcherModule;
import com.sonicsw.mx.config.impl.CheckForEmptyDispatcherModule;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.DispatcherModule;
import com.sonicsw.mx.config.impl.ReferenceDispatcherModule;

class ConfigChangeDispatcher
implements IElementChangeHandler,
INameChangeHandler {
    protected ConfigServer m_cs;
    protected DispatcherModule[] m_modules = null;

    public ConfigChangeDispatcher(ConfigServer cs) {
        this.m_cs = cs;
        this.m_modules = new DispatcherModule[3];
        this.m_modules[0] = new CheckForEmptyDispatcherModule(this.m_cs);
        this.m_modules[1] = new CacheDispatcherModule(this.m_cs);
        this.m_modules[2] = new ReferenceDispatcherModule(this.m_cs);
    }

    public ConfigChangeDispatcher(ConfigServer cs, DispatcherModule[] modules) {
        this.m_cs = cs;
        this.m_modules = modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(ConfigChange configChange) {
        ConfigServer configServer = this.m_cs;
        synchronized (configServer) {
            boolean propagate = false;
            for (int i = 0; i < this.m_modules.length && (propagate = this.m_modules[i].processConfigChange(configChange)); ++i) {
            }
            if (propagate) {
                this.m_cs.sendConfigChange(configChange);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleElementChange(IElementChange element) {
        ConfigServer configServer = this.m_cs;
        synchronized (configServer) {
            this.dispatch(new ConfigChange(element, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNamingNotification(INamingNotification notification) {
        ConfigServer configServer = this.m_cs;
        synchronized (configServer) {
            try {
                this.dispatch(new ConfigChange(notification, null));
            }
            catch (ConfigServiceException configServiceException) {
                // empty catch block
            }
        }
    }
}

