/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.ByteProcedure;
import cern.colt.list.AbstractByteList;
import cern.colt.list.AbstractList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class ByteArrayList
extends AbstractByteList {
    protected byte[] elements;

    public ByteArrayList() {
        this(10);
    }

    public ByteArrayList(byte[] byArray) {
        this.elements(byArray);
    }

    public ByteArrayList(int n) {
        this(new byte[n]);
        this.setSizeRaw(0);
    }

    public void add(byte by) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = by;
    }

    public void beforeInsert(int n, byte by) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = by;
        ++this.size;
    }

    public int binarySearchFromTo(byte by, int n, int n2) {
        return Sorting.binarySearchFromTo(this.elements, by, n, n2);
    }

    public Object clone() {
        ByteArrayList byteArrayList = new ByteArrayList((byte[])this.elements.clone());
        byteArrayList.setSizeRaw(this.size);
        return byteArrayList;
    }

    public ByteArrayList copy() {
        return (ByteArrayList)this.clone();
    }

    public void countSortFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        byte[] byArray = this.elements;
        int[] nArray = new int[256];
        int n3 = n;
        while (n3 <= n2) {
            int n4 = byArray[n3] + 128;
            nArray[n4] = nArray[n4] + 1;
            ++n3;
        }
        int n5 = n;
        byte by = -128;
        int n6 = 0;
        while (n6 < 256) {
            int n7 = nArray[n6];
            if (n7 > 0) {
                if (n7 == 1) {
                    byArray[n5++] = by;
                } else {
                    int n8 = n5 + n7 - 1;
                    this.fillFromToWith(n5, n8, by);
                    n5 = n8 + 1;
                }
            }
            ++n6;
            by = (byte)(by + 1);
        }
    }

    protected void countSortFromTo(int n, int n2, byte by, byte by2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = by2 - by + 1;
        int[] nArray = new int[n3];
        byte[] byArray = this.elements;
        int n4 = n;
        while (n4 <= n2) {
            int n5 = byArray[n4++] - by;
            nArray[n5] = nArray[n5] + 1;
        }
        int n6 = n;
        byte by3 = by;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = nArray[n7];
            if (n8 > 0) {
                if (n8 == 1) {
                    byArray[n6++] = by3;
                } else {
                    int n9 = n6 + n8 - 1;
                    this.fillFromToWith(n6, n9, by3);
                    n6 = n9 + 1;
                }
            }
            ++n7;
            by3 = (byte)(by3 + 1);
        }
    }

    public byte[] elements() {
        return this.elements;
    }

    public AbstractByteList elements(byte[] byArray) {
        this.elements = byArray;
        this.size = byArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ByteArrayList byteArrayList = (ByteArrayList)object;
        if (this.size() != byteArrayList.size()) {
            return false;
        }
        byte[] byArray = this.elements();
        byte[] byArray2 = byteArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (byArray[n] == byArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(ByteProcedure byteProcedure) {
        byte[] byArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (byteProcedure.apply(byArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public byte get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public byte getQuick(int n) {
        return this.elements[n];
    }

    public int indexOfFromTo(byte by, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        byte[] byArray = this.elements;
        int n3 = n;
        while (n3 <= n2) {
            if (by == byArray[n3]) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int lastIndexOfFromTo(byte by, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        byte[] byArray = this.elements;
        int n3 = n2;
        while (n3 >= n) {
            if (by == byArray[n3]) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public AbstractByteList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new ByteArrayList(0);
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        byte[] byArray = new byte[n2 - n + 1];
        System.arraycopy(this.elements, n, byArray, 0, n2 - n + 1);
        return new ByteArrayList(byArray);
    }

    public boolean removeAll(AbstractByteList abstractByteList) {
        double d;
        if (!(abstractByteList instanceof ByteArrayList)) {
            return super.removeAll(abstractByteList);
        }
        if (abstractByteList.size() == 0) {
            return false;
        }
        int n = abstractByteList.size() - 1;
        int n2 = 0;
        byte[] byArray = this.elements;
        int n3 = this.size();
        double d2 = abstractByteList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            ByteArrayList byteArrayList = (ByteArrayList)abstractByteList.clone();
            byteArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (byteArrayList.binarySearchFromTo(byArray[n4], 0, n) < 0) {
                    byArray[n2++] = byArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractByteList.indexOfFromTo(byArray[n5], 0, n) < 0) {
                    byArray[n2++] = byArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractByteList abstractByteList, int n3) {
        if (!(abstractByteList instanceof ByteArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractByteList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            AbstractList.checkRangeFromTo(n, n2, this.size());
            AbstractList.checkRangeFromTo(n3, n3 + n4 - 1, abstractByteList.size());
            System.arraycopy(((ByteArrayList)abstractByteList).elements, n3, this.elements, n, n4);
        }
    }

    public boolean retainAll(AbstractByteList abstractByteList) {
        double d;
        if (!(abstractByteList instanceof ByteArrayList)) {
            return super.retainAll(abstractByteList);
        }
        int n = abstractByteList.size() - 1;
        int n2 = 0;
        byte[] byArray = this.elements;
        int n3 = this.size();
        double d2 = abstractByteList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            ByteArrayList byteArrayList = (ByteArrayList)abstractByteList.clone();
            byteArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (byteArrayList.binarySearchFromTo(byArray[n4], 0, n) >= 0) {
                    byArray[n2++] = byArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractByteList.indexOfFromTo(byArray[n5], 0, n) >= 0) {
                    byArray[n2++] = byArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        byte[] byArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            byte by = byArray[n3];
            byArray[n3++] = byArray[n2];
            byArray[n2--] = by;
        }
    }

    public void set(int n, byte by) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = by;
    }

    public void setQuick(int n, byte by) {
        this.elements[n] = by;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        Uniform uniform = new Uniform(new DRand(new Date()));
        byte[] byArray = this.elements;
        int n3 = n;
        while (n3 < n2) {
            int n4 = uniform.nextIntFromTo(n3, n2);
            byte by = byArray[n4];
            byArray[n4] = byArray[n3];
            byArray[n3] = by;
            ++n3;
        }
    }

    public void sortFromTo(int n, int n2) {
        double d = n2 - n + 1;
        double d2 = d * Math.log(d) / 0.6931471805599453;
        double d3 = 256.0;
        double d4 = Math.max(d3, d);
        if (d4 < d2) {
            this.countSortFromTo(n, n2);
        } else {
            this.quickSortFromTo(n, n2);
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

