/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Blas;
import cern.colt.matrix.linalg.Matrix2DMatrix2DFunction;
import cern.colt.matrix.linalg.SeqBlas;
import cern.colt.matrix.linalg.Smp;
import edu.oswego.cs.dl.util.concurrent.FJTask;

public class SmpBlas
implements Blas {
    public static Blas smpBlas = SeqBlas.seqBlas;
    protected Blas seqBlas;
    protected Smp smp;
    protected int maxThreads;
    protected static int NN_THRESHOLD = 30000;

    protected SmpBlas(int n, Blas blas) {
        this.seqBlas = blas;
        this.maxThreads = n;
        this.smp = new Smp(n);
    }

    public static void allocateBlas(int n, Blas blas) {
        if (smpBlas instanceof SmpBlas) {
            SmpBlas smpBlas = (SmpBlas)SmpBlas.smpBlas;
            if (smpBlas.maxThreads == n && smpBlas.seqBlas == blas) {
                return;
            }
        }
        smpBlas = n <= 1 ? blas : new SmpBlas(n, blas);
    }

    public void assign(DoubleMatrix2D doubleMatrix2D, final DoubleFunction doubleFunction) {
        this.run(doubleMatrix2D, false, new Matrix2DMatrix2DFunction(){

            public double apply(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                SmpBlas.this.seqBlas.assign(doubleMatrix2D, doubleFunction);
                return 0.0;
            }
        });
    }

    public void assign(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, final DoubleDoubleFunction doubleDoubleFunction) {
        this.run(doubleMatrix2D, doubleMatrix2D2, false, new Matrix2DMatrix2DFunction(){

            public double apply(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                SmpBlas.this.seqBlas.assign(doubleMatrix2D, doubleMatrix2D2, doubleDoubleFunction);
                return 0.0;
            }
        });
    }

    public double dasum(DoubleMatrix1D doubleMatrix1D) {
        return this.seqBlas.dasum(doubleMatrix1D);
    }

    public void daxpy(double d, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        this.seqBlas.daxpy(d, doubleMatrix1D, doubleMatrix1D2);
    }

    public void daxpy(double d, DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        this.seqBlas.daxpy(d, doubleMatrix2D, doubleMatrix2D2);
    }

    public void dcopy(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        this.seqBlas.dcopy(doubleMatrix1D, doubleMatrix1D2);
    }

    public void dcopy(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        this.seqBlas.dcopy(doubleMatrix2D, doubleMatrix2D2);
    }

    public double ddot(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        return this.seqBlas.ddot(doubleMatrix1D, doubleMatrix1D2);
    }

    public void dgemm(final boolean bl, final boolean bl2, final double d, DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, final double d2, DoubleMatrix2D doubleMatrix2D3) {
        if (bl) {
            this.dgemm(false, bl2, d, doubleMatrix2D.viewDice(), doubleMatrix2D2, d2, doubleMatrix2D3);
            return;
        }
        if (bl2) {
            this.dgemm(bl, false, d, doubleMatrix2D, doubleMatrix2D2.viewDice(), d2, doubleMatrix2D3);
            return;
        }
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = doubleMatrix2D2.columns();
        if (doubleMatrix2D2.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + doubleMatrix2D.toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (doubleMatrix2D3.rows() != n || doubleMatrix2D3.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + doubleMatrix2D.toStringShort() + ", " + doubleMatrix2D2.toStringShort() + ", " + doubleMatrix2D3.toStringShort());
        }
        if (doubleMatrix2D == doubleMatrix2D3 || doubleMatrix2D2 == doubleMatrix2D3) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long l = 2L * (long)n * (long)n2 * (long)n3;
        int n4 = (int)Math.min(l / 30000L, (long)this.maxThreads);
        boolean bl3 = n3 >= n4;
        int n5 = bl3 ? n3 : n;
        n4 = Math.min(n5, n4);
        if (n4 < 2) {
            this.seqBlas.dgemm(bl, bl2, d, doubleMatrix2D, doubleMatrix2D2, d2, doubleMatrix2D3);
            return;
        }
        int n6 = n5 / n4;
        final FJTask[] fJTaskArray = new FJTask[n4];
        int n7 = 0;
        while (n7 < n4) {
            DoubleMatrix2D doubleMatrix2D4;
            DoubleMatrix2D doubleMatrix2D5;
            DoubleMatrix2D doubleMatrix2D6;
            int n8 = n7 * n6;
            if (n7 == n4 - 1) {
                n6 = n5 - n6 * n7;
            }
            if (bl3) {
                doubleMatrix2D6 = doubleMatrix2D;
                doubleMatrix2D5 = doubleMatrix2D2.viewPart(0, n8, n2, n6);
                doubleMatrix2D4 = doubleMatrix2D3.viewPart(0, n8, n, n6);
            } else {
                doubleMatrix2D6 = doubleMatrix2D.viewPart(n8, 0, n6, n2);
                doubleMatrix2D5 = doubleMatrix2D2;
                doubleMatrix2D4 = doubleMatrix2D3.viewPart(n8, 0, n6, n3);
            }
            fJTaskArray[n7] = new FJTask(){

                public void run() {
                    SmpBlas.this.seqBlas.dgemm(bl, bl2, d, doubleMatrix2D6, doubleMatrix2D5, d2, doubleMatrix2D4);
                }
            };
            ++n7;
        }
        try {
            this.smp.taskGroup.invoke(new FJTask(){

                public void run() {
                    FJTask.coInvoke(fJTaskArray);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void dgemv(final boolean bl, final double d, DoubleMatrix2D doubleMatrix2D, final DoubleMatrix1D doubleMatrix1D, final double d2, DoubleMatrix1D doubleMatrix1D2) {
        if (bl) {
            this.dgemv(false, d, doubleMatrix2D.viewDice(), doubleMatrix1D, d2, doubleMatrix1D2);
            return;
        }
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        long l = 2L * (long)n * (long)n2;
        int n3 = (int)Math.min(l / 30000L, (long)this.maxThreads);
        int n4 = doubleMatrix2D.rows();
        n3 = Math.min(n4, n3);
        if (n3 < 2) {
            this.seqBlas.dgemv(bl, d, doubleMatrix2D, doubleMatrix1D, d2, doubleMatrix1D2);
            return;
        }
        int n5 = n4 / n3;
        final FJTask[] fJTaskArray = new FJTask[n3];
        int n6 = 0;
        while (n6 < n3) {
            int n7 = n6 * n5;
            if (n6 == n3 - 1) {
                n5 = n4 - n5 * n6;
            }
            final DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.viewPart(n7, 0, n5, n2);
            final DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D2.viewPart(n7, n5);
            fJTaskArray[n6] = new FJTask(){

                public void run() {
                    SmpBlas.this.seqBlas.dgemv(bl, d, doubleMatrix2D2, doubleMatrix1D, d2, doubleMatrix1D3);
                }
            };
            ++n6;
        }
        try {
            this.smp.taskGroup.invoke(new FJTask(){

                public void run() {
                    FJTask.coInvoke(fJTaskArray);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void dger(double d, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix2D doubleMatrix2D) {
        this.seqBlas.dger(d, doubleMatrix1D, doubleMatrix1D2, doubleMatrix2D);
    }

    public double dnrm2(DoubleMatrix1D doubleMatrix1D) {
        return this.seqBlas.dnrm2(doubleMatrix1D);
    }

    public void drot(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d, double d2) {
        this.seqBlas.drot(doubleMatrix1D, doubleMatrix1D2, d, d2);
    }

    public void drotg(double d, double d2, double[] dArray) {
        this.seqBlas.drotg(d, d2, dArray);
    }

    public void dscal(double d, DoubleMatrix1D doubleMatrix1D) {
        this.seqBlas.dscal(d, doubleMatrix1D);
    }

    public void dscal(double d, DoubleMatrix2D doubleMatrix2D) {
        this.seqBlas.dscal(d, doubleMatrix2D);
    }

    public void dswap(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        this.seqBlas.dswap(doubleMatrix1D, doubleMatrix1D2);
    }

    public void dswap(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        this.seqBlas.dswap(doubleMatrix2D, doubleMatrix2D2);
    }

    public void dsymv(boolean bl, double d, DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, double d2, DoubleMatrix1D doubleMatrix1D2) {
        this.seqBlas.dsymv(bl, d, doubleMatrix2D, doubleMatrix1D, d2, doubleMatrix1D2);
    }

    public void dtrmv(boolean bl, boolean bl2, boolean bl3, DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        this.seqBlas.dtrmv(bl, bl2, bl3, doubleMatrix2D, doubleMatrix1D);
    }

    public int idamax(DoubleMatrix1D doubleMatrix1D) {
        return this.seqBlas.idamax(doubleMatrix1D);
    }

    protected double[] run(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, boolean bl, Matrix2DMatrix2DFunction matrix2DMatrix2DFunction) {
        double[] dArray;
        DoubleMatrix2D[][] doubleMatrix2DArray = this.smp.splitBlockedNN(doubleMatrix2D, doubleMatrix2D2, NN_THRESHOLD, doubleMatrix2D.rows() * doubleMatrix2D.columns());
        int n = doubleMatrix2DArray != null ? doubleMatrix2DArray[0].length : 1;
        double[] dArray2 = dArray = bl ? new double[n] : null;
        if (doubleMatrix2DArray == null) {
            double d = matrix2DMatrix2DFunction.apply(doubleMatrix2D, doubleMatrix2D2);
            if (bl) {
                dArray[0] = d;
            }
            return dArray;
        }
        this.smp.run(doubleMatrix2DArray[0], doubleMatrix2DArray[1], dArray, matrix2DMatrix2DFunction);
        return dArray;
    }

    protected double[] run(DoubleMatrix2D doubleMatrix2D, boolean bl, Matrix2DMatrix2DFunction matrix2DMatrix2DFunction) {
        double[] dArray;
        DoubleMatrix2D[] doubleMatrix2DArray = this.smp.splitBlockedNN(doubleMatrix2D, NN_THRESHOLD, doubleMatrix2D.rows() * doubleMatrix2D.columns());
        int n = doubleMatrix2DArray != null ? doubleMatrix2DArray.length : 1;
        double[] dArray2 = dArray = bl ? new double[n] : null;
        if (doubleMatrix2DArray == null) {
            double d = matrix2DMatrix2DFunction.apply(doubleMatrix2D, null);
            if (bl) {
                dArray[0] = d;
            }
            return dArray;
        }
        this.smp.run(doubleMatrix2DArray, null, dArray, matrix2DMatrix2DFunction);
        return dArray;
    }

    public void stats() {
        if (this.smp != null) {
            this.smp.stats();
        }
    }

    private double xsum(DoubleMatrix2D doubleMatrix2D) {
        double[] dArray = this.run(doubleMatrix2D, true, new Matrix2DMatrix2DFunction(){

            public double apply(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                return doubleMatrix2D.zSum();
            }
        });
        double d = 0.0;
        int n = dArray.length;
        while (--n >= 0) {
            d += dArray[n];
        }
        return d;
    }
}

