/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.DatabaseRootEnumeration;
import com.odi.DatabaseSegmentEnumeration;
import com.odi.ObjectStoreConstants;
import com.odi.PersistentTypeSummary;
import com.odi.Placement;
import com.odi.Segment;
import com.odi.imp.ObjectManager;
import com.odi.imp.Utilities;
import com.odi.util.query.Query;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public abstract class Database
extends Placement
implements ObjectStoreConstants {
    public static final int ownerRead = 256;
    public static final int ownerWrite = 128;
    public static final int ownerExecute = 64;
    public static final int groupRead = 32;
    public static final int groupWrite = 16;
    public static final int groupExecute = 8;
    public static final int otherRead = 4;
    public static final int otherWrite = 2;
    public static final int otherExecute = 1;
    public static final int allRead = 292;
    public static final int allWrite = 146;
    public static final int allExecute = 73;
    protected static final int notOpen = 0;
    public static final int openUpdate = 7;
    public static final int openReadOnly = 6;
    public static final int openMVCC = 3;

    public static Database create(String name, int fileMode) {
        return com.odi.imp.Database.create(name, fileMode, null);
    }

    public static Database create(String name, int fileMode, HashMap parameters) {
        return com.odi.imp.Database.create(name, fileMode, parameters);
    }

    public static Database create(String name, int fileMode, int schemaInstallMode) {
        return com.odi.imp.Database.create(name, fileMode, schemaInstallMode);
    }

    public static Database open(String name, int openMode) {
        return com.odi.imp.Database.open(name, openMode, null);
    }

    public static Database open(String name, int openMode, HashMap parameters) {
        return com.odi.imp.Database.open(name, openMode, parameters);
    }

    public abstract Database open(int var1);

    public abstract boolean isOpen();

    public abstract void close();

    public abstract void backup(String var1);

    public abstract void close(boolean var1);

    public abstract void destroy();

    public abstract String getPath();

    public abstract long getSizeInBytes();

    public abstract int getOpenMode();

    public abstract Object getRoot(String var1);

    public abstract void setRoot(String var1, Object var2);

    public abstract void createRoot(String var1, Object var2);

    public abstract void destroyRoot(String var1);

    public abstract DatabaseRootEnumeration getRoots();

    public abstract Segment createSegment();

    public abstract Segment getSegment(int var1);

    public abstract Segment getDefaultSegment();

    public abstract void setDefaultSegment(Segment var1);

    public abstract DatabaseSegmentEnumeration getSegments();

    public static Database of(Object object) {
        if (object == null) {
            Utilities.throwNullArgumentException("Database", "of", "object");
        }
        return ObjectManager.databaseOf(object);
    }

    public abstract void acquireLock(int var1, int var2);

    public abstract void affiliate(Database var1, boolean var2);

    public abstract Iterator getAffiliatedDatabases();

    public abstract boolean check(PrintStream var1);

    public void showDB(String dbName, PrintStream out, boolean showObj, boolean showData) {
        this.show(out, showObj, showData);
    }

    public void show(PrintStream out, boolean showObj, boolean showData) {
        this.show(out, showObj, showData, null);
    }

    public abstract void show(PrintStream var1, boolean var2, boolean var3, Query var4);

    public abstract Properties GC();

    public abstract Properties GC(Properties var1);

    public abstract void installTypes(PersistentTypeSummary var1);

    public static void evolveSchema(String dbName, String workdbName, PersistentTypeSummary summary) {
        com.odi.imp.Database.evolveSchema(dbName, workdbName, summary);
    }

    public abstract String getHostName();

    public abstract void resync();

    protected Database() {
    }
}

