/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectException;
import com.odi.ObjectStoreConstants;
import com.odi.Placement;
import com.odi.Session;
import com.odi.imp.ObjectManager;
import com.odi.imp.Utilities;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class ObjectStore
implements ObjectStoreConstants {
    public static final int OPEN_UPDATE = 7;
    public static final int OPEN_READONLY = 6;
    public static final int OPEN_MVCC = 3;
    public static final int OPEN_UPDATE_NON_BLOCKING = 4;
    public static final int OPEN_READONLY_NON_BLOCKING = 5;
    public static final int OPEN_DEFAULT = 8;
    private static boolean lazyWriteLocking = false;

    public static int majorRelease() {
        return 8;
    }

    public static int minorRelease() {
        return 6;
    }

    public static int maintenanceRelease() {
        return 299;
    }

    public static String productName() {
        return ObjectManager.productName();
    }

    public static int whichProduct() {
        return ObjectManager.whichProduct();
    }

    public static String storageSystemName() {
        return ObjectManager.storageSystemName();
    }

    public static boolean initialize(String host, Properties properties) {
        Session s = Session.getCurrent();
        if (s != null && s.isActive()) {
            return false;
        }
        Session.leave();
        s = Session.create(host, properties);
        s.join();
        return true;
    }

    public static void shutdown(boolean force) {
        Session s = Session.getCurrent();
        if (s != null) {
            s.leave();
            if (force) {
                s.terminate();
            }
        }
    }

    public static void setNumExpectedSessions(int numExpectedSessions) {
    }

    public static void setLazyWriteLocking(boolean onOff) {
        lazyWriteLocking = onOff;
    }

    public static boolean getLazyWriteLocking() {
        return lazyWriteLocking;
    }

    public static int getAutoOpenMode() {
        return ObjectManager.getAutoOpenMode();
    }

    public static void setAutoOpenMode(int openMode) {
        ObjectManager.setAutoOpenMode(openMode);
    }

    public static void fetch(Object object) {
        if (object instanceof IPersistent) {
            ObjectStore.fetch((IPersistent)object);
            return;
        }
        if (Utilities.isArray(object)) {
            ObjectManager.fetch(object);
        }
    }

    public static void fetch(IPersistent object) {
        if (object.ODIgetState() < 0) {
            ObjectManager.fetch(object);
        }
    }

    public static void fetch(Object[] array) {
        if (array.length > 0 && array[0] == null) {
            ObjectManager.fetch(array);
        }
    }

    public static void fetch(byte[] array) {
        if (array.length > 0 && array[0] == 0) {
            ObjectManager.fetch(array);
        }
    }

    public static void fetch(char[] array) {
        if (array.length > 0 && array[0] == '\u0000') {
            ObjectManager.fetch(array);
        }
    }

    public static void fetch(short[] array) {
        if (array.length > 0 && array[0] == 0) {
            ObjectManager.fetch(array);
        }
    }

    public static void fetch(int[] array) {
        if (array.length > 0 && array[0] == 0) {
            ObjectManager.fetch(array);
        }
    }

    public static void fetch(long[] array) {
        if (array.length > 0 && array[0] == 0L) {
            ObjectManager.fetch(array);
        }
    }

    public static void fetch(boolean[] array) {
        if (array.length > 0 && !array[0]) {
            ObjectManager.fetch(array);
        }
    }

    public static void fetch(float[] array) {
        if (array.length > 0 && array[0] == 0.0f) {
            ObjectManager.fetch(array);
        }
    }

    public static void fetch(double[] array) {
        if (array.length > 0 && array[0] == 0.0) {
            ObjectManager.fetch(array);
        }
    }

    public static void fetch(String s) {
    }

    public static void deepFetch(Object object) {
        ObjectManager.deepFetch(object);
    }

    public static void deepFetch(String s) {
    }

    public static void dirty(Object object) {
        if (object instanceof IPersistent) {
            ObjectStore.dirty((IPersistent)object);
        } else if (Utilities.isArray(object)) {
            ObjectManager.dirty(object);
        } else if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double) {
            throw new ObjectException("Attempt to call dirty() on an immutable object.");
        }
    }

    public static void dirty(IPersistent object) {
        if ((object.ODIgetState() & 2) != 0) {
            ObjectManager.dirty(object);
        }
    }

    public static void dirty(Object[] array) {
        ObjectManager.dirty(array);
    }

    public static void dirty(String s) {
        throw new ObjectException("Attempt to call dirty() on a String, which cannot be modified.");
    }

    public static void destroy(Object object) {
        if (object instanceof IPersistentHooks) {
            ((IPersistentHooks)object).preDestroyPersistent();
        }
        ObjectManager.destroy(object);
    }

    public static void destroy(IPersistent object) {
        if (object != null && object instanceof IPersistentHooks) {
            ((IPersistentHooks)((Object)object)).preDestroyPersistent();
        }
        ObjectManager.destroy(object);
    }

    public static void migrate(Object object, Placement placement) {
        if (object == null) {
            Utilities.throwNullArgumentException("ObjectStore", "migrate", "object");
        }
        if (placement == null) {
            Utilities.throwNullArgumentException("ObjectStore", "migrate", "placement");
        }
        ObjectManager.migrate(object, placement);
    }

    public static void migrate(Object object, Placement placement, boolean export) {
        ObjectStore.migrate(object, placement);
    }

    public static boolean isPersistent(Object object) {
        return ObjectManager.isPersistent(object);
    }

    public static boolean isPersistent(IPersistent object) {
        return ObjectManager.isPersistent(object);
    }

    public static boolean isPersistent(Object[] object) {
        return ObjectManager.isPersistent(object);
    }

    public static void evict(Object object) {
        if (object == null) {
            return;
        }
        ObjectManager.evict(object, 2);
    }

    public static void evict(IPersistent object) {
        if (object == null) {
            return;
        }
        ObjectManager.evict(object, 2);
    }

    public static void evict(String string) {
        if (string == null) {
            return;
        }
        ObjectManager.evict(string, 2);
    }

    public static void evict(Object object, int retain) {
        if (object == null) {
            return;
        }
        ObjectManager.evict(object, retain);
    }

    public static void evict(IPersistent object, int retain) {
        if (object == null) {
            return;
        }
        ObjectManager.evict(object, retain);
    }

    public static void evictAll(int retain) {
        ObjectManager.evictAll(retain);
    }

    public static void evictAndForget(Object object) {
        if (object == null) {
            return;
        }
        ObjectStore.clearCache();
        ObjectManager.evict(object, 1);
    }

    public static Iterator getCachedObjects() {
        return ObjectManager.getCachedObjects();
    }

    public static void decache(Object cachedObject) {
        if (cachedObject == null) {
            return;
        }
        ObjectManager.decache(cachedObject);
    }

    public static void clearCache() {
        ObjectManager.clearCache();
    }

    public static void clearCache(int nTransactions) {
        ObjectManager.clearCache(nTransactions);
    }

    public static int getCachedObjectTxnAge(Object cachedObject) {
        return ObjectManager.getCachedObjectTxnAge(cachedObject);
    }

    public static final boolean isStale(Object object) {
        return ObjectManager.isStale(object);
    }

    public static final boolean isDestroyed(Object object) {
        return ObjectManager.isDestroyed(object);
    }

    public static void acquireLock(Object object, int lockType, int timeoutMillis) {
        ObjectManager.acquireLock(object, lockType, timeoutMillis);
    }

    public static void _instanceBecome(Object otherObject, Object thisObject) {
        ObjectManager.instanceBecome(otherObject, thisObject);
    }

    public static void _classBecome(Hashtable table) {
        ObjectManager.classBecome(table);
    }

    public static void _renameClass(String oldClassName, String newClassName) {
        ObjectManager.renameClass(oldClassName, newClassName);
    }

    public static void _deleteClass(String className) {
        ObjectManager.deleteClass(className);
    }

    public static void setPlacementForSerialization(Placement placement) {
        ObjectManager.setPlacementForSerialization(placement);
    }

    public static Placement getPlacementForSerialization() {
        return ObjectManager.getPlacementForSerialization(false);
    }

    public static void setLockTimeout(int milliseconds) {
        ObjectManager.setLockTimeout(milliseconds);
    }

    public static int getLockTimeout() {
        return ObjectManager.getLockTimeout();
    }

    private ObjectStore() {
    }
}

