/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.FatalInternalException;
import com.odi.IPersistent;
import com.odi.NoSessionException;
import com.odi.Transaction;
import com.odi.TransactionSynchronization;
import com.odi.WrongSessionException;
import com.odi.imp.ObjectManager;
import java.util.Properties;

public abstract class Session {
    private String name;
    private boolean isActive = true;
    private boolean beingTerminated = false;
    private boolean isTerminatedFatal = false;
    private static int nameCounter = 0;
    private static ThreadLocal s_currentSession = new ThreadLocal();

    public static Session create(String host, Properties properties) {
        return new ObjectManager(host, properties, null);
    }

    public static Session create(String host, Properties properties, String name) {
        return new ObjectManager(host, properties, name);
    }

    public void terminate() {
        this.terminate(false);
    }

    public synchronized void join() {
        this.assureActive("join");
        Session s = Session.getCurrent();
        if (s == this) {
            return;
        }
        if (s != null) {
            throw new WrongSessionException("Attempt to join session " + this.name + ", but the current thread is already associated with session " + s.getName() + ".");
        }
        s_currentSession.set(this);
    }

    public static void leave() {
        s_currentSession.set(null);
    }

    public static Session getCurrent() {
        Session s = (Session)s_currentSession.get();
        if (s == null || !s.isActive()) {
            return null;
        }
        return s;
    }

    public abstract Transaction currentTransaction();

    public abstract boolean inTransaction();

    public final boolean isActive() {
        return this.isActive;
    }

    public final String getName() {
        return this.name;
    }

    public abstract Properties getCounters(boolean var1);

    protected Session(String name) {
        this.name = name == null ? "Session" + ++nameCounter : name;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.name + ")@" + Integer.toHexString(this.hashCode());
    }

    protected synchronized void terminate(boolean fatal) {
        if (this.beingTerminated) {
            return;
        }
        this.beingTerminated = true;
        if (Boolean.valueOf(((ObjectManager)this).getProperty("com.odi.printCounters")).booleanValue()) {
            this.getCounters(false).list(System.err);
        }
        Exception exceptionDuringAbort = null;
        try {
            this.abortTransactionInTerminate();
        }
        catch (Exception e) {
            exceptionDuringAbort = e;
        }
        this.isActive = false;
        this.isTerminatedFatal = fatal;
        this.terminateInternal();
        if (exceptionDuringAbort != null) {
            String name = exceptionDuringAbort.getClass().getName();
            if (name.equals("com.odi.test.ObjectStore.DebugException")) {
                throw (RuntimeException)exceptionDuringAbort;
            }
            throw new FatalInternalException("Exception occurred while aborting transaction " + exceptionDuringAbort);
        }
    }

    public void assureActive(String operation) {
        if (!this.isActive) {
            throw new NoSessionException("Attempt to " + operation + " session " + this.name + ", which was terminated" + (this.isTerminatedFatal ? " by a fatal exception." : "."));
        }
    }

    protected abstract void terminateInternal();

    protected abstract void abortTransactionInTerminate();

    public IPersistent remapObject(IPersistent persistentObject) {
        return ((ObjectManager)this).remapObjectInternal(persistentObject);
    }

    public abstract Properties getSessionProperties();

    public abstract String getSessionProperty(String var1);

    public abstract void addTransactionSynchronization(TransactionSynchronization var1);

    public abstract void removeTransactionSynchronization(TransactionSynchronization var1);
}

