/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.Snapshot;
import java.util.Vector;

public class SnapshotPool {
    private String m_dbName;
    private String m_poolName;
    private long m_defaultAgeLimit = 1000L;
    private Vector m_pool = new Vector();
    private Snapshot m_newestSnapshot = null;

    public SnapshotPool(String dbName) {
        this.m_dbName = dbName;
        this.m_poolName = dbName;
    }

    public SnapshotPool(String dbName, String poolName, long defaultAgeLimit) {
        this.m_dbName = dbName;
        this.m_poolName = poolName;
        this.m_defaultAgeLimit = defaultAgeLimit;
    }

    public SnapshotPool(String dbName, int maxPoolSize) {
        this.m_dbName = dbName;
        this.m_poolName = dbName;
    }

    public String getDbName() {
        return this.m_dbName;
    }

    public String getPoolName() {
        return this.m_poolName;
    }

    public synchronized int getPoolSize() {
        return this.m_pool.size();
    }

    public synchronized long getDefaultAgeLimit() {
        return this.m_defaultAgeLimit;
    }

    public synchronized void setDefaultAgeLimit(long defaultAgeLimit) {
        this.m_defaultAgeLimit = defaultAgeLimit;
    }

    public synchronized Snapshot joinSnapshot() {
        return this.joinSnapshot(this.m_defaultAgeLimit);
    }

    public synchronized Snapshot joinSnapshot(long ageLimit) {
        long age;
        if (this.m_newestSnapshot != null && this.m_newestSnapshot.isActive() && (age = System.currentTimeMillis() - this.m_newestSnapshot.getStartTime()) < ageLimit) {
            this.m_newestSnapshot.join();
            return this.m_newestSnapshot;
        }
        return this.joinNewSnapshot();
    }

    public synchronized Snapshot joinNewSnapshot() {
        Snapshot ss;
        if (this.m_newestSnapshot != null && !this.m_newestSnapshot.isActive()) {
            this.m_newestSnapshot.join();
            return this.m_newestSnapshot;
        }
        for (int i = 0; i < this.m_pool.size(); ++i) {
            ss = (Snapshot)this.m_pool.get(i);
            if (ss.isActive()) continue;
            this.m_newestSnapshot = ss;
            ss.join();
            return ss;
        }
        String ssName = this.m_poolName + " Snapshot #" + (this.m_pool.size() + 1);
        ss = new Snapshot(ssName, this.m_dbName);
        this.m_pool.add(ss);
        this.m_newestSnapshot = ss;
        ss.join();
        return ss;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.m_pool.size(); ++i) {
            Snapshot ss = (Snapshot)this.m_pool.get(i);
            ss.terminate();
        }
        this.m_pool.clear();
        this.m_newestSnapshot = null;
    }
}

