/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.ClassAction;
import com.odi.filter.ClassControl;
import com.odi.filter.FieldNote;
import com.odi.filter.FieldTypeInfo;
import com.odi.filter.FilterEnv;
import com.odi.filter.FilterError;
import com.odi.filter.classfile.ClassField;
import com.odi.filter.classfile.ClassFile;
import com.odi.filter.classfile.Descriptor;
import com.odi.filter.classfile.VMConstants;
import java.util.Hashtable;

final class FieldAction
implements VMConstants {
    private ClassField theField;
    private ClassAction theClass;
    private boolean fieldIsPersistent;
    private boolean fieldIsIndexable;
    private boolean fieldIsEmbeddable;
    private int nFieldArrayDims;
    private String fieldClassName;
    private FieldTypeInfo fieldTypeInfo;
    private int fieldIndex = -1;
    private FieldNote fieldNote;

    String typeDescriptor() {
        return this.theField.signature().asString();
    }

    String typeName() {
        String typeDesc = this.typeDescriptor();
        if (typeDesc.charAt(0) == 'L') {
            return typeDesc.substring(1, typeDesc.length() - 1);
        }
        return typeDesc;
    }

    int index() {
        if (this.fieldIndex < 0) {
            throw new FilterError("The field index has not yet been set");
        }
        return this.fieldIndex;
    }

    void setIndex(int idx) {
        this.fieldIndex = idx;
    }

    boolean isPersistent() {
        return this.fieldIsPersistent;
    }

    boolean isEmbeddable() {
        return this.fieldIsEmbeddable;
    }

    int embeddedLength() {
        return this.fieldNote.getNoteFieldEmbeddedLength();
    }

    static boolean fieldIsPersistent(ClassFile theClass, ClassField field, FilterEnv env) {
        if (field.isStatic()) {
            return false;
        }
        if (field.isFinal()) {
            return false;
        }
        String className = theClass.className().asString();
        String fieldName = field.name().asString();
        return !field.isTransient() && !env.isAddedTransientField(className, fieldName) || env.isIgnoreTransientField(className, fieldName);
    }

    boolean isIndexable() {
        return this.fieldIsIndexable;
    }

    String fieldName() {
        return this.theField.name().asString();
    }

    boolean isSynthetic() {
        return this.theField.attributes().findAttribute("Synthetic") != null;
    }

    String createMethod() {
        return this.fieldTypeInfo.fieldCreateMethod;
    }

    String createMethodSig() {
        return this.fieldTypeInfo.fieldCreateMethodSig;
    }

    String setMethod() {
        return this.fieldTypeInfo.fieldSetMethod;
    }

    String setMethodSig() {
        return this.fieldTypeInfo.fieldSetMethodSig;
    }

    int setMethodArg() {
        return this.fieldTypeInfo.fieldSetArgType;
    }

    String getMethod() {
        return this.fieldTypeInfo.fieldGetMethod;
    }

    String getMethodSig() {
        return this.fieldTypeInfo.fieldGetMethodSig;
    }

    int getMethodReturn() {
        return this.fieldTypeInfo.fieldGetReturnType;
    }

    String fieldClassName() {
        return this.fieldClassName;
    }

    int nDims() {
        return this.nFieldArrayDims;
    }

    FieldAction(ClassAction classAction, ClassField fld) {
        this.theClass = classAction;
        this.theField = fld;
    }

    FieldNote getFieldNote() {
        return this.fieldNote;
    }

    private FieldNote makeFieldNote() {
        if (this.fieldNote == null) {
            this.fieldNote = new FieldNote(this);
        }
        return this.fieldNote;
    }

    void check(FilterEnv env) {
        boolean fieldShouldBeTransient;
        boolean makeFieldIndexable;
        String sig = this.theField.signature().asString();
        this.fieldTypeInfo = FieldTypeInfo.determineFieldType(sig, env);
        String className = this.theClass.className();
        String userClass = this.theClass.userClassName();
        String fieldName = this.theField.name().asString();
        String fullFieldName = this.userFieldName();
        boolean makeFieldEmbedded = env.isEmbeddedField(className, fieldName);
        if (makeFieldEmbedded) {
            env.processedEmbeddedField(className, fieldName);
            this.fieldIsEmbeddable = true;
            if (this.fieldTypeInfo == FieldTypeInfo.stringInfo) {
                this.fieldTypeInfo = FieldTypeInfo.embeddedStringInfo;
                this.makeFieldNote().setNoteFieldEmbeddedLength(env.getEmbeddedFieldSize(className, fieldName));
            } else {
                env.error("Field " + fullFieldName + " could not be embedded. " + "Only strings can be embedded via OSCFP for now.");
            }
        }
        if (makeFieldIndexable = env.isFieldIndexable(className, fieldName)) {
            env.processedIndexableField(className, fieldName);
            this.makeFieldNote().setNoteFieldIndexable(true);
        }
        boolean nonDefaultTransient = env.isAddedTransientField(className, fieldName);
        boolean nonDefaultPersistent = env.isIgnoreTransientField(className, fieldName);
        boolean bl = fieldShouldBeTransient = (this.theField.isTransient() || nonDefaultTransient) && !nonDefaultPersistent;
        if (nonDefaultTransient) {
            this.makeFieldNote().setNoteFieldTransient(true);
        }
        if (nonDefaultPersistent) {
            this.makeFieldNote().setNoteFieldPersistent(true);
        }
        this.nFieldArrayDims = 0;
        while (sig.charAt(this.nFieldArrayDims) == '[') {
            ++this.nFieldArrayDims;
        }
        if (sig.charAt(this.nFieldArrayDims) == 'L') {
            this.fieldClassName = sig.substring(this.nFieldArrayDims + 1, sig.length() - 1);
        }
        int fieldAccess = this.theField.access();
        if (this.theField.isStatic()) {
            if (makeFieldIndexable) {
                String msg = fullFieldName + " is a static field which can not be made indexable.";
                env.warning(msg, userClass, fieldName);
            }
            boolean possiblyPersistent = false;
            if (this.nFieldArrayDims > 0) {
                possiblyPersistent = true;
            } else if (this.fieldClassName != null) {
                ClassControl tcc = env.findClass(this.fieldClassName);
                if (tcc == null) {
                    if (this.fieldClassName.equals("java/lang/Object") || env.isKnownPersistent(this.fieldClassName)) {
                        possiblyPersistent = true;
                    }
                } else if (tcc.persistType() == 1 || tcc.implementsIPersistent(env)) {
                    possiblyPersistent = true;
                }
            }
            if (possiblyPersistent) {
                String msg = fullFieldName + " is a static field of type " + this.userSig(sig) + " which might refer to a persistent object. " + " If this field does refer to a persistent object it must" + " be user maintained.";
                env.warning(msg, userClass, fieldName);
            }
        } else if (fieldShouldBeTransient && makeFieldIndexable) {
            String msg = fullFieldName + " is a transient field which can not be made indexable.";
            env.warning(msg, userClass, fieldName);
        } else if (!fieldShouldBeTransient) {
            String msg;
            ClassControl tcc;
            if (!(this.fieldClassName == null || (tcc = env.findClass(this.fieldClassName)) != null && tcc.persistCapable(env) || this.fieldClassName.equals("java/lang/Object") || this.fieldClassName.equals("com/odi/Persistent") || this.fieldClassName.equals("com/odi/IPersistent") || env.isKnownPersistent(this.fieldClassName))) {
                String msg2 = null;
                if (tcc == null) {
                    msg2 = fullFieldName + " is declared to be of type " + this.userSig(sig) + " and class " + ClassControl.userClassFromVMClass(this.fieldClassName) + " can't be located in the classpath.";
                    env.error(msg2);
                    return;
                }
                if (!tcc.implementsIPersistent(env)) {
                    msg2 = fullFieldName + " is of type " + this.userSig(sig) + " and class " + ClassControl.userClassFromVMClass(this.fieldClassName) + " is not persistence capable.";
                    env.error(msg2);
                    return;
                }
                msg2 = fullFieldName + " appears to not be persistent, but we'll assume that it is.";
                env.warning(msg2);
            }
            if (this.theField.isFinal() && !env.allowFinalModifications() && !this.isSynthetic()) {
                msg = fullFieldName + " is final and can not be made persistent.  Remove the " + " \"final\" keyword if you want it stored persistently.";
                env.warning(msg, userClass, fieldName);
            } else {
                if (this.theField.isFinal()) {
                    if (!this.isSynthetic()) {
                        msg = "The final qualifier for " + fullFieldName + " is being removed to allow it to be made persistent.";
                        env.warning(msg, userClass, fieldName);
                    }
                    this.theField.setIsFinal(false);
                }
                this.fieldIsPersistent = true;
                this.fieldIsIndexable = makeFieldIndexable;
                if (this.fieldIsIndexable) {
                    env.message("Field " + fullFieldName + " will be indexable.");
                }
            }
        }
    }

    void notePersistentAddition(FilterEnv env) {
        String sig = this.theField.signature().asString();
        this.fieldTypeInfo = FieldTypeInfo.determineFieldType(sig, env);
        this.fieldIsPersistent = true;
    }

    void retarget(FilterEnv env, Hashtable classTranslations) {
        String mapTo;
        if (this.fieldClassName != null && (mapTo = (String)classTranslations.get(this.fieldClassName)) != null) {
            this.fieldClassName = mapTo;
        }
    }

    String userFieldName() {
        return this.theClass.userClassName() + "." + this.theField.name().asString();
    }

    private String userSig(String vmSig) {
        return Descriptor.userFieldSig(vmSig);
    }
}

