/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.ClassControl;
import com.odi.filter.FilterEnv;
import com.odi.filter.FilterError;
import com.odi.filter.classfile.VMConstants;

class FieldTypeInfo
implements VMConstants {
    String fieldCreateMethod;
    String fieldCreateMethodSig;
    String fieldGetMethod;
    String fieldGetMethodSig;
    int fieldGetReturnType;
    String fieldSetMethod;
    String fieldSetMethodSig;
    int fieldSetArgType;
    private static FieldTypeInfo byteInfo = new FieldTypeInfo("createByte", "(Ljava/lang/String;)Lcom/odi/Field;", "setByteField", "(IBLcom/odi/ClassInfo;)V", 8, "getByteField", "(ILcom/odi/ClassInfo;)B", 8);
    private static FieldTypeInfo charInfo = new FieldTypeInfo("createChar", "(Ljava/lang/String;)Lcom/odi/Field;", "setCharField", "(ICLcom/odi/ClassInfo;)V", 5, "getCharField", "(ILcom/odi/ClassInfo;)C", 5);
    private static FieldTypeInfo shortInfo = new FieldTypeInfo("createShort", "(Ljava/lang/String;)Lcom/odi/Field;", "setShortField", "(ISLcom/odi/ClassInfo;)V", 9, "getShortField", "(ILcom/odi/ClassInfo;)S", 9);
    private static FieldTypeInfo intInfo = new FieldTypeInfo("createInt", "(Ljava/lang/String;)Lcom/odi/Field;", "setIntField", "(IILcom/odi/ClassInfo;)V", 10, "getIntField", "(ILcom/odi/ClassInfo;)I", 10);
    private static FieldTypeInfo longInfo = new FieldTypeInfo("createLong", "(Ljava/lang/String;)Lcom/odi/Field;", "setLongField", "(IJLcom/odi/ClassInfo;)V", 11, "getLongField", "(ILcom/odi/ClassInfo;)J", 11);
    private static FieldTypeInfo floatInfo = new FieldTypeInfo("createFloat", "(Ljava/lang/String;)Lcom/odi/Field;", "setFloatField", "(IFLcom/odi/ClassInfo;)V", 6, "getFloatField", "(ILcom/odi/ClassInfo;)F", 6);
    private static FieldTypeInfo doubleInfo = new FieldTypeInfo("createDouble", "(Ljava/lang/String;)Lcom/odi/Field;", "setDoubleField", "(IDLcom/odi/ClassInfo;)V", 7, "getDoubleField", "(ILcom/odi/ClassInfo;)D", 7);
    private static FieldTypeInfo booleanInfo = new FieldTypeInfo("createBoolean", "(Ljava/lang/String;)Lcom/odi/Field;", "setBooleanField", "(IZLcom/odi/ClassInfo;)V", 4, "getBooleanField", "(ILcom/odi/ClassInfo;)Z", 4);
    private static FieldTypeInfo classInfo = new FieldTypeInfo("createClass", "(Ljava/lang/String;Ljava/lang/String;)Lcom/odi/Field;", "setClassField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getClassField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo interfaceInfo = new FieldTypeInfo("createInterface", "(Ljava/lang/String;Ljava/lang/String;)Lcom/odi/Field;", "setInterfaceField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getInterfaceField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    static FieldTypeInfo stringInfo = new FieldTypeInfo("createString", "(Ljava/lang/String;)Lcom/odi/Field;", "setStringField", "(ILjava/lang/String;Lcom/odi/ClassInfo;)V", 14, "getStringField", "(ILcom/odi/ClassInfo;)Ljava/lang/String;", 14);
    static FieldTypeInfo embeddedStringInfo = new FieldTypeInfo("createEmbeddedString", "(Ljava/lang/String;)Lcom/odi/Field;", "setEmbeddedStringField", "(ILjava/lang/String;Lcom/odi/ClassInfo;)V", 14, "getEmbeddedStringField", "(ILcom/odi/ClassInfo;)Ljava/lang/String;", 14);
    private static FieldTypeInfo byteArrayInfo = new FieldTypeInfo("createByteArray", "(Ljava/lang/String;I)Lcom/odi/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getArrayField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo charArrayInfo = new FieldTypeInfo("createCharArray", "(Ljava/lang/String;I)Lcom/odi/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getArrayField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo shortArrayInfo = new FieldTypeInfo("createShortArray", "(Ljava/lang/String;I)Lcom/odi/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getArrayField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo intArrayInfo = new FieldTypeInfo("createIntArray", "(Ljava/lang/String;I)Lcom/odi/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getArrayField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo longArrayInfo = new FieldTypeInfo("createLongArray", "(Ljava/lang/String;I)Lcom/odi/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getArrayField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo floatArrayInfo = new FieldTypeInfo("createFloatArray", "(Ljava/lang/String;I)Lcom/odi/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getArrayField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo doubleArrayInfo = new FieldTypeInfo("createDoubleArray", "(Ljava/lang/String;I)Lcom/odi/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getArrayField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo booleanArrayInfo = new FieldTypeInfo("createBooleanArray", "(Ljava/lang/String;I)Lcom/odi/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getArrayField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo classArrayInfo = new FieldTypeInfo("createClassArray", "(Ljava/lang/String;Ljava/lang/String;I)Lcom/odi/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getArrayField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo interfaceArrayInfo = new FieldTypeInfo("createInterfaceArray", "(Ljava/lang/String;Ljava/lang/String;I)Lcom/odi/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getArrayField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo stringArrayInfo = new FieldTypeInfo("createStringArray", "(Ljava/lang/String;I)Lcom/odi/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/odi/ClassInfo;)V", 12, "getArrayField", "(ILcom/odi/ClassInfo;)Ljava/lang/Object;", 12);

    private FieldTypeInfo(String createName, String createSig, String setName, String setSig, int argType, String getName, String getSig, int returnType) {
        this.fieldCreateMethod = createName;
        this.fieldCreateMethodSig = createSig;
        this.fieldGetMethod = getName;
        this.fieldGetMethodSig = getSig;
        this.fieldGetReturnType = returnType;
        this.fieldSetMethod = setName;
        this.fieldSetMethodSig = setSig;
        this.fieldSetArgType = argType;
    }

    static FieldTypeInfo determineFieldType(String sig, FilterEnv env) {
        switch (sig.charAt(0)) {
            case 'B': {
                return byteInfo;
            }
            case 'C': {
                return charInfo;
            }
            case 'D': {
                return doubleInfo;
            }
            case 'F': {
                return floatInfo;
            }
            case 'I': {
                return intInfo;
            }
            case 'J': {
                return longInfo;
            }
            case 'S': {
                return shortInfo;
            }
            case 'Z': {
                return booleanInfo;
            }
            case 'L': {
                if (sig.equals("Ljava/lang/String;")) {
                    return stringInfo;
                }
                ClassControl cc = env.findClass(sig.substring(1, sig.length() - 1));
                if (cc != null && cc.classFile().isInterface()) {
                    return interfaceInfo;
                }
                return classInfo;
            }
            case '[': {
                int baseTypeIndex = FieldTypeInfo.findArrayBaseType(sig);
                switch (sig.charAt(baseTypeIndex)) {
                    case 'B': {
                        return byteArrayInfo;
                    }
                    case 'C': {
                        return charArrayInfo;
                    }
                    case 'D': {
                        return doubleArrayInfo;
                    }
                    case 'F': {
                        return floatArrayInfo;
                    }
                    case 'I': {
                        return intArrayInfo;
                    }
                    case 'J': {
                        return longArrayInfo;
                    }
                    case 'S': {
                        return shortArrayInfo;
                    }
                    case 'Z': {
                        return booleanArrayInfo;
                    }
                    case 'L': {
                        if (sig.substring(baseTypeIndex).equals("Ljava/lang/String;")) {
                            return stringArrayInfo;
                        }
                        ClassControl cc = env.findClass(sig.substring(baseTypeIndex + 1, sig.length() - 1));
                        if (cc != null && cc.classFile().isInterface()) {
                            return interfaceArrayInfo;
                        }
                        return classArrayInfo;
                    }
                }
                throw new FilterError("Missing case");
            }
        }
        throw new FilterError("Missing case");
    }

    private static int findArrayBaseType(String sig) {
        int idx = 0;
        while (sig.charAt(idx) == '[') {
            ++idx;
        }
        return idx;
    }
}

