/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.classfile.Insn;
import com.odi.filter.classfile.InsnTarget;
import com.odi.filter.classfile.InsnTargetOp;

class Loop {
    int loopStart;
    int loopEnd;

    Loop(int lStart, int lEnd) {
        this.loopStart = lStart;
        this.loopEnd = lEnd;
    }

    static Loop checkLoops(Insn code) {
        int loopStart = 999999;
        int loopEnd = 0;
        for (Insn i = code; i != null; i = i.next()) {
            InsnTarget targ;
            if (!(i instanceof InsnTargetOp) || (targ = ((InsnTargetOp)i).target()).offset() >= i.offset()) continue;
            if (targ.offset() < loopStart) {
                loopStart = targ.offset();
            }
            if (i.offset() <= loopEnd) continue;
            loopEnd = i.offset();
        }
        if (loopStart < loopEnd) {
            return new Loop(loopStart, loopEnd);
        }
        return null;
    }

    boolean contains(Insn i) {
        return i.offset() >= this.loopStart && i.offset() <= this.loopEnd;
    }
}

