/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.AnnotationConstants;
import com.odi.filter.AnnotationFragment;
import com.odi.filter.ClassAction;
import com.odi.filter.ClassControl;
import com.odi.filter.FilterEnv;
import com.odi.filter.FilterError;
import com.odi.filter.InsnArgNote;
import com.odi.filter.InsnNote;
import com.odi.filter.InvokeAnnotation;
import com.odi.filter.Loop;
import com.odi.filter.StackState;
import com.odi.filter.classfile.ClassMethod;
import com.odi.filter.classfile.CodeAttribute;
import com.odi.filter.classfile.ConstBasic;
import com.odi.filter.classfile.ConstBasicMemberRef;
import com.odi.filter.classfile.ConstClass;
import com.odi.filter.classfile.ConstFieldRef;
import com.odi.filter.classfile.ConstInterfaceMethodRef;
import com.odi.filter.classfile.ConstMethodRef;
import com.odi.filter.classfile.ConstNameAndType;
import com.odi.filter.classfile.ConstantPool;
import com.odi.filter.classfile.Descriptor;
import com.odi.filter.classfile.Insn;
import com.odi.filter.classfile.InsnConstOp;
import com.odi.filter.classfile.InsnInterfaceInvoke;
import com.odi.filter.classfile.InsnTarget;
import com.odi.filter.classfile.InsnUtils;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class MethodAnnotater
implements AnnotationConstants {
    private static final int RETAIN_READONLY = 3;
    private ClassAction classAction;
    private ClassMethod method;
    private ConstantPool pool;
    private int annotate;
    private Vector tmpRegisters;
    private Vector tmpDoubleRegisters;
    private Vector caches;
    private short annotationStack = 0;
    private boolean fetchThis = false;
    private boolean dirtyThis = false;
    private boolean thisEvicted = false;
    private Hashtable insnNotes = new Hashtable(11);
    private Loop largestLoop;

    boolean needsAnnotation() {
        return this.annotate != 0;
    }

    MethodAnnotater(ClassAction caction, ClassMethod meth) {
        this.classAction = caction;
        this.pool = caction.classFile().pool();
        this.method = meth;
    }

    void checkMethod(FilterEnv env) {
        this.annotate = 0;
        CodeAttribute codeAttr = this.method.codeAttribute();
        if (codeAttr != null) {
            if (this.isAnnotated(codeAttr)) {
                env.message("Method " + this.classAction.classControl().userClassName() + "." + this.method.name().asString() + Descriptor.userMethodArgs(this.method.signature().asString()) + " is already annotated.");
            } else if (!this.avoidAnnotation(env)) {
                this.largestLoop = Loop.checkLoops(codeAttr.theCode());
                this.checkCode(codeAttr, env);
            } else if (this.methodIsPersistentFinalize(env)) {
                this.annotate = 8192;
            }
        }
    }

    private boolean methodIsInitializer() {
        String methName = this.method.name().asString();
        return methName.equals("<init>") || methName.equals("readObject") && this.method.signature().asString().equals("(Ljava/io/ObjectInputStream;)V");
    }

    private boolean methodIsFinalize() {
        return this.method.name().asString().equals("finalize") && this.method.signature().asString().equals("()V") && !this.method.isStatic();
    }

    private boolean methodIsPersistentFinalize(FilterEnv env) {
        return this.methodIsFinalize() && this.classAction.classControl().persistCapable(env);
    }

    private boolean avoidAnnotation(FilterEnv env) {
        String methodName = this.method.name().asString();
        String methodSig = this.method.signature().asString();
        if (methodName.equals("<clinit>") || this.methodIsFinalize()) {
            return true;
        }
        return this.classAction.classControl().persistCapable(env) && (methodName.equals("initializeContents") && methodSig.equals("(Lcom/odi/GenericObject;)V") || methodName.equals("flushContents") && methodSig.equals("(Lcom/odi/GenericObject;)V") || methodName.equals("clearContents") && methodSig.equals("()V") || methodName.equals("postInitializeContents") && methodSig.equals("()V") || methodName.equals("preFlushContents") && methodSig.equals("()V") || methodName.equals("preClearContents") && methodSig.equals("()V") || methodName.equals("ODIgetRef") && methodSig.equals("()Lcom/odi/imp/ObjectReference;") || methodName.equals("ODIsetRef") && methodSig.equals("(Lcom/odi/imp/ObjectReference;)V") || methodName.equals("ODIgetState") && methodSig.equals("()B") || methodName.equals("ODIsetState") && methodSig.equals("(B)V"));
    }

    void checkCode(CodeAttribute codeAttr, FilterEnv env) {
        Insn firstInsn;
        for (Insn markInsn = firstInsn = codeAttr.theCode(); markInsn != null; markInsn = markInsn.next()) {
            markInsn.markTargets();
        }
        int allFlags = 0;
        boolean branchesSeen = false;
        for (Insn insn = firstInsn; insn != null; insn = insn.next()) {
            InsnNote noteList = null;
            switch (insn.opcode()) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    noteList = this.noteInvokeAnnotation(insn, env);
                    break;
                }
                case 180: {
                    noteList = this.noteGetFieldAnnotation(insn, env);
                    break;
                }
                case 181: {
                    noteList = this.notePutFieldAnnotation(insn, env);
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    noteList = this.noteArrayLoadAnnotation(insn, env);
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    noteList = this.noteArrayStoreAnnotation(insn, env);
                    break;
                }
            }
            if (noteList != null) {
                this.addNoteList(noteList);
                for (InsnNote aNote = noteList; aNote != null; aNote = aNote.next()) {
                    if (!branchesSeen) {
                        aNote.insnFlags |= 0x100;
                    }
                    if (this.largestLoop != null && this.largestLoop.contains(insn)) {
                        aNote.insnFlags |= 0x200;
                    }
                    if (aNote.evictThis() || aNote.evictPersistent()) {
                        this.thisEvicted = true;
                    }
                    if (aNote.dirtyThis() && aNote.unconditional()) {
                        this.dirtyThis = true;
                    } else if (aNote.dirtyThis() || aNote.fetchThis()) {
                        this.fetchThis = true;
                    }
                    allFlags |= aNote.insnFlags;
                }
            }
            if (!insn.branches()) continue;
            branchesSeen = true;
        }
        String methodName = this.method.name().asString();
        String methodSig = this.method.signature().asString();
        if (this.methodIsInitializer()) {
            if (env.doInitializerOptimization()) {
                this.fetchThis = true;
                this.dirtyThis = true;
            } else {
                this.fetchThis = false;
                this.dirtyThis = false;
            }
            if (this.classAction.getNeedsHashCode()) {
                allFlags |= 0x4000;
            }
        }
        if (methodName.equals("clone") && methodSig.equals("()Ljava/lang/Object;") && this.classAction.classControl().persistCapable(env)) {
            allFlags |= 1;
            this.fetchThis = true;
        }
        this.annotate = allFlags;
    }

    private InsnNote noteInvokeAnnotation(Insn insn, FilterEnv env) {
        boolean flags = false;
        ConstBasicMemberRef methRef = (ConstBasicMemberRef)((InsnConstOp)insn).value();
        InsnNote noteList = null;
        for (InvokeAnnotation invAnn = InvokeAnnotation.checkInvoke(methRef, env); invAnn != null; invAnn = invAnn.next()) {
            int thisFlags = 0;
            Insn dep = this.findArgDepositer(insn, invAnn.whichArg());
            thisFlags = dep != null && dep.opcode() == 42 && !this.method.isStatic() ? ((invAnn.annotateHow() & 0xAA) != 0 ? 2 : 1) : invAnn.annotateHow();
            InsnArgNote newNote = new InsnArgNote(insn, thisFlags, invAnn.whichArg(), Descriptor.extractArgSig(methRef.nameAndType().signature().asString()));
            if (noteList == null || noteList.arg() < newNote.arg()) {
                newNote.nextNote = noteList;
                noteList = newNote;
                continue;
            }
            InsnNote aNote = noteList;
            while (((InsnArgNote)aNote).nextNote != null && ((InsnArgNote)aNote).nextNote.arg() > newNote.arg()) {
                aNote = ((InsnArgNote)aNote).nextNote;
            }
            newNote.nextNote = ((InsnArgNote)aNote).nextNote;
            ((InsnArgNote)aNote).nextNote = newNote;
        }
        return noteList;
    }

    private InsnNote noteGetFieldAnnotation(Insn insn, FilterEnv env) {
        InsnConstOp getFieldInsn = (InsnConstOp)insn;
        ConstFieldRef fieldRef = (ConstFieldRef)getFieldInsn.value();
        String fieldOf = fieldRef.className().asString();
        ClassControl cc = env.findClass(fieldOf);
        if (cc != null && cc.persistCapable(env) && !env.isNoAnnotateField(cc, fieldRef.nameAndType().name().asString())) {
            int flags = 0;
            Insn dep = this.findArgDepositer(insn, 0);
            flags = dep != null && dep.opcode() == 42 && !this.method.isStatic() ? (flags |= 1) : (flags |= 0x10);
            return new InsnNote(insn, flags, 0, "", cc.action());
        }
        return null;
    }

    private InsnNote notePutFieldAnnotation(Insn insn, FilterEnv env) {
        InsnConstOp putFieldInsn = (InsnConstOp)insn;
        ConstFieldRef fieldRef = (ConstFieldRef)putFieldInsn.value();
        String fieldOf = fieldRef.className().asString();
        ClassControl cc = env.findClass(fieldOf);
        String fieldName = fieldRef.nameAndType().name().asString();
        if (cc != null && cc.persistCapable(env) && !env.isNoAnnotateField(cc, fieldName)) {
            boolean modifiesThis;
            int flags = 0;
            String fieldSig = fieldRef.nameAndType().signature().asString();
            int fieldSize = fieldSig.equals("J") || fieldSig.equals("D") ? 2 : 1;
            Insn dep = this.findArgDepositer(insn, fieldSize);
            boolean bl = modifiesThis = dep != null && !this.method.isStatic() && dep.opcode() == 42;
            flags = modifiesThis ? (flags |= 2) : (flags |= 0x20);
            if (env.isFieldIndexable(fieldOf, fieldName)) {
                flags = modifiesThis ? (flags |= 0x1000) : (flags |= 0x800);
            }
            return new InsnNote(insn, flags, fieldSize, fieldSig, cc.action());
        }
        return null;
    }

    private InsnNote noteArrayLoadAnnotation(Insn insn, FilterEnv env) {
        int arrayFetchType = 0;
        switch (insn.opcode()) {
            case 50: {
                arrayFetchType = 0x48000000;
                break;
            }
            case 52: {
                arrayFetchType = 0x18000000;
                break;
            }
            case 53: {
                arrayFetchType = 0x20000000;
                break;
            }
            case 46: {
                arrayFetchType = 0x28000000;
                break;
            }
            case 47: {
                arrayFetchType = 0x30000000;
                break;
            }
            case 48: {
                arrayFetchType = 0x38000000;
                break;
            }
            case 49: {
                arrayFetchType = 0x40000000;
                break;
            }
        }
        return new InsnNote(insn, 0x40 | arrayFetchType, 1, "I", null);
    }

    private InsnNote noteArrayStoreAnnotation(Insn insn, FilterEnv env) {
        int valueType = Insn.loadStoreDataType(insn.opcode());
        int valueSize = Descriptor.elementSize(valueType);
        String stackSig = "I" + Descriptor.elementSig(valueType);
        int arrayStoreType = 0;
        switch (insn.opcode()) {
            case 83: {
                arrayStoreType = 0x48000000;
                break;
            }
            case 85: {
                arrayStoreType = 0x18000000;
                break;
            }
            case 86: {
                arrayStoreType = 0x20000000;
                break;
            }
            case 79: {
                arrayStoreType = 0x28000000;
                break;
            }
            case 80: {
                arrayStoreType = 0x30000000;
                break;
            }
            case 81: {
                arrayStoreType = 0x38000000;
                break;
            }
            case 82: {
                arrayStoreType = 0x40000000;
                break;
            }
        }
        return new InsnNote(insn, 0x80 | arrayStoreType, valueSize + 1, stackSig, null);
    }

    private void clearThisAnnotation(FilterEnv env) {
        if (!env.doThisOptimization() && !this.methodIsInitializer()) {
            this.dirtyThis = false;
            this.fetchThis = false;
        }
        if (this.thisEvicted && !this.methodIsInitializer()) {
            this.dirtyThis = false;
        }
        if (!this.dirtyThis && !this.fetchThis) {
            return;
        }
        CodeAttribute codeAttr = this.method.codeAttribute();
        if (codeAttr != null) {
            for (Insn insn = codeAttr.theCode(); insn != null; insn = insn.next()) {
                for (InsnNote noteList = this.getNoteList(insn); noteList != null; noteList = noteList.next()) {
                    if (this.dirtyThis && noteList.dirtyThis()) {
                        noteList.dontDirtyThis();
                    }
                    if ((this.dirtyThis || this.fetchThis) && noteList.fetchThis()) {
                        noteList.dontFetchThis();
                    }
                    if (!noteList.evictThis() || !this.methodIsInitializer() || !env.doInitializerOptimization()) continue;
                    noteList.dontEvictThis();
                }
            }
        }
        if (this.methodIsInitializer()) {
            this.dirtyThis = false;
            this.fetchThis = false;
        }
    }

    private void removeRedundantThisAnnotation(FilterEnv env) {
        if (this.method.isStatic() || this.methodIsInitializer() && env.doInitializerOptimization()) {
            return;
        }
        CodeAttribute codeAttr = this.method.codeAttribute();
        if (codeAttr != null && this.needsAnnotation()) {
            Insn firstInsn = codeAttr.theCode();
            boolean thisFetched = false;
            boolean thisDirtied = false;
            for (Insn insn = firstInsn.next(); insn != null; insn = insn.next()) {
                for (InsnNote noteList = this.getNoteList(insn); noteList != null; noteList = noteList.next()) {
                    if (noteList.fetchThis()) {
                        if (thisFetched) {
                            noteList.dontFetchThis();
                        } else {
                            thisFetched = true;
                        }
                    }
                    if (noteList.dirtyThis()) {
                        if (thisDirtied) {
                            noteList.dontDirtyThis();
                        } else {
                            thisDirtied = true;
                            thisFetched = true;
                        }
                    }
                    if (!noteList.evictThis()) continue;
                    thisDirtied = false;
                }
                boolean invalidate = false;
                switch (insn.opcode()) {
                    case 168: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        invalidate = true;
                        break;
                    }
                    case 194: {
                        invalidate = true;
                        break;
                    }
                    case -1: {
                        if (!((InsnTarget)insn).isBranchTarget()) break;
                        invalidate = true;
                        break;
                    }
                }
                if (!invalidate) continue;
                thisFetched = false;
                thisDirtied = false;
            }
        }
    }

    void annotateMethod(FilterEnv env) {
        CodeAttribute codeAttr = this.method.codeAttribute();
        if (codeAttr != null && this.needsAnnotation()) {
            Insn insn;
            if ((this.annotate & 0x2000) != 0) {
                this.makeThisTransient(env, codeAttr);
                if (this.annotate == 8192) {
                    return;
                }
            }
            this.clearThisAnnotation(env);
            this.removeRedundantThisAnnotation(env);
            Insn firstInsn = codeAttr.theCode();
            block3: for (insn = firstInsn.next(); insn != null; insn = insn.next()) {
                switch (insn.opcode()) {
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        insn = this.insnAnnotation(insn, env);
                        continue block3;
                    }
                }
            }
            String methodName = this.method.name().asString();
            String methodSig = this.method.signature().asString();
            String superName = this.classAction.classFile().superName().asString();
            if (this.methodIsInitializer()) {
                if (methodName.equals("<init>") && this.classAction.getNeedsHashCode()) {
                    for (insn = codeAttr.theCode(); insn != null; insn = insn.next()) {
                        InsnConstOp invoke;
                        ConstMethodRef methRef;
                        if (insn.opcode() != 183 || !(methRef = (ConstMethodRef)(invoke = (InsnConstOp)insn).value()).className().asString().equals(superName)) continue;
                        Insn newInsn = Insn.create(42);
                        Insn nextInsn = newInsn.append(Insn.create(184, this.pool.addMethodRef("com/odi/util/HashPersistent", "getNextHashCode", "()I")));
                        nextInsn.append(Insn.create(181, this.pool.addFieldRef(this.classAction.classControl().className(), this.classAction.getHashCodeMember(), "I")));
                        insn.insert(newInsn);
                        this.noteStack(2);
                        break;
                    }
                }
            } else {
                if (this.fetchThis || this.dirtyThis) {
                    Insn newInsn;
                    Insn annotationStart = newInsn = Insn.create(42);
                    InsnTarget afterCondition = null;
                    if (this.classAction.getObjectStateMemberValid() && this.classAction.getObjectStateMember() != null) {
                        ClassControl stateCC = this.classAction.getObjectStateMemberClassControl(env);
                        newInsn = newInsn.append(Insn.create(180, this.pool.addFieldRef(stateCC.className(), this.classAction.getObjectStateMember(), "B")));
                        afterCondition = new InsnTarget();
                        if (this.dirtyThis) {
                            newInsn = newInsn.append(Insn.create(5));
                            newInsn = newInsn.append(Insn.create(126));
                            newInsn = newInsn.append(Insn.create(153, afterCondition));
                            newInsn = newInsn.append(Insn.create(42));
                        } else {
                            newInsn = newInsn.append(Insn.create(156, afterCondition));
                            newInsn = newInsn.append(Insn.create(42));
                        }
                    }
                    newInsn = newInsn.append(Insn.create(184, this.pool.addMethodRef("com/odi/ObjectStore", this.dirtyThis ? "dirty" : "fetch", "(Lcom/odi/IPersistent;)V")));
                    if (afterCondition != null) {
                        newInsn = newInsn.append(afterCondition);
                    }
                    firstInsn.insert(annotationStart);
                    this.noteStack(2);
                }
                if (methodName.equals("clone") && methodSig.equals("()Ljava/lang/Object;") && !this.classAction.getNeedsClone()) {
                    this.annotateClone(env, codeAttr, superName);
                }
            }
            if (this.caches != null && !this.caches.isEmpty()) {
                Insn initInsn = null;
                for (int i = 0; i < this.caches.size(); ++i) {
                    int slot = (Integer)this.caches.elementAt(i);
                    Insn nullInsn = Insn.create(1);
                    if (initInsn == null) {
                        initInsn = nullInsn;
                    } else {
                        initInsn.append(nullInsn);
                    }
                    initInsn.append(InsnUtils.aStore(slot, this.pool));
                }
                InsnTarget newFirstInsn = new InsnTarget();
                initInsn.append(firstInsn);
                newFirstInsn.append(initInsn);
                firstInsn = newFirstInsn;
                codeAttr.setTheCode(firstInsn);
            }
            if (this.annotationStack > 0) {
                codeAttr.setStackUsed(codeAttr.stackUsed() + this.annotationStack);
            }
        }
    }

    private void annotateClone(FilterEnv env, CodeAttribute codeAttr, String superName) {
        for (Insn insn = codeAttr.theCode(); insn != null; insn = insn.next()) {
            Insn newInsn;
            InsnConstOp invoke;
            ConstMethodRef methRef;
            String methName;
            if (insn.opcode() != 183 || !(methName = (methRef = (ConstMethodRef)(invoke = (InsnConstOp)insn).value()).nameAndType().name().asString()).equals("clone")) continue;
            String thisClass = this.classAction.classControl().className();
            ClassControl cc = env.findClass(superName).findMethodClass(env, "clone", "()Ljava/lang/Object;");
            if (cc != null && !cc.className().equals(methRef.className().asString())) {
                env.message("Changing " + thisClass + ".clone() to call " + cc.className() + ".clone() instead of " + methRef.className().asString() + ".clone()");
                ConstMethodRef newMethRef = this.pool.addMethodRef(cc.className(), "clone", "()Ljava/lang/Object;");
                invoke.setValue(newMethRef);
            }
            boolean needCheckcast = false;
            Insn checkCastInsn = insn.next();
            if (checkCastInsn.opcode() != 192) {
                needCheckcast = true;
            } else {
                ConstClass target = (ConstClass)((InsnConstOp)checkCastInsn).value();
                ClassControl targetCC = env.findClass(target.asString());
                if (targetCC != null && !targetCC.inherits(thisClass, env)) {
                    needCheckcast = true;
                } else {
                    insn = checkCastInsn;
                }
            }
            boolean checkStack = false;
            if (this.classAction.getNeedsODIRefMethods()) {
                newInsn = Insn.create(89);
                if (needCheckcast) {
                    newInsn.append(Insn.create(192, this.pool.addClass(thisClass)));
                }
                newInsn.append(Insn.create(1));
                newInsn.append(Insn.create(181, this.pool.addFieldRef(thisClass, this.classAction.getRefMember(), "Lcom/odi/imp/ObjectReference;")));
                insn.insert(newInsn);
                checkStack = true;
            }
            if (this.classAction.getNeedsODIStateMethods()) {
                newInsn = Insn.create(89);
                if (needCheckcast) {
                    newInsn.append(Insn.create(192, this.pool.addClass(thisClass)));
                }
                newInsn.append(Insn.create(3));
                newInsn.append(Insn.create(181, this.pool.addFieldRef(thisClass, this.classAction.getObjectStateMember(), "B")));
                insn.insert(newInsn);
                checkStack = true;
            }
            if (!checkStack) continue;
            this.noteStack(2);
        }
    }

    private void makeThisTransient(FilterEnv env, CodeAttribute codeAttr) {
        Insn insn = codeAttr.theCode();
        while (insn.opcode() == -1) {
            insn = insn.next();
        }
        Insn annotation = Insn.create(42);
        annotation.append(Insn.create(1));
        ConstInterfaceMethodRef methRef = this.pool.addInterfaceMethodRef("com/odi/IPersistent", "ODIsetRef", "(Lcom/odi/imp/ObjectReference;)V");
        annotation.append(new InsnInterfaceInvoke(methRef, 2));
        annotation.append(Insn.create(42));
        annotation.append(Insn.create(3));
        methRef = this.pool.addInterfaceMethodRef("com/odi/IPersistent", "ODIsetState", "(B)V");
        annotation.append(new InsnInterfaceInvoke(methRef, 2));
        insn.prev().insert(annotation);
        if (codeAttr.stackUsed() < 2) {
            codeAttr.setStackUsed(2);
        }
    }

    private Insn insnAnnotation(Insn insn, FilterEnv env) {
        int initialSingleRegs = 0;
        for (InsnNote noteList = this.getNoteList(insn); noteList != null; noteList = noteList.next()) {
            AnnotationFragment frag;
            if (noteList.evictPersistent()) {
                noteList.setArgReg(this.tmpReg(initialSingleRegs++));
            }
            if ((frag = this.buildBasicAnnotation(noteList, env)) != null) {
                StackState state = new StackState(noteList.arg(), noteList.sig(), insn.prev());
                this.minimizeStack(state);
                Insn annotation = null;
                if (state.argDepth == 0) {
                    annotation = frag.annotation;
                    this.noteStack(frag.stackRequired);
                } else if (state.argDepth == 1) {
                    annotation = Insn.create(95);
                    annotation.append(frag.annotation);
                    annotation.append(Insn.create(95));
                    this.noteStack(frag.stackRequired - (noteList.arg() - 1));
                } else {
                    int elemSize;
                    int depth;
                    Stack stackTypes = state.stackTypes;
                    int elem = stackTypes.size() - 1;
                    int singleRegs = initialSingleRegs;
                    int doubleRegs = 0;
                    int[] regnums = new int[depth];
                    int regtotal = 0;
                    for (depth = state.argDepth; depth > 0; depth -= elemSize) {
                        int elemType = (Integer)stackTypes.elementAt(elem--);
                        elemSize = Descriptor.elementSize(elemType);
                        int reg = elemSize == 1 ? this.tmpReg(singleRegs++) : this.tmpReg2(doubleRegs++);
                        regnums[regtotal++] = reg;
                        Insn store = InsnUtils.store(elemType, reg, this.pool);
                        if (annotation == null) {
                            annotation = store;
                            continue;
                        }
                        annotation.append(store);
                    }
                    if (depth < 0) {
                        throw new FilterError("Stack underflow while computing save registers");
                    }
                    annotation.append(frag.annotation);
                    while (regtotal > 0) {
                        annotation.append(InsnUtils.load((Integer)stackTypes.elementAt(++elem), regnums[--regtotal], this.pool));
                    }
                    this.noteStack(frag.stackRequired - noteList.arg());
                }
                state.insn.insert(annotation);
            }
            if (!noteList.evictThis() && !noteList.evictPersistent()) continue;
            Insn evictLoad = null;
            evictLoad = noteList.evictThis() ? Insn.create(42) : InsnUtils.aLoad(noteList.getArgReg(), this.pool);
            frag = this.buildEvictAnnotation(noteList, env);
            if (frag == null) continue;
            this.noteStack(frag.stackRequired + 1);
            evictLoad.append(frag.annotation);
            insn.insert(evictLoad);
            insn = insn.next();
        }
        return insn;
    }

    private AnnotationFragment buildBasicAnnotation(InsnNote note, FilterEnv env) {
        ClassControl stateCC;
        Object annotation = null;
        int basicStack = 2;
        Insn basicAnnotation = null;
        ConstMethodRef methRef = null;
        InsnTarget afterFetchDirty = null;
        Insn objectStateCheckAnnotation = null;
        ClassAction targetCA = note.targetClassAction();
        Insn regStore = null;
        if (note.getArgReg() >= 0) {
            regStore = Insn.create(89);
            regStore.append(InsnUtils.aStore(note.getArgReg(), this.pool));
        }
        if (note.fetchPersistent() || note.fetchThis() && this.thisIsPersistent(env)) {
            methRef = this.pool.addMethodRef("com/odi/ObjectStore", "fetch", "(Lcom/odi/IPersistent;)V");
            if (targetCA != null) {
                targetCA.ensureObjectStateMemberValid(env);
                if (targetCA.getObjectStateMember() != null) {
                    stateCC = targetCA.getObjectStateMemberClassControl(env);
                    objectStateCheckAnnotation = Insn.create(89);
                    objectStateCheckAnnotation.append(Insn.create(180, this.pool.addFieldRef(stateCC.className(), targetCA.getObjectStateMember(), "B")));
                    afterFetchDirty = new InsnTarget();
                    objectStateCheckAnnotation.append(Insn.create(156, afterFetchDirty));
                }
            }
        } else if (note.dirtyPersistent() || note.dirtyThis() && this.thisIsPersistent(env)) {
            methRef = this.pool.addMethodRef("com/odi/ObjectStore", "dirty", "(Lcom/odi/IPersistent;)V");
            if (targetCA != null) {
                targetCA.ensureObjectStateMemberValid(env);
                if (targetCA.getObjectStateMember() != null) {
                    stateCC = targetCA.getObjectStateMemberClassControl(env);
                    objectStateCheckAnnotation = Insn.create(89);
                    objectStateCheckAnnotation.append(Insn.create(180, this.pool.addFieldRef(stateCC.className(), targetCA.getObjectStateMember(), "B")));
                    afterFetchDirty = new InsnTarget();
                    objectStateCheckAnnotation.append(Insn.create(5));
                    objectStateCheckAnnotation.append(Insn.create(126));
                    objectStateCheckAnnotation.append(Insn.create(153, afterFetchDirty));
                    basicStack = 2;
                }
            }
        } else if (note.fetchArray()) {
            String fetchSig = this.arrayFetchSignature(env.doArrayElementFetch() ? note.arrayElementType() : 0);
            methRef = this.pool.addMethodRef("com/odi/ObjectStore", "fetch", fetchSig);
        } else if (note.fetchObject()) {
            methRef = this.pool.addMethodRef("com/odi/ObjectStore", "fetch", "(Ljava/lang/Object;)V");
        } else if (note.dirtyArray() || note.dirtyObject()) {
            methRef = this.pool.addMethodRef("com/odi/ObjectStore", "dirty", "(Ljava/lang/Object;)V");
        }
        if (methRef != null) {
            if (objectStateCheckAnnotation == null) {
                basicAnnotation = Insn.create(89);
                basicAnnotation.append(Insn.create(184, methRef));
            } else {
                basicAnnotation = objectStateCheckAnnotation;
                basicAnnotation.append(Insn.create(89));
                basicAnnotation.append(Insn.create(184, methRef));
                basicAnnotation.append(afterFetchDirty);
            }
            boolean cacheResult = false;
            if (env.doArrayOptimization() && (note.fetchArray() || note.dirtyArray()) && note.inLoop()) {
                cacheResult = true;
            }
            if (cacheResult || note.checkNull()) {
                int cacheSlot = 0;
                InsnTarget skipTo = new InsnTarget();
                if (cacheResult) {
                    cacheSlot = this.newCacheSlot();
                }
                Insn skipAnnotation = Insn.create(89);
                if (note.checkNull()) {
                    skipAnnotation.append(Insn.create(198, skipTo));
                    if (cacheResult) {
                        skipAnnotation.append(Insn.create(89));
                    }
                }
                if (cacheResult) {
                    skipAnnotation.append(InsnUtils.aLoad(cacheSlot, this.pool));
                    skipAnnotation.append(Insn.create(165, skipTo));
                }
                skipAnnotation.append(basicAnnotation);
                if (cacheResult) {
                    skipAnnotation.append(Insn.create(89));
                    skipAnnotation.append(InsnUtils.aStore(cacheSlot, this.pool));
                }
                if (basicStack < 2) {
                    basicStack = 2;
                }
                skipAnnotation.append(skipTo);
                basicAnnotation = skipAnnotation;
            }
        }
        if (regStore != null) {
            regStore.append(basicAnnotation);
            basicAnnotation = regStore;
        }
        if (basicAnnotation != null) {
            return new AnnotationFragment(basicAnnotation, basicStack);
        }
        return null;
    }

    String arrayFetchSignature(int arrayElementType) {
        switch (arrayElementType) {
            case 0x8000000: {
                return "([Z)V";
            }
            case 0x10000000: {
                return "([B)V";
            }
            case 0x18000000: {
                return "([C)V";
            }
            case 0x20000000: {
                return "([S)V";
            }
            case 0x28000000: {
                return "([I)V";
            }
            case 0x30000000: {
                return "([J)V";
            }
            case 0x38000000: {
                return "([F)V";
            }
            case 0x40000000: {
                return "([D)V";
            }
            case 0x48000000: {
                return "([Ljava/lang/Object;)V";
            }
        }
        return "(Ljava/lang/Object;)V";
    }

    private AnnotationFragment buildEvictAnnotation(InsnNote note, FilterEnv env) {
        Insn annotation = null;
        int stack = 1;
        if (!(note.evictPersistent() || note.evictThis() && this.thisIsPersistent(env))) {
            throw new FilterError("Invalid call to buildEvictAnnotation");
        }
        ConstMethodRef methRef = this.pool.addMethodRef("com/odi/ObjectStore", "evict", "(Ljava/lang/Object;I)V");
        annotation = InsnUtils.integerConstant(3, this.pool);
        annotation.append(Insn.create(184, methRef));
        return new AnnotationFragment(annotation, stack);
    }

    private boolean isAnnotated(CodeAttribute codeAttr) {
        for (Insn insn = codeAttr.theCode(); insn != null; insn = insn.next()) {
            ConstNameAndType nt;
            String ntName;
            ConstMethodRef methRef;
            InsnConstOp coInsn;
            ConstBasic operand;
            if (!(insn instanceof InsnConstOp) || !((operand = (coInsn = (InsnConstOp)insn).value()) instanceof ConstMethodRef) || !(methRef = (ConstMethodRef)operand).className().asString().equals("com/odi/Persistent") && !methRef.className().asString().equals("com/odi/ObjectStore") || !(ntName = (nt = methRef.nameAndType()).name().asString()).equals("fetch") && !ntName.equals("dirty")) continue;
            return true;
        }
        return false;
    }

    private int tmpReg2(int idx) {
        if (this.tmpDoubleRegisters == null) {
            this.tmpDoubleRegisters = new Vector(3);
        }
        while (this.tmpDoubleRegisters.size() <= idx) {
            CodeAttribute codeAttr = this.method.codeAttribute();
            int reg = codeAttr.localsUsed();
            this.tmpDoubleRegisters.addElement(new Integer(reg));
            codeAttr.setLocalsUsed(reg + 2);
        }
        return (Integer)this.tmpDoubleRegisters.elementAt(idx);
    }

    private int tmpReg(int idx) {
        if (this.tmpRegisters == null) {
            this.tmpRegisters = new Vector(3);
        }
        while (this.tmpRegisters.size() <= idx) {
            CodeAttribute codeAttr = this.method.codeAttribute();
            int reg = codeAttr.localsUsed();
            this.tmpRegisters.addElement(new Integer(reg));
            codeAttr.setLocalsUsed(reg + 1);
        }
        return (Integer)this.tmpRegisters.elementAt(idx);
    }

    private int newCacheSlot() {
        CodeAttribute codeAttr = this.method.codeAttribute();
        int slot = codeAttr.localsUsed();
        codeAttr.setLocalsUsed(slot + 1);
        if (this.caches == null) {
            this.caches = new Vector(3);
        }
        this.caches.addElement(new Integer(slot));
        return slot;
    }

    private void noteStack(int stk) {
        if (stk > this.annotationStack) {
            this.annotationStack = (short)stk;
        }
    }

    private boolean thisIsPersistent(FilterEnv env) {
        return this.classAction.classControl().persistCapable(env) && !this.method.isStatic();
    }

    private Insn findArgDepositer(Insn currInsn, int argDepth) {
        Insn depositer = null;
        Insn i = currInsn.prev();
        while (!(argDepth < 0 || i.branches() || i instanceof InsnTarget && ((InsnTarget)i).isBranchTarget())) {
            int nArgs = i.nStackArgs();
            int nResults = i.nStackResults();
            if (argDepth - nResults < 0) {
                if (nResults > 1 && i.opcode() != 89) break;
                depositer = i;
                switch (i.opcode()) {
                    case 89: {
                        if (argDepth != 0) break;
                        ++argDepth;
                        break;
                    }
                    case 192: {
                        break;
                    }
                    default: {
                        return i;
                    }
                }
            }
            argDepth += nArgs - nResults;
            i = i.prev();
        }
        return depositer;
    }

    private void minimizeStack(StackState state) {
        Insn i = state.insn;
        int argDepth = state.argDepth;
        Stack argTypesStack = new Stack();
        Stack resultTypesStack = new Stack();
        Stack stackTypes = new Stack();
        this.copyStack(state.stackTypes, stackTypes);
        while (!(argDepth <= 0 || i.branches() || i instanceof InsnTarget && ((InsnTarget)i).isBranchTarget())) {
            int nArgs = i.nStackArgs();
            int nResults = i.nStackResults();
            String argTypes = i.argTypes();
            String resultTypes = i.resultTypes();
            if ((argDepth -= nResults) < 0) break;
            argDepth += nArgs;
            if (i.opcode() == 95) {
                Object x = stackTypes.pop();
                Object y = stackTypes.pop();
                stackTypes.push(x);
                stackTypes.push(y);
            } else {
                while (!argTypesStack.empty()) {
                    argTypesStack.pop();
                }
                while (!resultTypesStack.empty()) {
                    resultTypesStack.pop();
                }
                Descriptor.computeStackTypes(argTypes, argTypesStack);
                Descriptor.computeStackTypes(resultTypes, resultTypesStack);
                int expectWords = 0;
                while (!resultTypesStack.empty()) {
                    expectWords += Descriptor.elementSize((Integer)resultTypesStack.pop());
                }
                while (expectWords > 0) {
                    expectWords -= Descriptor.elementSize((Integer)stackTypes.pop());
                }
                if (expectWords < 0) {
                    return;
                }
                this.transferStackArgs(argTypesStack, stackTypes);
            }
            if (argDepth >= 0 && argDepth < state.argDepth && this.knownTypes(stackTypes, argDepth)) {
                state.argDepth = argDepth;
                state.insn = i.prev();
                this.copyStack(stackTypes, state.stackTypes);
            }
            i = i.prev();
        }
    }

    private final void transferStackArgs(Stack fromStack, Stack toStack) {
        if (!fromStack.empty()) {
            Object o = fromStack.pop();
            this.transferStackArgs(fromStack, toStack);
            toStack.push(o);
        }
    }

    private final void copyStack(Stack fromStack, Stack toStack) {
        while (!toStack.empty()) {
            toStack.pop();
        }
        for (int i = 0; i < fromStack.size(); ++i) {
            toStack.addElement(fromStack.elementAt(i));
        }
    }

    private final boolean knownTypes(Stack stack, int nWords) {
        int words;
        for (int i = stack.size() - 1; i >= 0 && nWords > 0; nWords -= words, --i) {
            words = 0;
            switch ((Integer)stack.elementAt(i)) {
                case 15: 
                case 16: 
                case 17: {
                    return false;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    words = 1;
                }
                case 7: 
                case 11: {
                    words = 2;
                }
            }
        }
        return true;
    }

    private void addNoteList(InsnNote noteList) {
        this.insnNotes.put(noteList.insn, noteList);
    }

    private InsnNote getNoteList(Insn insn) {
        return (InsnNote)this.insnNotes.get(insn);
    }
}

