/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.ClassAction;
import com.odi.filter.FieldAction;
import com.odi.filter.FieldNote;
import com.odi.filter.FilterEnv;
import com.odi.filter.FilterError;
import com.odi.filter.classfile.AttributeVector;
import com.odi.filter.classfile.ClassField;
import com.odi.filter.classfile.ClassFile;
import com.odi.filter.classfile.ClassMethod;
import com.odi.filter.classfile.CodeAttribute;
import com.odi.filter.classfile.ConstClass;
import com.odi.filter.classfile.ConstantPool;
import com.odi.filter.classfile.ExceptionRange;
import com.odi.filter.classfile.ExceptionTable;
import com.odi.filter.classfile.ExceptionsAttribute;
import com.odi.filter.classfile.Insn;
import com.odi.filter.classfile.InsnTarget;
import com.odi.filter.classfile.InsnUtils;
import com.odi.filter.classfile.VMConstants;
import java.util.Enumeration;
import java.util.Vector;

class MethodBuilder
implements VMConstants {
    MethodBuilder() {
    }

    static ClassMethod makeGetClassInfoInstance(ClassAction ca, FilterEnv env) {
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod getClassInfoInstanceMethod = new ClassMethod(26, pool.addUtf8("getClassInfoInstance"), pool.addUtf8("()Lcom/odi/ClassInfo;"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(18, pool.addString(ca.className().replace('/', '.'))));
        insn = insn.append(Insn.create(184, pool.addMethodRef("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;")));
        insn = insn.append(Insn.create(184, pool.addMethodRef("com/odi/ClassInfo", "get", "(Ljava/lang/Class;)Lcom/odi/ClassInfo;")));
        InsnTarget endPC = new InsnTarget();
        endPC.append(Insn.create(176));
        insn = insn.append(endPC);
        InsnTarget handlerPC = new InsnTarget();
        handlerPC.append(Insn.create(75));
        insn = insn.append(handlerPC);
        insn = insn.append(Insn.create(1));
        insn = insn.append(Insn.create(176));
        ExceptionTable exceptionTable = new ExceptionTable();
        ConstClass catchType = pool.addClass("java/lang/ClassNotFoundException");
        ExceptionRange range = new ExceptionRange(firstInsn, handlerPC, handlerPC, catchType);
        exceptionTable.addElement(range);
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 2, 1, firstInsn, exceptionTable, new AttributeVector()));
        return getClassInfoInstanceMethod;
    }

    static ClassMethod makeInitializeContents(ClassAction ca, FilterEnv env) {
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod initializeContentsMethod = new ClassMethod(1, pool.addUtf8("initializeContents"), pool.addUtf8("(Lcom/odi/GenericObject;)V"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(178, pool.addFieldRef(thisClass.asString(), ca.getClassInfoMember(), "Lcom/odi/ClassInfo;")));
        insn = insn.append(Insn.create(77));
        Enumeration e = ca.fieldActions();
        while (e.hasMoreElements()) {
            FieldAction act = (FieldAction)e.nextElement();
            if (!act.isPersistent()) continue;
            int idx = act.index();
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(43));
            insn = insn.append(InsnUtils.integerConstant(idx, pool));
            insn = insn.append(Insn.create(44));
            insn = insn.append(Insn.create(182, pool.addMethodRef("com/odi/GenericObject", act.getMethod(), act.getMethodSig())));
            switch (act.getMethodReturn()) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: {
                    break;
                }
                case 12: 
                case 13: {
                    if (act.typeDescriptor().equals("Ljava/lang/Object;")) break;
                    ConstClass fieldType = pool.addClass(act.typeName());
                    insn = insn.append(Insn.create(192, fieldType));
                    break;
                }
                default: {
                    throw new FilterError("unexpected return type");
                }
            }
            insn = insn.append(Insn.create(181, pool.addFieldRef(thisClass.asString(), act.fieldName(), act.typeDescriptor())));
        }
        ConstClass superClass = ca.classFile().superName();
        if (!ca.getImplementsPersistence()) {
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(43));
            insn = insn.append(Insn.create(183, pool.addMethodRef(superClass.asString(), "initializeContents", "(Lcom/odi/GenericObject;)V")));
        }
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 4, 3, firstInsn, new ExceptionTable(), new AttributeVector()));
        return initializeContentsMethod;
    }

    static ClassMethod makeFlushContents(ClassAction ca, FilterEnv env) {
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod flushContentsMethod = new ClassMethod(1, pool.addUtf8("flushContents"), pool.addUtf8("(Lcom/odi/GenericObject;)V"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(178, pool.addFieldRef(thisClass.asString(), ca.getClassInfoMember(), "Lcom/odi/ClassInfo;")));
        insn = insn.append(Insn.create(77));
        Enumeration e = ca.fieldActions();
        while (e.hasMoreElements()) {
            FieldAction act = (FieldAction)e.nextElement();
            if (!act.isPersistent()) continue;
            int idx = act.index();
            insn = insn.append(Insn.create(43));
            insn = insn.append(InsnUtils.integerConstant(idx, pool));
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(180, pool.addFieldRef(thisClass.asString(), act.fieldName(), act.typeDescriptor())));
            insn = insn.append(Insn.create(44));
            insn = insn.append(Insn.create(182, pool.addMethodRef("com/odi/GenericObject", act.setMethod(), act.setMethodSig())));
        }
        ConstClass superClass = ca.classFile().superName();
        if (!ca.getImplementsPersistence()) {
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(43));
            insn = insn.append(Insn.create(183, pool.addMethodRef(superClass.asString(), "flushContents", "(Lcom/odi/GenericObject;)V")));
        }
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 6, 3, firstInsn, new ExceptionTable(), new AttributeVector()));
        return flushContentsMethod;
    }

    static ClassMethod makeClearContents(ClassAction ca, FilterEnv env) {
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod clearContentsMethod = new ClassMethod(1, pool.addUtf8("clearContents"), pool.addUtf8("()V"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        Enumeration e = ca.fieldActions();
        while (e.hasMoreElements()) {
            FieldAction act = (FieldAction)e.nextElement();
            if (!act.isPersistent()) continue;
            int idx = act.index();
            insn = insn.append(Insn.create(42));
            switch (act.getMethodReturn()) {
                case 7: {
                    insn = insn.append(Insn.create(14));
                    break;
                }
                case 11: {
                    insn = insn.append(Insn.create(9));
                    break;
                }
                case 6: {
                    insn = insn.append(Insn.create(11));
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    insn = insn.append(Insn.create(3));
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    insn = insn.append(Insn.create(1));
                    break;
                }
                default: {
                    throw new FilterError("unexpected return type");
                }
            }
            insn = insn.append(Insn.create(181, pool.addFieldRef(thisClass.asString(), act.fieldName(), act.typeDescriptor())));
        }
        ConstClass superClass = ca.classFile().superName();
        if (!ca.getImplementsPersistence()) {
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(183, pool.addMethodRef(superClass.asString(), "clearContents", "()V")));
        }
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 3, 1, firstInsn, new ExceptionTable(), new AttributeVector()));
        return clearContentsMethod;
    }

    static ClassMethod makeClassInfoCtor(ClassAction ca, FilterEnv env) {
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod classInfoCtorMethod = new ClassMethod(1, pool.addUtf8("<init>"), pool.addUtf8("(Lcom/odi/ClassInfo;)V"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        ConstClass superClass = ca.classFile().superName();
        boolean doClassInfoSuper = true;
        if (ca.getImplementsPersistence() || superClass.asString().equals("java/lang/Object")) {
            doClassInfoSuper = false;
        }
        insn = insn.append(Insn.create(42));
        if (doClassInfoSuper) {
            insn = insn.append(Insn.create(43));
            insn = insn.append(Insn.create(183, pool.addMethodRef(superClass.asString(), "<init>", "(Lcom/odi/ClassInfo;)V")));
        } else {
            insn = insn.append(Insn.create(183, pool.addMethodRef(superClass.asString(), "<init>", "()V")));
            if (ca.getNeedsHashCode()) {
                insn = insn.append(Insn.create(42));
                insn = insn.append(Insn.create(184, pool.addMethodRef("com/odi/util/HashPersistent", "getNextHashCode", "()I")));
                insn = insn.append(Insn.create(181, pool.addFieldRef(thisClass.asString(), ca.getHashCodeMember(), "I")));
            }
        }
        int stackMax = 2;
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), stackMax, 2, firstInsn, new ExceptionTable(), new AttributeVector()));
        return classInfoCtorMethod;
    }

    static ClassMethod makeClassInit(ClassAction ca, FilterEnv env) {
        InsnTarget firstInsn;
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod classInitMethod = new ClassMethod(8, pool.addUtf8("<clinit>"), pool.addUtf8("()V"), methodAttrs);
        Insn insn = firstInsn = new InsnTarget();
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 0, 0, firstInsn, new ExceptionTable(), new AttributeVector()));
        return classInitMethod;
    }

    static void buildClassInfoMember(ClassAction ca, FilterEnv env) {
        String memberName = ca.getClassInfoMember();
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        ClassField classInfoField = ca.classFile().findField(memberName);
        if (classInfoField != null) {
            if (!classInfoField.isStatic() || classInfoField.isFinal() || !classInfoField.signature().toString().equals("Lcom/odi/ClassInfo;")) {
                env.error("Member " + memberName + " of class " + ca.classControl().userClassName() + " must be static, non-final and of type com.odi.ClassInfo.");
            }
        } else {
            classInfoField = new ClassField(8, pool.addUtf8(memberName), pool.addUtf8("Lcom/odi/ClassInfo;"), new AttributeVector());
            ca.classFile().addField(classInfoField);
        }
    }

    static void registerClassInfo(ClassAction ca, ClassMethod clInit, Vector registerInfo, FilterEnv env) {
        InsnTarget newInsn;
        ClassFile cfile = ca.classFile();
        ConstantPool pool = cfile.pool();
        CodeAttribute codeAttr = clInit.codeAttribute();
        if (codeAttr == null) {
            throw new FilterError("Unable to find the code attribute");
        }
        Insn firstInsn = codeAttr.theCode();
        int minStack = 0;
        InsnTarget insn = newInsn = new InsnTarget();
        Enumeration e = registerInfo.elements();
        while (e.hasMoreElements()) {
            Object element = e.nextElement();
            int stackUsed = 0;
            if (element instanceof ClassAction) {
                stackUsed = MethodBuilder.buildRegisterClassInfo(insn, ca, (ClassAction)element);
            } else if (element instanceof FieldNote) {
                stackUsed = MethodBuilder.buildRegisterFieldNote(insn, ca, (FieldNote)element);
            } else {
                throw new FilterError("Unhandled register case: " + element);
            }
            if (stackUsed <= minStack) continue;
            minStack = stackUsed;
        }
        newInsn.append(firstInsn);
        codeAttr.setTheCode(newInsn);
        if (codeAttr.stackUsed() < minStack) {
            codeAttr.setStackUsed(minStack);
        }
    }

    private static int buildRegisterClassInfo(Insn insn, ClassAction ca, ClassAction regCa) {
        ClassFile cfile = ca.classFile();
        ConstantPool pool = cfile.pool();
        ConstClass thisClass = cfile.className();
        insn.append(Insn.create(184, pool.addMethodRef(thisClass.asString(), "getClassInfoInstance", "()Lcom/odi/ClassInfo;")));
        if (!cfile.isInterface() && ca == regCa) {
            insn.append(Insn.create(179, pool.addFieldRef(thisClass.asString(), ca.getClassInfoMember(), "Lcom/odi/ClassInfo;")));
        } else {
            insn.append(Insn.create(87));
        }
        return 1;
    }

    private static int buildRegisterFieldNote(Insn insn, ClassAction ca, FieldNote fieldNote) {
        ClassFile cfile = ca.classFile();
        ConstantPool pool = cfile.pool();
        String fieldName = fieldNote.getFieldAction().userFieldName();
        int stackUsed = 0;
        if (fieldNote.getNoteFieldTransient()) {
            insn.append(Insn.create(18, pool.addString(fieldName)));
            insn.append(Insn.create(184, pool.addMethodRef("com/odi/ClassInfo", "noteTransientField", "(Ljava/lang/String;)V")));
            stackUsed = 1;
        }
        if (fieldNote.getNoteFieldPersistent()) {
            insn.append(Insn.create(18, pool.addString(fieldName)));
            insn.append(Insn.create(184, pool.addMethodRef("com/odi/ClassInfo", "notePersistentField", "(Ljava/lang/String;)V")));
            stackUsed = 1;
        }
        if (fieldNote.getNoteFieldIndexable()) {
            insn.append(Insn.create(18, pool.addString(fieldName)));
            insn.append(Insn.create(184, pool.addMethodRef("com/odi/ClassInfo", "noteIndexableField", "(Ljava/lang/String;)V")));
        }
        return stackUsed;
    }

    static ClassMethod makeODIGetRef(ClassAction ca, FilterEnv env) {
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod ODIGetRefMethod = new ClassMethod(1, pool.addUtf8("ODIgetRef"), pool.addUtf8("()Lcom/odi/imp/ObjectReference;"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, pool.addFieldRef(thisClass.asString(), ca.getRefMember(), "Lcom/odi/imp/ObjectReference;")));
        insn = insn.append(Insn.create(176));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 1, 1, firstInsn, new ExceptionTable(), new AttributeVector()));
        return ODIGetRefMethod;
    }

    static ClassMethod makeODISetRef(ClassAction ca, FilterEnv env) {
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod ODISetRefMethod = new ClassMethod(1, pool.addUtf8("ODIsetRef"), pool.addUtf8("(Lcom/odi/imp/ObjectReference;)V"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(181, pool.addFieldRef(thisClass.asString(), ca.getRefMember(), "Lcom/odi/imp/ObjectReference;")));
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 2, 2, firstInsn, new ExceptionTable(), new AttributeVector()));
        return ODISetRefMethod;
    }

    static ClassMethod makeODIGetState(ClassAction ca, FilterEnv env) {
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod ODIGetStateMethod = new ClassMethod(1, pool.addUtf8("ODIgetState"), pool.addUtf8("()B"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, pool.addFieldRef(thisClass.asString(), ca.getObjectStateMember(), "B")));
        insn = insn.append(Insn.create(172));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 1, 1, firstInsn, new ExceptionTable(), new AttributeVector()));
        return ODIGetStateMethod;
    }

    static ClassMethod makeODISetState(ClassAction ca, FilterEnv env) {
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod ODISetStateMethod = new ClassMethod(1, pool.addUtf8("ODIsetState"), pool.addUtf8("(B)V"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(27));
        insn = insn.append(Insn.create(181, pool.addFieldRef(thisClass.asString(), ca.getObjectStateMember(), "B")));
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 2, 2, firstInsn, new ExceptionTable(), new AttributeVector()));
        return ODISetStateMethod;
    }

    static ClassMethod makeNullMethod(ClassAction ca, FilterEnv env, String methodName) {
        InsnTarget firstInsn;
        env.message("Modifying class " + ca.classControl().userClassName() + " to contain an empty " + methodName + " method.");
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod nullMethod = new ClassMethod(1, pool.addUtf8(methodName), pool.addUtf8("()V"), methodAttrs);
        Insn insn = firstInsn = new InsnTarget();
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 0, 1, firstInsn, new ExceptionTable(), new AttributeVector()));
        return nullMethod;
    }

    static ClassMethod makeHashCode(ClassAction ca, FilterEnv env) {
        ConstantPool pool = ca.classFile().pool();
        ConstClass thisClass = ca.classFile().className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod hashCodeMethod = new ClassMethod(1, pool.addUtf8("hashCode"), pool.addUtf8("()I"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        InsnTarget returnStart = new InsnTarget();
        insn = insn.append(Insn.create(42));
        if (ca.getObjectStateMember() != null) {
            insn = insn.append(Insn.create(180, pool.addFieldRef(thisClass.asString(), ca.getObjectStateMember(), "B")));
            insn = insn.append(Insn.create(156, returnStart));
        }
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(184, pool.addMethodRef("com/odi/ObjectStore", "fetch", "(Lcom/odi/IPersistent;)V")));
        insn = insn.append(returnStart);
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, pool.addFieldRef(thisClass.asString(), ca.getHashCodeMember(), "I")));
        insn = insn.append(Insn.create(172));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 1, 1, firstInsn, new ExceptionTable(), new AttributeVector()));
        return hashCodeMethod;
    }

    static ClassMethod makeODIComputeHashCode(ClassAction ca, FilterEnv env) {
        ClassFile cFile = ca.classFile();
        ConstantPool pool = cFile.pool();
        ConstClass thisClass = cFile.className();
        ConstClass superClass = cFile.superName();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod hashCodeMethod = new ClassMethod(2, pool.addUtf8("ODIComputeHashCode"), pool.addUtf8("()I"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(184, pool.addMethodRef("com/odi/util/HashPersistent", "getNextHashCode", "()I")));
        insn = insn.append(Insn.create(172));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 1, 1, firstInsn, new ExceptionTable(), new AttributeVector()));
        return hashCodeMethod;
    }

    static ClassMethod makeClone(ClassAction ca, FilterEnv env) {
        ClassFile cFile = ca.classFile();
        ConstantPool pool = cFile.pool();
        ConstClass thisClass = cFile.className();
        ConstClass superClass = cFile.superName();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod cloneMethod = new ClassMethod(36, pool.addUtf8("clone"), pool.addUtf8("()Ljava/lang/Object;"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        InsnTarget cloneStart = new InsnTarget();
        insn = insn.append(Insn.create(42));
        if (ca.getObjectStateMember() != null) {
            insn = insn.append(Insn.create(180, pool.addFieldRef(thisClass.asString(), ca.getObjectStateMember(), "B")));
            insn = insn.append(Insn.create(156, cloneStart));
        }
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(184, pool.addMethodRef("com/odi/ObjectStore", "fetch", "(Lcom/odi/IPersistent;)V")));
        insn = insn.append(cloneStart);
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(183, pool.addMethodRef(superClass.asString(), "clone", "()Ljava/lang/Object;")));
        insn = insn.append(Insn.create(192, thisClass));
        if (ca.getNeedsHashCode()) {
            insn = insn.append(Insn.create(89));
            insn = insn.append(Insn.create(89));
            insn = insn.append(Insn.create(183, pool.addMethodRef(thisClass.asString(), "ODIComputeHashCode", "()I")));
            insn = insn.append(Insn.create(181, pool.addFieldRef(thisClass.asString(), ca.getHashCodeMember(), "I")));
        }
        if (ca.getNeedsODIRefMethods()) {
            insn = insn.append(Insn.create(89));
            insn = insn.append(Insn.create(1));
            insn = insn.append(Insn.create(181, pool.addFieldRef(thisClass.asString(), ca.getRefMember(), "Lcom/odi/imp/ObjectReference;")));
        }
        if (ca.getNeedsODIStateMethods()) {
            insn = insn.append(Insn.create(89));
            insn = insn.append(Insn.create(3));
            insn = insn.append(Insn.create(181, pool.addFieldRef(thisClass.asString(), ca.getObjectStateMember(), "B")));
        }
        insn = insn.append(Insn.create(176));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 3, 2, firstInsn, new ExceptionTable(), new AttributeVector()));
        methodAttrs.addElement(new ExceptionsAttribute(pool.addUtf8("Exceptions"), pool.addClass("java/lang/CloneNotSupportedException")));
        return cloneMethod;
    }
}

