/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter.classfile;

import com.odi.filter.classfile.ClassPrint;
import com.odi.filter.classfile.CodeEnv;
import com.odi.filter.classfile.ConstClass;
import com.odi.filter.classfile.InsnTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class ExceptionRange {
    private InsnTarget excStartPC;
    private InsnTarget excEndPC;
    private InsnTarget excHandlerPC;
    private ConstClass excCatchType;

    public InsnTarget startPC() {
        return this.excStartPC;
    }

    public InsnTarget endPC() {
        return this.excEndPC;
    }

    public InsnTarget handlerPC() {
        return this.excHandlerPC;
    }

    public ConstClass catchType() {
        return this.excCatchType;
    }

    public ExceptionRange(InsnTarget startPC, InsnTarget endPC, InsnTarget handlerPC, ConstClass catchType) {
        this.excStartPC = startPC;
        this.excEndPC = endPC;
        this.excHandlerPC = handlerPC;
        this.excCatchType = catchType;
    }

    static ExceptionRange read(DataInputStream data, CodeEnv env) throws IOException {
        InsnTarget startPC = env.getTarget(data.readUnsignedShort());
        InsnTarget endPC = env.getTarget(data.readUnsignedShort());
        InsnTarget handlerPC = env.getTarget(data.readUnsignedShort());
        ConstClass catchType = (ConstClass)env.pool().constantAt(data.readUnsignedShort());
        return new ExceptionRange(startPC, endPC, handlerPC, catchType);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.excStartPC.offset());
        out.writeShort(this.excEndPC.offset());
        out.writeShort(this.excHandlerPC.offset());
        out.writeShort(this.excCatchType == null ? 0 : this.excCatchType.getIndex());
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.print("Exc Range:");
        if (this.excCatchType == null) {
            out.print("any");
        } else {
            out.print("'" + this.excCatchType.asString() + "'");
        }
        out.print(" start = " + Integer.toString(this.excStartPC.offset()));
        out.print(" end = " + Integer.toString(this.excEndPC.offset()));
        out.println(" handle = " + Integer.toString(this.excHandlerPC.offset()));
    }
}

