/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter.classfile;

import com.odi.filter.classfile.ClassPrint;
import com.odi.filter.classfile.Insn;
import com.odi.filter.classfile.InsnError;
import com.odi.filter.classfile.VMOp;
import java.io.PrintStream;

public class InsnIntOp
extends Insn {
    private int operandValue;

    @Override
    public int nStackArgs() {
        return VMOp.ops[this.opcode()].nStackArgs();
    }

    @Override
    public int nStackResults() {
        return VMOp.ops[this.opcode()].nStackResults();
    }

    @Override
    public String argTypes() {
        return VMOp.ops[this.opcode()].argTypes();
    }

    @Override
    public String resultTypes() {
        return VMOp.ops[this.opcode()].resultTypes();
    }

    @Override
    public boolean branches() {
        return this.opcode() == 169;
    }

    public int value() {
        return this.operandValue;
    }

    static String primType(int primIndex) {
        switch (primIndex) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
        }
        throw new InsnError("Invalid primitive type(" + primIndex + ")");
    }

    @Override
    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        if (this.opcode() == 188) {
            out.println(this.offset() + "  opc_newarray  " + InsnIntOp.primType(this.operandValue));
        } else {
            out.println(this.offset() + "  " + InsnIntOp.opName(this.opcode()) + "  " + this.operandValue);
        }
    }

    @Override
    int store(byte[] buf, int index) {
        if (this.size() == 4) {
            buf[index++] = -60;
        }
        buf[index++] = (byte)this.opcode();
        if (this.size() > 2) {
            buf[index++] = (byte)(this.operandValue >> 8);
        }
        buf[index++] = (byte)(this.operandValue & 0xFF);
        return index;
    }

    @Override
    int size() {
        switch (this.opcode()) {
            case 16: 
            case 188: {
                return 2;
            }
            case 17: {
                return 3;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                if (this.operandValue < 256) {
                    return 2;
                }
                return 4;
            }
        }
        throw new InsnError("invalid instruction " + InsnIntOp.opName(this.opcode()) + " with an integer operand");
    }

    InsnIntOp(int theOpcode, int theOperand, int pc) {
        super(theOpcode, pc);
        this.operandValue = theOperand;
    }

    InsnIntOp(int theOpcode, int theOperand) {
        super(theOpcode, -1);
        this.operandValue = theOperand;
        switch (theOpcode) {
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: 
            case 188: {
                break;
            }
            default: {
                throw new InsnError("attempt to create an " + InsnIntOp.opName(theOpcode) + " with an integer operand");
            }
        }
    }
}

