/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import java.lang.reflect.Array;
import java.util.Hashtable;

public final class ByteArrayClassLoader
extends ClassLoader {
    private static Hashtable classnameToClass = new Hashtable();

    public ByteArrayClassLoader() {
        super(ByteArrayClassLoader.class.getClassLoader());
    }

    public Class addClass(String classname, byte[] data) {
        Class<?> theClass = (Class<?>)classnameToClass.get(classname);
        if (theClass == null) {
            theClass = this.defineClass(classname, data, 0, data.length);
            this.resolveClass(theClass);
            classnameToClass.put(classname, theClass);
        }
        return theClass;
    }

    protected Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = (Class<?>)classnameToClass.get(classname);
        if (cl == null) {
            cl = this.loadArrayClass(classname);
        }
        if (cl == null) {
            cl = this.findLoadedClass(classname);
        }
        if (cl == null) {
            cl = this.findSystemClass(classname);
        }
        if (cl == null) {
            throw new ClassNotFoundException(classname);
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    private Class loadArrayClass(String classname) {
        if (!classname.startsWith("[")) {
            return null;
        }
        int dims = classname.indexOf("L");
        String elementTypeName = classname.substring(dims + 1, classname.length() - 1);
        Class elementType = (Class)classnameToClass.get(elementTypeName);
        if (elementType == null) {
            return null;
        }
        int[] dimensions = new int[dims];
        for (int i = 0; i < dims; ++i) {
            dimensions[i] = 1;
        }
        Class<?> c = Array.newInstance(elementType, dimensions).getClass();
        classnameToClass.put(classname, c);
        return c;
    }
}

