/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.Segment;
import com.odi.SegmentNotFoundException;
import com.odi.StaleEnumeratorException;
import com.odi.imp.Database;
import com.odi.imp.ObjectManager;
import com.odi.imp.Transaction;
import java.util.NoSuchElementException;

public class DatabaseSegmentEnumeration
extends com.odi.DatabaseSegmentEnumeration {
    private ObjectManager om;
    private Database database;
    private int[] segids;
    private int current = 0;
    private Transaction txn = (Transaction)Transaction.current();
    private Segment seg;

    public DatabaseSegmentEnumeration(ObjectManager om, Database database, int[] segids) {
        this.om = om;
        this.database = database;
        this.segids = segids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMoreElements() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            if (Transaction.current() != this.txn) {
                throw new StaleEnumeratorException("DatabaseSegmentEnumeration");
            }
            while (this.current < this.segids.length) {
                try {
                    this.seg = this.database.getSegment(this.segids[this.current]);
                    return true;
                }
                catch (SegmentNotFoundException segmentNotFoundException) {
                    ++this.current;
                }
            }
            return false;
        }
    }

    @Override
    public Object nextElement() {
        return this.nextSegment();
    }

    @Override
    public Segment nextSegment() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException("No more segments.");
        }
        ++this.current;
        return this.seg;
    }
}

