/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.imp.PoolElement;
import com.odi.imp.PoolElementFactory;

public class Pool {
    private static final int defaultPoolSizeLimit = 4096;
    private static final int defaultPoolObjectsLimit = 1024;
    private PoolElement[] table = new PoolElement[31];
    private int allocObjects = 0;
    private int inuseObjects = 0;
    int inuseBytes = 0;
    static int limit = Integer.getInteger("com.odi.Pool.limit", 4096);
    static int objectsLimit = Integer.getInteger("com.odi.Pool.objectsLimit", 1024);
    static boolean disableSoftAllocation = Boolean.getBoolean("com.odi.Pool.disableSoftAllocation");
    private int objects = 0;
    private int resize = 0;
    private PoolElementFactory peFactory = null;

    private static int log2(int size) {
        int i = 0;
        while ((size >>>= 1) != 0) {
            ++i;
        }
        return i;
    }

    private static int roundUpLogSize(int size) {
        int i = Pool.log2(size);
        if (1 << i == size) {
            return i;
        }
        return i + 1;
    }

    private static int roundDownLogSize(int size) {
        int i = Pool.log2(size);
        if (1 << i == size) {
            return i;
        }
        return i - 1;
    }

    public Pool(PoolElementFactory peFactory) {
        this.peFactory = peFactory;
    }

    public Pool(PoolElementFactory peFactory, int poolLimit, boolean disableSoftAllocation) {
        this.peFactory = peFactory;
        limit = poolLimit;
        Pool.disableSoftAllocation = disableSoftAllocation;
    }

    public synchronized PoolElement get(Object data, int size, boolean soft) {
        if (soft && disableSoftAllocation) {
            return null;
        }
        int index = Pool.roundUpLogSize(size);
        PoolElement pelt = this.table[index];
        if (soft && this.inuseObjects >= objectsLimit) {
            return null;
        }
        if (pelt == null) {
            if (soft && this.inuseBytes + size > limit) {
                return null;
            }
            pelt = this.peFactory.createObject(data);
            ++this.objects;
            pelt.initialize(1 << index);
        } else {
            this.table[index] = pelt.getNext();
            pelt.setAuxData(data);
        }
        pelt.setNext(null);
        pelt.setSize(size);
        this.inuseBytes += pelt.getSize();
        ++this.inuseObjects;
        ++this.allocObjects;
        return pelt;
    }

    public synchronized void ret(PoolElement pelt) {
        --this.inuseObjects;
        this.inuseBytes -= pelt.getSize();
        int i = Pool.roundDownLogSize(pelt.getSize());
        pelt.setNext(this.table[i]);
        this.table[i] = pelt;
    }

    synchronized void resize(PoolElement pelt, int size) {
        ++this.resize;
        PoolElement npelt = this.get(pelt.getAuxData(), size, false);
        byte[] nrep = npelt.getData();
        npelt.setData(pelt.getData());
        this.ret(npelt);
        pelt.setData(nrep);
    }

    public synchronized void clear() {
        this.inuseObjects = 0;
        this.inuseBytes = 0;
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
    }
}

