/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.ClassInfo;
import com.odi.ClassNotRegisteredException;
import com.odi.FatalInternalException;
import com.odi.Field;
import com.odi.IPersistent;
import com.odi.InvalidSummaryException;
import com.odi.ObjectNotPersistenceCapableException;
import com.odi.ObjectStoreException;
import com.odi.Persistent;
import com.odi.PersistentTypeSummary;
import com.odi.imp.ClassField;
import com.odi.imp.Database;
import com.odi.imp.ObjectReferencesEnumeration;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.imp.Server;
import com.odi.imp.SimpleHashtable;
import com.odi.imp.TypeCodeConstants;
import com.odi.imp.Utilities;
import com.odi.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public abstract class SchemaManager
implements TypeCodeConstants {
    private final SimpleHashtable AFTtoClassInfo = new SimpleHashtable(53);
    private final SimpleHashtable AVTtoAFN = new SimpleHashtable(31);
    private final Hashtable ClassInfoToAFT = new Hashtable(53);
    private final SimpleHashtable AFT_To_AVT = new SimpleHashtable(53);
    private static final Hashtable GTSToJavaClassNameMap = new Hashtable(11);
    private static final Hashtable JavaToGTSClassNameMap = new Hashtable(11);
    protected Server sv;
    private static final String[] typeEncodings = new String[]{null, "b", "l", "d", "f", "h", "m", "n", "k", "[]o", "J"};
    private static final int refMapEntryMask = -1073741824;
    private static final int lazyRefTypeEntryMask = -536870912;
    static final int dmaRefMapEntry = 0;
    static final int lazyRefMapEntry = Integer.MIN_VALUE;
    static final int arrayMapEntry = 0x40000000;

    protected SchemaManager() {
    }

    public final int getClassAFTypeCode(Class type) {
        if (type == Object.class) {
            return 100;
        }
        if (type == String.class) {
            return Utilities.getStringTypeCode();
        }
        if (type == Reference.class) {
            return 117 + ReferenceType.getEnumeratedValue(type);
        }
        if (IPersistent.class.isAssignableFrom(type)) {
            return this.getClassAFTypeCode(type.getName());
        }
        if (type.isArray()) {
            return this.getArrayClassAFTypeCode(type);
        }
        int typeCode = Utilities.getPrimitiveOrWrapperTypeCode(type);
        if (typeCode != 0) {
            return typeCode;
        }
        typeCode = Utilities.getBuiltinTypeCode(type);
        if (typeCode == 0) {
            throw new ClassNotRegisteredException(type.getName());
        }
        return typeCode;
    }

    public final int getClassAFTypeCode(String className) {
        ClassInfo classInfo = ClassInfo.get(className);
        int AFTypeCode = this.findAFTypeCode(classInfo);
        if (AFTypeCode != 0) {
            return AFTypeCode;
        }
        String classEncoding = this.getClassEncoding(classInfo, false);
        return this.noteAFTypeCode(this.serverAddClass(classEncoding), classInfo);
    }

    int getAFTypeCode(Object object) {
        if (object instanceof Reference) {
            return 117 + ((Reference)object).REFTYPE().getEnumeratedValue();
        }
        if (object instanceof IPersistent) {
            return this.getClassAFTypeCode(object.getClass().getName());
        }
        if (Utilities.isArray(object)) {
            return this.getArrayAFTypeCode(object);
        }
        if (object instanceof String) {
            return Utilities.getStringTypeCode();
        }
        if (Utilities.findPrimitiveWrapperInfo(object) != null) {
            return Utilities.findPrimitiveWrapperInfo((Object)object).wrapperTypeCode;
        }
        throw new ObjectNotPersistenceCapableException(object);
    }

    public int getDefaultAVTypeCode(int AFTC) {
        if (Utilities.isPrimitiveOrWrapperTypeCode(AFTC) || Utilities.isBuiltinTypeCode(AFTC) || Utilities.isArrayTypeCode(AFTC)) {
            return AFTC;
        }
        Integer AVTypeCode = (Integer)this.AFT_To_AVT.get(AFTC);
        if (AVTypeCode == null) {
            this.noteAFTypeCode(AFTC);
            AVTypeCode = new Integer(this.serverGetAVTypeCode(AFTC));
            this.AFT_To_AVT.put(AFTC, AVTypeCode);
        }
        return AVTypeCode;
    }

    public BitSet getAFTSubClasses(Class baseClass, Database db) {
        if (baseClass.isArray()) {
            Class elementType;
            baseClass = elementType = Utilities.getArrayClassElementType(baseClass);
        }
        int baseAFT = 0;
        if (!baseClass.isInterface()) {
            baseAFT = this.getClassAFTypeCode(baseClass);
        }
        Class[] allClasses = this.getSchemaClasses(db);
        BitSet AFTs = new BitSet(200 + allClasses.length + 1);
        AFTs.clear(200 + allClasses.length + 1);
        if (baseClass == String.class) {
            int elementTypeCode = Utilities.arrayElementTypeCode(Utilities.getStringTypeCode());
            AFTs.set(elementTypeCode);
            return AFTs;
        }
        if (!baseClass.isInterface()) {
            if (Utilities.isPrimitiveTypeCode(baseAFT)) {
                return AFTs;
            }
            if (Utilities.isWrapperTypeCode(baseAFT)) {
                AFTs.set(baseAFT);
                return AFTs;
            }
            if (Utilities.isBuiltinTypeCode(baseAFT)) {
                AFTs.set(baseAFT);
                return AFTs;
            }
        }
        for (int i = 0; i < allClasses.length; ++i) {
            if (allClasses[i] == null || allClasses[i].isInterface() || !baseClass.isAssignableFrom(allClasses[i])) continue;
            AFTs.set(this.getClassAFTypeCode(allClasses[i]));
        }
        return AFTs;
    }

    private Class[] getSchemaClasses(Database db) {
        String[] classNames = db.serverGetSchemaClasses();
        int classIndex = 0;
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            try {
                classes[classIndex] = Utilities.findClass(classNames[i]);
                ++classIndex;
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return classes;
    }

    public void extendAFTSubClasses(Class baseClass, BitSet AFTs, Database db) {
        if (baseClass.isArray()) {
            Class elementType;
            baseClass = elementType = Utilities.getArrayClassElementType(baseClass);
        }
        Class[] allClasses = this.getSchemaClasses(db);
        for (int i = 0; i < allClasses.length; ++i) {
            if (allClasses[i] == null || allClasses[i].isInterface()) continue;
            int newAFTC = this.getClassAFTypeCode(allClasses[i]);
            if (!baseClass.isAssignableFrom(allClasses[i])) continue;
            AFTs.set(newAFTC);
        }
    }

    public int[] getAFTSizes(BitSet AFTs) {
        if (!this.sv.needObjectSizeForGetObjects()) {
            return null;
        }
        int[] copy = new int[AFTs.length()];
        int next = 0;
        for (int aftc = 1; aftc <= AFTs.length(); ++aftc) {
            int size;
            if (!AFTs.get(aftc) || this.containsSize(copy, size = this.linearRepSize(aftc, 1))) continue;
            copy[next++] = size;
        }
        int[] sizes = new int[next];
        System.arraycopy(copy, 0, sizes, 0, next);
        return sizes;
    }

    private boolean containsSize(int[] sizes, int size) {
        int max = sizes.length;
        for (int i = 0; i < max; ++i) {
            if (sizes[i] != size) continue;
            return true;
        }
        return false;
    }

    private int getArrayClassAFTypeCode(Class array) {
        Class elementType = Utilities.getArrayClassElementType(array);
        int elementTypeCode = Utilities.getPrimitiveOrWrapperTypeCode(elementType);
        if (elementTypeCode == 0) {
            elementTypeCode = elementType == Utilities.javaLangObjectType ? 100 : (elementType == Utilities.COModiPersistentType ? 101 : (elementType == Reference.class ? 117 + ReferenceType.getEnumeratedValue(elementType) : this.getClassAFTypeCode(elementType.getName())));
        }
        int dimensions = Utilities.getArrayClassDimensions(array);
        return Utilities.makeArrayTypeCode(dimensions, elementTypeCode);
    }

    private int getArrayAFTypeCode(Object array) {
        return this.getArrayClassAFTypeCode(array.getClass());
    }

    protected ClassInfo getClassInfo(int AFTypeCode) {
        ClassInfo classInfo = (ClassInfo)this.AFTtoClassInfo.get(AFTypeCode);
        if (classInfo == null) {
            this.noteAFTypeCode(AFTypeCode);
            if (this.AFTtoClassInfo.get(AFTypeCode) == null) {
                throw new FatalInternalException("AFTypeCode: " + AFTypeCode + " still missing.");
            }
            return this.getClassInfo(AFTypeCode);
        }
        return classInfo;
    }

    protected Class getClassDescriptor(int AFTypeCode) throws ClassNotFoundException {
        if (Utilities.isArrayTypeCode(AFTypeCode)) {
            return null;
        }
        switch (AFTypeCode) {
            case 2: {
                return Byte.TYPE;
            }
            case 12: {
                return Character.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 6: {
                return Integer.TYPE;
            }
            case 8: {
                return Long.TYPE;
            }
            case 13: {
                return Float.TYPE;
            }
            case 14: {
                return Double.TYPE;
            }
            case 11: {
                return Boolean.TYPE;
            }
            case 15: {
                throw new FatalInternalException("A utf8 family type code  can only appear in array contexts");
            }
            case 100: {
                return Object.class;
            }
            case 101: {
                return Persistent.class;
            }
            case 112: {
                return Boolean.class;
            }
            case 103: {
                return Byte.class;
            }
            case 113: {
                return Character.class;
            }
            case 105: {
                return Short.class;
            }
            case 107: {
                return Integer.class;
            }
            case 109: {
                return Long.class;
            }
            case 114: {
                return Float.class;
            }
            case 115: {
                return Double.class;
            }
        }
        return this.getClassInfo(AFTypeCode).getClassDescriptor();
    }

    public int linearRepSize(int AFTypeCode, int elementCount) {
        int size = 0;
        if (Utilities.isReferenceTypeCode(AFTypeCode)) {
            size = Utilities.referenceLinearRepSize(AFTypeCode);
        } else if (Utilities.isPrimitiveOrWrapperTypeCode(AFTypeCode)) {
            size = Utilities.primitiveLinearRepSize(AFTypeCode);
        } else if (Utilities.isArrayTypeCode(AFTypeCode)) {
            int elementTypeCode = Utilities.arrayElementTypeCode(AFTypeCode);
            size = Utilities.isPrimitiveTypeCode(elementTypeCode) && Utilities.arrayDimensions(AFTypeCode) == 1 ? this.linearRepSize(elementTypeCode, 0) : (int)this.sv.om.objectAccess.referenceSize;
        } else if (Utilities.isBuiltinTypeCode(AFTypeCode)) {
            byte refSize = this.sv.om.objectAccess.referenceSize;
            size = Utilities.builtinLinearRepSize(AFTypeCode, refSize);
        } else {
            int[] map = this.getMappingTable(AFTypeCode);
            size = map[0];
        }
        return size * (Utilities.isArrayTypeCode(AFTypeCode) ? elementCount : 1);
    }

    public int noteAFTypeCode(int AFTypeCode) {
        if (Utilities.isPrimitiveOrWrapperTypeCode(AFTypeCode)) {
            return AFTypeCode;
        }
        if (Utilities.isArrayTypeCode(AFTypeCode)) {
            int elementTypeCode = Utilities.arrayElementTypeCode(AFTypeCode);
            if (elementTypeCode == 100 || elementTypeCode == 101) {
                return AFTypeCode;
            }
            this.noteAFTypeCode(Utilities.arrayElementTypeCode(AFTypeCode));
            return AFTypeCode;
        }
        if (this.AFTtoClassInfo.get(AFTypeCode) != null) {
            return AFTypeCode;
        }
        if (Utilities.isBuiltinTypeCode(AFTypeCode)) {
            String typeName = Utilities.getBuiltinTypeName(AFTypeCode);
            this.noteAFTypeCode(AFTypeCode, ClassInfo.get(typeName));
            return AFTypeCode;
        }
        String GTSClassName = this.serverGetGTSClassName(AFTypeCode);
        return this.getClassAFTypeCode(SchemaManager.getJavaClassName(GTSClassName));
    }

    public String getTypeName(int AFTypeCode) {
        String typeName = Utilities.getPredefinedAFTName(AFTypeCode);
        if (typeName != null) {
            return typeName;
        }
        ClassInfo info = (ClassInfo)this.AFTtoClassInfo.get(AFTypeCode);
        if (info != null) {
            Class cl = null;
            try {
                cl = info.getClassDescriptor();
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (cl != null) {
                return cl.getName();
            }
        }
        String GTSClassName = this.serverGetGTSClassName(AFTypeCode);
        return SchemaManager.getJavaClassName(GTSClassName);
    }

    int[] getMappingTable(int AFTypeCode) {
        if (Utilities.isPrimitiveOrWrapperTypeCode(AFTypeCode) || Utilities.isArrayTypeCode(AFTypeCode)) {
            return null;
        }
        int[] AFNtable = (int[])this.AVTtoAFN.get(AFTypeCode);
        if (AFNtable != null) {
            return AFNtable;
        }
        AFNtable = this.serverGetMappingTable(AFTypeCode);
        this.AVTtoAFN.put(AFTypeCode, AFNtable);
        this.noteAFTypeCode(AFTypeCode);
        ((ClassInfo)this.AFTtoClassInfo.get(AFTypeCode)).initialize();
        return AFNtable;
    }

    private final int findAFTypeCode(ClassInfo classInfo) {
        Integer AFTypeCode = (Integer)this.ClassInfoToAFT.get(classInfo);
        return AFTypeCode == null ? 0 : AFTypeCode;
    }

    private final int noteAFTypeCode(int AFTypeCode, ClassInfo classInfo) {
        this.ClassInfoToAFT.put(classInfo, new Integer(AFTypeCode));
        this.AFTtoClassInfo.put(AFTypeCode, classInfo);
        return AFTypeCode;
    }

    public static boolean isPredefinedSuperClass(String superName) {
        return superName.equals("com.odi.Persistent") || superName.equals("com.odi.util.DynamicPersistent") || superName.equals("java.lang.Object");
    }

    protected String getClassEncoding(ClassInfo classInfo, boolean computeEncodingOnly) {
        StringBuffer buffer = new StringBuffer(200);
        Class cl = null;
        try {
            cl = classInfo.getClassDescriptor();
        }
        catch (ClassNotFoundException e) {
            throw new FatalInternalException(e.getMessage());
        }
        String GTSClassName = SchemaManager.getGTSClassName(cl.getName());
        if (cl.isInterface()) {
            buffer.append('S').append(GTSClassName).append(";");
        } else {
            Field[] fields;
            buffer.append('C').append(GTSClassName).append(";{");
            String superName = cl.getSuperclass().getName();
            if (!SchemaManager.isPredefinedSuperClass(superName)) {
                if (!computeEncodingOnly) {
                    this.getClassAFTypeCode(superName);
                }
                buffer.append('B').append(SchemaManager.getGTSClassName(superName)).append(';');
            }
            if ((fields = classInfo.getFields()) != null) {
                for (int i = 0; i < fields.length; ++i) {
                    ClassField cf;
                    com.odi.imp.Field f = (com.odi.imp.Field)fields[i];
                    f.encode(buffer, computeEncodingOnly);
                    if (!(f instanceof ClassField) || !(cf = (ClassField)f).isEmbedded()) continue;
                    this.getClassAFTypeCode(cf.getTypeName());
                }
            }
            buffer.append('}');
        }
        return buffer.toString();
    }

    static void encodeClassType(String className, StringBuffer buffer, boolean computeEncodingOnly) {
        if (className.equals("java.lang.Object") || className.equals("java.lang.Long") || className.equals("java.lang.Double") || className.equals("java.lang.Number")) {
            buffer.append('O');
        } else if (className.equals("com.odi.Persistent")) {
            buffer.append('P');
        } else if (className.equals("java.lang.Boolean")) {
            buffer.append("Wk");
        } else if (className.equals("java.lang.Byte")) {
            buffer.append("Wb");
        } else if (className.equals("java.lang.Short")) {
            buffer.append("Wd");
        } else if (className.equals("java.lang.Character")) {
            buffer.append("Wl");
        } else if (className.equals("java.lang.Integer")) {
            buffer.append("Wf");
        } else if (className.equals("java.lang.Float")) {
            buffer.append("Wm");
        } else if (className.equals("com.odi.jcpp.CPlusPlus")) {
            buffer.append('Q');
        } else {
            if (!className.equals("java.lang.String") && !computeEncodingOnly) {
                ClassInfo.get(className);
            }
            String GTSClassName = SchemaManager.getGTSClassName(className);
            buffer.append('T').append(GTSClassName).append(';');
        }
    }

    static void encodePrimitiveType(byte primType, StringBuffer buffer) {
        buffer.append(SchemaManager.getTypeEncoding(primType));
    }

    private static final String getTypeEncoding(byte primType) {
        if (primType >= 10) {
            char enc = (char)(74 + (byte)(primType - 10));
            return "" + enc;
        }
        return typeEncodings[primType];
    }

    protected static final boolean isRefTypeChar(char typeChar) {
        char typeCharAsInt = typeChar;
        char start = 'J';
        return typeCharAsInt >= start && typeCharAsInt <= start + 4;
    }

    protected static final ReferenceType getRefType(char typeChar) {
        if (!SchemaManager.isRefTypeChar(typeChar)) {
            throw new FatalInternalException("invalid ref type " + typeChar);
        }
        return ReferenceType.getReferenceType(typeChar - 74);
    }

    static void encodeInterfaceType(String interfaceName, StringBuffer buffer) {
        buffer.append('S').append(interfaceName).append(';');
    }

    protected void discardSchemaCache() {
        this.AFTtoClassInfo.clear();
        this.AVTtoAFN.clear();
        this.ClassInfoToAFT.clear();
        this.AFT_To_AVT.clear();
    }

    private static void JavaGTSClassMapChecks(String JavaName, String GTSName) {
        Object existingJavaName = GTSToJavaClassNameMap.get(GTSName);
        Object existingGTSName = JavaToGTSClassNameMap.get(JavaName);
        if (existingJavaName == null && existingGTSName == null) {
            return;
        }
        if (existingJavaName != null && existingGTSName != null && existingJavaName.equals(JavaName) && existingGTSName.equals(GTSName)) {
            return;
        }
        if (existingJavaName != null) {
            throw new ObjectStoreException("There exists an incompatible mapping from the name \"" + GTSName + "\" to the Java class name \"" + existingJavaName + "\".");
        }
        if (existingGTSName != null) {
            throw new ObjectStoreException("There exists an incompatible mapping from the Java class name \"" + JavaName + "\" to the name \"" + existingGTSName + "\".");
        }
    }

    public static synchronized void enterJavaGTSClassMapEntry(String JavaName, String GTSName) {
        SchemaManager.JavaGTSClassMapChecks(JavaName, GTSName);
        JavaToGTSClassNameMap.put(JavaName, GTSName);
        GTSToJavaClassNameMap.put(GTSName, JavaName);
    }

    public static synchronized void removeJavaGTSClassMapEntry(String JavaName, String GTSName) {
        SchemaManager.JavaGTSClassMapChecks(JavaName, GTSName);
        JavaToGTSClassNameMap.remove(JavaName);
        GTSToJavaClassNameMap.remove(GTSName);
    }

    public static String getJavaClassName(String GTSName) {
        String JavaClassName = (String)GTSToJavaClassNameMap.get(GTSName);
        return JavaClassName == null ? GTSName : JavaClassName;
    }

    public static String getGTSClassName(String JavaName) {
        String GTSClassName = (String)JavaToGTSClassNameMap.get(JavaName);
        return GTSClassName == null ? JavaName : GTSClassName;
    }

    public static void clearJavaGTSClassMapEntries() {
        GTSToJavaClassNameMap.clear();
        JavaToGTSClassNameMap.clear();
    }

    protected abstract int serverGetAVTypeCode(int var1);

    protected abstract String serverGetGTSClassName(int var1);

    protected abstract int serverAddClass(String var1);

    protected abstract int[] serverGetMappingTable(int var1);

    protected abstract int[] getReferenceMap(int var1);

    public ObjectReferencesEnumeration getObjectReferencesEnumeration(int AFTypeCode, int arrayElementCount) {
        if (Utilities.isArrayTypeCode(AFTypeCode)) {
            int arrayElementTypeCode = Utilities.arrayElementTypeCode(AFTypeCode);
            if (arrayElementCount == 0 || Utilities.isPrimitiveTypeCode(arrayElementTypeCode) && Utilities.arrayDimensions(AFTypeCode) == 1) {
                return null;
            }
            return new ArrayObjectReferencesEnumeration(AFTypeCode, arrayElementCount);
        }
        if (Utilities.isPrimitiveOrWrapperTypeCode(AFTypeCode)) {
            return null;
        }
        return new SingletonObjectReferencesEnumeration(AFTypeCode);
    }

    protected abstract void commitTransaction();

    static String[] closeOverTypeSummary(PersistentTypeSummary summary) {
        Hashtable classMap = new Hashtable();
        SchemaManager.closeOverTypeSummary(summary, classMap, new Hashtable());
        String[] result = new String[classMap.size()];
        int index = 0;
        Enumeration classNames = classMap.keys();
        while (classNames.hasMoreElements()) {
            result[index++] = (String)classNames.nextElement();
        }
        return result;
    }

    private static final void closeOverTypeSummary(PersistentTypeSummary summary, Hashtable classMap, Hashtable summaryMap) {
        String[] summaries;
        String[] classes = summary.getPersistentClasses();
        if (classes != null) {
            for (int i = 0; i < classes.length; ++i) {
                if (classMap.get(classes[i]) != null) continue;
                ClassInfo cinfo = ClassInfo.get(classes[i]);
                classMap.put(classes[i], cinfo);
            }
        }
        if ((summaries = summary.getIncludedLibrarySummaries()) != null) {
            for (int i = 0; i < summaries.length; ++i) {
                String summaryName = summaries[i];
                if (summaryMap.get(summaryName) != null) continue;
                PersistentTypeSummary newSummary = null;
                Class<?> summaryClass = null;
                try {
                    summaryClass = Class.forName(summaryName);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new InvalidSummaryException(summaryName, cnfe.getMessage());
                }
                try {
                    newSummary = (PersistentTypeSummary)summaryClass.newInstance();
                }
                catch (InstantiationException ie) {
                    throw new InvalidSummaryException(summaryName, ie.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new InvalidSummaryException(summaryName, iae.getMessage());
                }
                catch (ClassCastException cce) {
                    throw new InvalidSummaryException(summaryName, cce.getMessage());
                }
                summaryMap.put(summaryName, newSummary);
                SchemaManager.closeOverTypeSummary(newSummary, classMap, summaryMap);
            }
        }
    }

    protected void adjustMapsForDeleteClass(int oldAFT) {
        int oldAVT = this.getDefaultAVTypeCode(oldAFT);
        ClassInfo oldCI = (ClassInfo)this.AFTtoClassInfo.get(oldAFT);
        this.ClassInfoToAFT.remove(oldCI);
        this.AFTtoClassInfo.remove(oldAFT);
        this.AVTtoAFN.remove(oldAVT);
        this.AFT_To_AVT.remove(oldAFT);
    }

    protected void adjustMapsForClassBecome(int oldAFT, int newAFT) {
        ClassInfo oldCI = (ClassInfo)this.AFTtoClassInfo.get(oldAFT);
        ClassInfo newCI = (ClassInfo)this.AFTtoClassInfo.get(newAFT);
        this.AFTtoClassInfo.put(oldAFT, newCI);
        this.AFTtoClassInfo.remove(newAFT);
        this.ClassInfoToAFT.put(newCI, new Integer(oldAFT));
        int[] newAFN = (int[])this.AVTtoAFN.get(newAFT);
        this.AVTtoAFN.put(oldAFT, newAFN);
        this.AVTtoAFN.remove(newAFT);
        this.AFT_To_AVT.remove(newAFT);
    }

    static int getReferenceType(int offset) {
        int type = offset & 0xC0000000;
        return (type & Integer.MIN_VALUE) == 0 ? type : Integer.MIN_VALUE;
    }

    static int getLazyReferenceOffset(int offset) {
        return offset & 0x1FFFFFFF;
    }

    static int getArrayElementCount(int offset) {
        return offset & 0x3FFFFFFF;
    }

    public static int makeLazyRefMapEntry(int offset, ReferenceType refType) {
        int enumVal = refType.getEnumeratedValue();
        int value = enumVal - 1 << 29 & 0xE0000000 | Integer.MIN_VALUE;
        return value | offset;
    }

    public static int extractLazyRefType(int entry) {
        return ((entry & 0xE0000000 & Integer.MAX_VALUE) >>> 29) + 1;
    }

    public static int makeArrayMapEntry(int elementCount) {
        return 0x40000000 | elementCount;
    }

    class ArrayObjectReferencesEnumeration
    implements ObjectReferencesEnumeration {
        private int arraySize;
        private int refSize;
        private int index = 0;
        private int elementsRefType;
        private int elementsLazyRefType;

        ArrayObjectReferencesEnumeration(int elementAFTypeCode, int arrayElementCount) {
            this.initialize(elementAFTypeCode, arrayElementCount);
        }

        @Override
        public final boolean hasMoreElements() {
            return this.index < this.arraySize;
        }

        @Override
        public final int nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more object references.");
            }
            int result = this.index;
            this.index += this.refSize;
            return result;
        }

        @Override
        public final boolean isLazyRef() {
            return this.elementsRefType == Integer.MIN_VALUE;
        }

        @Override
        public ReferenceType getLazyRefType() {
            return ReferenceType.getReferenceType(this.elementsLazyRefType);
        }

        @Override
        public final void reset() {
            this.index = 0;
        }

        @Override
        public final void initialize(int elementAFTypeCode, int arrayElementCount) {
            if (elementAFTypeCode >= 117 && elementAFTypeCode <= 121) {
                this.elementsRefType = Integer.MIN_VALUE;
                this.elementsLazyRefType = elementAFTypeCode - 117;
                this.refSize = ReferenceType.getReferenceType(this.elementsLazyRefType).size();
            } else {
                this.elementsRefType = 0;
                this.refSize = SchemaManager.this.sv.om.objectAccess.referenceSize;
            }
            this.arraySize = arrayElementCount == Integer.MAX_VALUE ? arrayElementCount : arrayElementCount * this.refSize;
        }
    }

    class SingletonObjectReferencesEnumeration
    implements ObjectReferencesEnumeration {
        private int[] refMap;
        private int index;
        private int refType;
        private int lazyRefType = -1;
        private int pendingArrayCount;
        private int arrayElementOffset;
        private int referenceSize;

        SingletonObjectReferencesEnumeration(int AFTypeCode) {
            this.initialize(AFTypeCode, 0);
        }

        @Override
        public void initialize(int AFTypeCode, int ignoreArrayElementCount) {
            this.refMap = SchemaManager.this.getReferenceMap(AFTypeCode);
            this.index = 0;
            this.pendingArrayCount = 0;
            this.lazyRefType = -1;
        }

        @Override
        public void reset() {
            this.index = 0;
            this.pendingArrayCount = 0;
            this.lazyRefType = -1;
        }

        @Override
        public final boolean hasMoreElements() {
            return this.pendingArrayCount > 0 || this.index + 1 < this.refMap.length;
        }

        @Override
        public final int nextElement() {
            if (this.pendingArrayCount > 0) {
                --this.pendingArrayCount;
                this.arrayElementOffset += this.referenceSize;
                return this.arrayElementOffset;
            }
            if (++this.index == this.refMap.length) {
                throw new NoSuchElementException("no more elements in enumeration");
            }
            int entry = this.refMap[this.index];
            this.refType = SchemaManager.getReferenceType(entry);
            if (this.refType == Integer.MIN_VALUE) {
                this.lazyRefType = SchemaManager.extractLazyRefType(entry);
            }
            if (this.refType == 0) {
                return entry;
            }
            if (this.refType != 0x40000000) {
                return SchemaManager.getLazyReferenceOffset(entry);
            }
            this.pendingArrayCount = SchemaManager.getArrayElementCount(entry) - 1;
            entry = this.refMap[++this.index];
            this.refType = SchemaManager.getReferenceType(entry);
            if (this.refType == 0) {
                this.arrayElementOffset = entry;
                this.referenceSize = SchemaManager.this.sv.om.objectAccess.referenceSize;
            } else if (this.refType == Integer.MIN_VALUE) {
                this.lazyRefType = SchemaManager.extractLazyRefType(entry);
                this.arrayElementOffset = SchemaManager.getLazyReferenceOffset(entry);
                this.referenceSize = ReferenceType.getReferenceType(this.lazyRefType).size();
            } else {
                throw new FatalInternalException("Bad map offset entry:" + Integer.toHexString(entry) + ": unrecognized reference type:" + Integer.toHexString(this.refType));
            }
            return this.arrayElementOffset;
        }

        @Override
        public final boolean isLazyRef() {
            return this.refType == Integer.MIN_VALUE;
        }

        @Override
        public final ReferenceType getLazyRefType() {
            return ReferenceType.getReferenceType(this.lazyRefType);
        }
    }
}

