/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.Cluster;
import com.odi.ClusterNotFoundException;
import com.odi.Database;
import com.odi.DatabaseNotOpenException;
import com.odi.DatabaseOpenException;
import com.odi.SegmentException;
import com.odi.SegmentNotFoundException;
import com.odi.Session;
import com.odi.StaleIteratorException;
import com.odi.UpdateReadOnlyException;
import com.odi.imp.GenericObject;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.PersistentObjectIterator;
import com.odi.imp.SegmentObjectReferenceEnumeration;
import com.odi.imp.SimpleHashtable;
import com.odi.imp.Transaction;
import com.odi.imp.Utilities;
import com.odi.tools.Accumulator;
import com.odi.util.BitSet;
import com.odi.util.DynamicExtent;
import com.odi.util.query.Query;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;

public abstract class Segment
extends com.odi.Segment {
    protected final int segmentId;
    protected final com.odi.imp.Database database;
    protected final ObjectManager om;
    SimpleHashtable clusters = new SimpleHashtable(11);
    private boolean destroyed;
    private Transaction tx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(7);
            if (this.database.getOpenMode() != 7) {
                throw new UpdateReadOnlyException("Attempt to destroy a segment in a database that was open read-only.");
            }
            if (this.checkSegment()) {
                throw new SegmentException("Attempt to destroy an internal segment.");
            }
            this.om.forgetObjectsInSegment(this, true);
            this.serverDestroy();
            this.destroyed = true;
            this.tx = this.om.tx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            try {
                this.checkSegment();
                return false;
            }
            catch (SegmentNotFoundException segmentNotFoundException) {
                return true;
            }
        }
    }

    boolean isDestroyedInternal() {
        if (this.om.tx == this.tx && this.tx != null) {
            return this.destroyed;
        }
        return this.isDestroyed();
    }

    @Override
    public int getSegmentId() {
        return this.segmentId;
    }

    @Override
    public Database getDatabase() {
        if (!this.database.isOpen()) {
            throw new DatabaseNotOpenException(this.database);
        }
        return this.database;
    }

    com.odi.imp.Database getDatabaseInternal() {
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSizeInBytes() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            return this.serverGetSizeInBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInternal() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            return this.checkSegment();
        }
    }

    private boolean checkSegment() {
        if (this.destroyed) {
            if (this.om.tx == this.tx && this.tx != null) {
                throw new SegmentNotFoundException("The segment is destroyed.");
            }
            this.destroyed = false;
        }
        this.tx = this.om.tx;
        try {
            return this.database.serverCheckSegment(this.segmentId);
        }
        catch (SegmentNotFoundException e) {
            this.destroyed = true;
            throw e;
        }
    }

    protected Segment(com.odi.imp.Database database, int segmentId, ObjectManager om) {
        this.database = database;
        this.segmentId = segmentId;
        this.om = om;
    }

    @Override
    public com.odi.Segment getSegment() {
        return this;
    }

    @Override
    public Cluster getCluster() {
        return this.getDefaultCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cluster createCluster() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(7);
            com.odi.imp.Cluster clu = this.serverCreateNewCluster();
            this.clusters.put(clu.clusterId, clu);
            return clu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cluster getDefaultCluster() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            int clusterId = this.serverGetDefaultClusterId();
            com.odi.imp.Cluster cluster = (com.odi.imp.Cluster)this.clusters.get(clusterId);
            if (cluster == null) {
                cluster = this.serverCreateExistingCluster(clusterId);
                this.clusters.put(clusterId, cluster);
            }
            return cluster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultCluster(Cluster cluster) {
        if (cluster == null) {
            Utilities.throwNullArgumentException("Database", "setDefaultCluster", "cluster");
        }
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            if (cluster.getSegment() != this) {
                throw new IllegalArgumentException("Attempt to set the default cluster of segment:" + this.getSegmentId() + " to a cluster in segment:" + cluster.getSegment().getSegmentId());
            }
            this.serverSetDefaultClusterId(cluster.getClusterId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cluster getCluster(int clusterId) {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            return this.getClusterInternal(clusterId);
        }
    }

    public Cluster getClusterInternal(int clusterId) {
        this.serverCheckCluster(clusterId);
        return this.getClusterObject(clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Cluster getClusterObject(int clusterId) {
        ObjectManager objectManager = this.om;
        synchronized (objectManager) {
            com.odi.imp.Cluster cluster = (com.odi.imp.Cluster)this.clusters.get(clusterId);
            if (cluster == null) {
                cluster = this.serverCreateExistingCluster(clusterId);
                this.clusters.put(clusterId, cluster);
            }
            return cluster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getClusters() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            return new ClusterIterator(this.om, this, this.serverGetClusters());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clusterExists(int clusterId) {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            return this.serverClusterExists(clusterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession() {
        ObjectManager objectManager = this.om;
        synchronized (objectManager) {
            if (this.om.isActive()) {
                return this.om;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(PrintStream out) {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            SegmentObjectReferenceEnumeration references = new SegmentObjectReferenceEnumeration(this);
            boolean ok = true;
            while (references.hasMoreElements()) {
                ObjectReference objRef = references.nextElement();
                GenericObject genObj = GenericObject.allocate(this.om, objRef);
                genObj.fetch();
                if (!genObj.check(out)) {
                    ok = false;
                }
                genObj.deallocate();
            }
            return ok;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSeg(PrintStream out, boolean showObj, boolean showData, Query query) {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            Accumulator acc = new Accumulator();
            long sizeInBytes = this.getSizeInBytes();
            long sizeInKbytes = (sizeInBytes + 1023L) / 1024L;
            out.println("Segment: " + this.segmentId);
            out.println("Size: " + sizeInBytes + " (" + sizeInKbytes + " Kbytes)");
            if (showObj) {
                out.println();
                out.println("                                     Total      ");
                out.println("               OID    Elements       Bytes  Type");
                out.println("               ===    ========       =====  ====");
            }
            if (query != null) {
                DynamicExtent extent = new DynamicExtent(this, query.getElementType());
                Iterator iter = query.iterator(extent);
                while (iter.hasNext()) {
                    ObjectReference objRef = this.om.findObjRef(iter.next());
                    this.showObj(objRef, out, true, showData, acc);
                }
            } else {
                SegmentObjectReferenceEnumeration references = new SegmentObjectReferenceEnumeration(this);
                while (references.hasMoreElements()) {
                    ObjectReference objRef = references.nextElement();
                    this.showObj(objRef, out, showObj, showData, acc);
                }
            }
            out.println();
            acc.dump(out);
            out.println();
        }
    }

    private void showObj(ObjectReference objRef, PrintStream out, boolean showObj, boolean showData, Accumulator acc) {
        GenericObject genObj = GenericObject.allocate(this.om, objRef);
        genObj.fetch();
        genObj.showObj(objRef, out, acc, showObj, showData);
        genObj.deallocate();
    }

    @Override
    public Iterator getObjects() {
        return new PersistentObjectIterator(this);
    }

    @Override
    public Iterator getObjects(Class ofType) {
        if (ofType == null) {
            Utilities.throwNullArgumentException("Segment", "getObjects", "ofType");
        }
        return new PersistentObjectIterator(this, ofType);
    }

    @Override
    public Properties GC() {
        return this.GC(new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties GC(Properties GCProperties) {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            Transaction.assureNoTransaction();
            if (this.database.isOpen()) {
                throw new DatabaseOpenException(this.getDatabase());
            }
            return this.serverGC(GCProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLock(int lockType, int timeoutMillis) {
        ObjectManager.checkAcquireLockArguments(lockType, timeoutMillis, "Segment");
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(lockType);
            this.serverAcquireLock(lockType, timeoutMillis);
        }
    }

    public abstract void serverDestroy();

    public abstract long serverGetSizeInBytes();

    public abstract int serverGetDefaultClusterId();

    public abstract void serverSetDefaultClusterId(int var1);

    public abstract com.odi.imp.Cluster serverCreateNewCluster();

    public abstract com.odi.imp.Cluster serverCreateExistingCluster(int var1);

    public abstract void serverCheckCluster(int var1);

    public abstract boolean serverClusterExists(int var1);

    protected abstract int[] serverGetClusters();

    public abstract int serverGetObjects(byte[] var1, com.odi.imp.Cluster var2, ObjectReference var3);

    public abstract int serverGetObjects(byte[] var1, com.odi.imp.Cluster var2, ObjectReference var3, BitSet var4, int[] var5, boolean var6);

    public abstract int serverGetObjects(byte[] var1, ObjectReference var2);

    public abstract int serverGetObjects(byte[] var1, ObjectReference var2, BitSet var3, int[] var4, boolean var5);

    public int serverGetObjectsBufferSize() {
        return 1;
    }

    public abstract Properties serverGC(Properties var1);

    public abstract void serverAcquireLock(int var1, int var2);

    public abstract void getExportedObjectLocation(ObjectReference var1, long[] var2);

    public abstract int getExportedObjectId(ObjectReference var1);

    static class ClusterIterator
    implements Iterator {
        private ObjectManager om;
        private Segment segment;
        private int[] cluids;
        private int current;
        private Transaction txn;
        private Cluster clu;

        public ClusterIterator(ObjectManager om, Segment seg, int[] ids) {
            this.om = om;
            this.segment = seg;
            this.cluids = ids;
            this.current = 0;
            this.txn = (Transaction)Transaction.current();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ObjectManager objectManager = this.om.checkCurrent();
            synchronized (objectManager) {
                if (Transaction.current() != this.txn) {
                    throw new StaleIteratorException("Segment.getClusters");
                }
                while (this.current < this.cluids.length) {
                    try {
                        this.clu = this.segment.getCluster(this.cluids[this.current]);
                        return true;
                    }
                    catch (ClusterNotFoundException clusterNotFoundException) {
                        ++this.current;
                    }
                }
                return false;
            }
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next cluster in Segment.getClusters.");
            }
            ++this.current;
            return this.clu;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove clusters with Segment.getClusters().remove()");
        }
    }
}

