/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.Database;
import com.odi.DatabaseNotOpenException;
import com.odi.FatalInternalException;
import com.odi.Session;
import com.odi.imp.Cluster;
import com.odi.imp.DatabaseIdAndMode;
import com.odi.imp.GenericObject;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.imp.SimpleHashtable;
import com.odi.imp.Transaction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public abstract class Server {
    public ObjectManager om;
    private SimpleHashtable databases = new SimpleHashtable(11);
    private Hashtable pathNamesToDatabaseMap = new Hashtable(11);
    private DatabaseIdAndMode savedDatabaseIdAndMode = null;

    static Server create(ObjectManager om, String host, String name, int numExpectedSessions, boolean global) {
        String serverClassName = null;
        Class<?> serverClass = null;
        Server serverInstance = null;
        String storageImpl = System.getProperty("com.odi.storageImpl", "mtsonic");
        serverClassName = "com.odi.imp." + storageImpl + ".Server";
        try {
            serverClass = Class.forName(serverClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new FatalInternalException("PSE storageImpl Server class not found: " + serverClassName);
        }
        ReferenceType.DEFAULT = storageImpl.equals("sonic") || storageImpl.equals("mtsonic") ? ReferenceType.REF_8BYTE_LOCAL : ReferenceType.REF_4BYTE_LOCAL;
        try {
            serverInstance = (Server)serverClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new FatalInternalException("Couldn't create Server instance: " + ie);
        }
        catch (IllegalAccessException iae) {
            throw new FatalInternalException("Couldn't create Server instance: " + iae);
        }
        String product = om.getProperty("com.odi.product", "PSEPro");
        if (product.equalsIgnoreCase("PSEPro")) {
            om.product = 2;
            serverInstance.initialize(om, host, true, om.plist);
        } else if (product.equalsIgnoreCase("PSE")) {
            om.product = 1;
            serverInstance.initialize(om, host, false, om.plist);
        } else {
            throw new IllegalArgumentException("Invalid com.odi.product value: " + product);
        }
        return serverInstance;
    }

    void shutdown(Session sess) {
        this.serverShutdown(sess);
    }

    private DatabaseIdAndMode allocateDatabaseIdAndMode() {
        if (this.savedDatabaseIdAndMode != null) {
            return this.savedDatabaseIdAndMode;
        }
        return new DatabaseIdAndMode();
    }

    private void freeDatabaseIdAndMode(DatabaseIdAndMode diam) {
        this.savedDatabaseIdAndMode = diam;
    }

    com.odi.imp.Database createDatabase(String pathname, int fileMode, HashMap parameters, int schemaInstallMode) {
        int databaseId = this.serverCreateDatabase(pathname, fileMode, parameters, schemaInstallMode);
        com.odi.imp.Database db = (com.odi.imp.Database)this.databases.get(databaseId);
        if (db != null) {
            db.setOpenModeInternal(7);
        } else {
            db = this.makeDatabase(databaseId, pathname, 7, this.om);
            this.databases.put(databaseId, db);
            this.pathNamesToDatabaseMap.put(db.getPath(), db);
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    com.odi.imp.Database openDatabase(String pathname, int openMode, HashMap parameters) {
        DatabaseIdAndMode diam = this.allocateDatabaseIdAndMode();
        com.odi.imp.Database db = null;
        try {
            boolean alreadyOpen = this.serverOpenDatabase(pathname, openMode, parameters, diam);
            db = this.getDatabase(diam.getDatabaseId(), pathname, diam.getOpenMode());
            db.alreadyOpen = alreadyOpen;
        }
        finally {
            this.freeDatabaseIdAndMode(diam);
        }
        return db;
    }

    com.odi.imp.Database lookupDatabase(int databaseId) {
        return (com.odi.imp.Database)this.databases.get(databaseId);
    }

    com.odi.imp.Database getOpenDatabase(String pathName) {
        com.odi.imp.Database db = (com.odi.imp.Database)this.pathNamesToDatabaseMap.get(pathName);
        if (db == null) {
            int databaseId = this.serverGetDatabaseId(pathName);
            db = (com.odi.imp.Database)this.databases.get(databaseId);
        }
        if (db == null || !db.isOpen()) {
            throw new DatabaseNotOpenException("The database " + pathName + " is not open in session:" + Session.getCurrent().getName());
        }
        this.pathNamesToDatabaseMap.put(pathName, db);
        return db;
    }

    private com.odi.imp.Database getDatabase(int databaseId, String pathname, int openMode) {
        com.odi.imp.Database db = (com.odi.imp.Database)this.databases.get(databaseId);
        if (db == null) {
            db = this.makeDatabase(databaseId, pathname, openMode, this.om);
            this.databases.put(databaseId, db);
            this.pathNamesToDatabaseMap.put(db.getPath(), db);
        }
        return db;
    }

    public com.odi.imp.Database getDatabase(int databaseId) {
        com.odi.imp.Database db = (com.odi.imp.Database)this.databases.get(databaseId);
        if (db == null) {
            String pathname = this.serverGetPathname(databaseId);
            db = this.makeDatabase(databaseId, pathname, 0, this.om);
            this.databases.put(db.getDatabaseId(), db);
            this.pathNamesToDatabaseMap.put(db.getPath(), db);
        }
        return db;
    }

    public ObjectAccess getObjectAccess() {
        return this.om.objectAccess;
    }

    public boolean needObjectSizeForGetObjects() {
        return false;
    }

    public abstract void initialize(ObjectManager var1, String var2, boolean var3, Properties var4);

    public abstract void initialize(ObjectManager var1, String var2, String var3, int var4, boolean var5, Properties var6);

    public abstract void serverShutdown(Session var1);

    public abstract com.odi.imp.Database makeDatabase(int var1, String var2, int var3, ObjectManager var4);

    public abstract Transaction makeTransaction(int var1);

    public abstract GenericObject makeGenericObject();

    public abstract int serverCreateDatabase(String var1, int var2, HashMap var3, int var4);

    public abstract boolean serverOpenDatabase(String var1, int var2, HashMap var3, DatabaseIdAndMode var4);

    public abstract int serverGetDatabaseId(String var1);

    public abstract ObjectReference serverCreateEmptyObject(Cluster var1, Object var2, int var3, int var4, int var5);

    public abstract void serverWriteLock(ObjectReference var1);

    public long serverGetStorageOffset(ObjectReference objRef) {
        return objRef.getLocation();
    }

    public abstract String serverGetPathname(int var1);

    public abstract byte[] serverGetExtRef(int var1, int var2, int var3, long var4);

    public abstract int serverGetAutoOpenMode();

    public abstract void serverSetAutoOpenMode(int var1);

    public abstract void serverAcquireLock(ObjectReference var1, int var2, int var3);

    protected abstract void validate(ObjectReference var1);

    public abstract void elaborateLazyReference(MutatingObjRef var1, boolean var2);

    public Reference getLazyReference(ObjectReference objRef, ReferenceType refType) {
        if (ObjRefUtils.isExportedForm(objRef)) {
            throw new FatalInternalException("Shouldn't be exported.");
        }
        return refType.getReference(objRef);
    }

    public abstract boolean leaveBarriersDownAcrossTransactions();

    public abstract boolean objectValid(ObjectReference var1);

    public abstract boolean supportsObjectCaching();

    public abstract boolean checkCachedObjectsValid();

    public abstract boolean checkCachedObjectValid(ObjectReference var1, long var2);

    public abstract void serverEvolveSchema(String var1, String var2);

    protected abstract int serverGetTransactionPriority();

    protected abstract void serverSetTransactionPriority(int var1);

    public abstract void serverInstanceBecome(ObjectReference var1, ObjectReference var2);

    public abstract void serverClassBecome(Hashtable var1);

    public abstract void serverRenameClass(String var1, String var2);

    public abstract void serverDeleteClass(String var1);

    public abstract void join();

    public abstract void leave();

    protected abstract void serverGetCounters(Properties var1, boolean var2);

    public Database getCurrentDatabase() {
        return null;
    }

    public abstract int getCacheSize();

    public abstract int getLockTimeout();

    public abstract void setLockTimeout(int var1);

    public abstract int getPageSize();
}

