/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.imp.Field;

public class StringField
extends Field {
    private boolean isEmbeddedField = false;
    private int maxEmbeddedLength;
    public static final int MAX_LENGTH = Short.MAX_VALUE;

    public StringField(String fieldName) {
        super(fieldName, (byte)9);
    }

    @Override
    public void encode(StringBuffer buffer, boolean computeEncodingOnly) {
        if (this.isEmbeddedField) {
            buffer.append('M').append(this.name).append(';');
            buffer.append("E[" + (this.maxEmbeddedLength + 1) + "]l");
        } else {
            super.encode(buffer, computeEncodingOnly);
        }
    }

    public int getMaxEmbeddedLength() {
        return this.maxEmbeddedLength;
    }

    @Override
    public com.odi.Field makeEmbedded(int maxEmbeddedLength) {
        if (maxEmbeddedLength <= 0) {
            throw new IllegalArgumentException("The embedded String field \"" + this.name + "\" must have a positive maximum length, not:" + maxEmbeddedLength);
        }
        if (this.isIndexable()) {
            throw new IllegalArgumentException("The embedded String field \"" + this.name + "\" cannot also be indexable.");
        }
        this.isEmbeddedField = true;
        if (maxEmbeddedLength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("string length:" + maxEmbeddedLength + " exceeds maximum:" + Short.MAX_VALUE + " for an embedded string.");
        }
        this.maxEmbeddedLength = maxEmbeddedLength;
        return this;
    }

    @Override
    public final boolean isEmbedded() {
        return this.isEmbeddedField;
    }
}

