/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.AbortException;
import com.odi.FatalException;
import com.odi.NoTransactionInProgressException;
import com.odi.ObjectStoreException;
import com.odi.Session;
import com.odi.TransactionInProgressException;
import com.odi.imp.ObjectManager;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public abstract class Transaction
extends com.odi.Transaction {
    private static final int OLD_READONLY = 1;
    private static final int OLD_UPDATE = 2;
    protected static final int ONEPHASE = 0;
    protected static final int PREPAREPHASE = 1;
    protected static final int FINALPHASE = 2;
    public int type;
    boolean aborted = false;
    private boolean abortInProgress = false;
    boolean commitOrCheckpointInProgress = false;
    protected boolean prepared = false;
    protected ObjectManager om;
    int foo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static com.odi.Transaction begin(int type) {
        ObjectManager om;
        if (type == 1) {
            type = 6;
        } else if (type == 2) {
            type = 7;
        }
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            om.assureActive("begin transaction in");
            if (om.tx != null) {
                throw new TransactionInProgressException(om.tx);
            }
            Transaction.checkTransactionType(type);
            Transaction tx = om.sv.makeTransaction(type);
            tx.beginInternal();
            return tx;
        }
    }

    private static void checkTransactionType(int type) {
        switch (type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid transaction type: " + type);
    }

    public void beginInternal() {
        try {
            this.serverBegin();
            this.om.begin(this, !this.om.sv.leaveBarriersDownAcrossTransactions());
            this.serverAfterBegin();
        }
        catch (ObjectStoreException OSE) {
            if (this.om.tx != null) {
                this.serverAbort();
                this.om.tx = null;
            }
            throw OSE;
        }
    }

    public static com.odi.Transaction current() {
        Transaction transaction = ObjectManager.assureCurrent().tx;
        if (transaction == null) {
            throw new NoTransactionInProgressException();
        }
        return transaction;
    }

    public static boolean inTransaction() {
        return Session.getCurrent() != null && ObjectManager.assureCurrent().tx != null;
    }

    @Override
    public void commit() {
        this.commitInternal(this.om.defaultCommitRetain);
    }

    @Override
    public void commit(int retainType) {
        ObjectManager.checkRetain(retainType, true, true);
        this.commitInternal(retainType);
    }

    void commitInternal(int retainType) {
        this.doCommitOrCheckpoint(retainType, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommitOrCheckpoint(int retainType, boolean checkpoint, int phase) {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.assureThisTransaction();
            this.foo = 0;
            try {
                this.commitOrCheckpointInProgress = true;
                if (checkpoint) {
                    this.om.commit(retainType);
                    this.serverCheckpoint();
                    this.om.finalizeCommit(retainType);
                    this.om.callAfterCompletionHandlers(true);
                    this.om.begin(this, checkpoint && retainType == 3 ? false : !this.om.sv.leaveBarriersDownAcrossTransactions());
                    this.serverAfterCheckpoint();
                } else {
                    this.doPhasedCommit(retainType, phase);
                    this.om.callAfterCompletionHandlers(true);
                }
            }
            catch (FatalException e) {
                throw e;
            }
            catch (AbortException e) {
                throw e;
            }
            catch (Exception e) {
                if (e.getClass().getName().equalsIgnoreCase("com.odi.xa.imp.InternalXAException")) {
                    throw (RuntimeException)e;
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(stream);
                e.printStackTrace(pw);
                pw.flush();
                throw new AbortException("An exception occurred during a " + (checkpoint ? "checkpoint.\n" : "commit.\n") + "Stack trace at point of original failure:\n" + "*****************************************\n" + stream + "*****************************************\n", e);
            }
            finally {
                if (phase == 1) {
                    this.prepared = true;
                } else {
                    this.prepared = false;
                    this.commitOrCheckpointInProgress = false;
                }
            }
        }
    }

    private void doPhasedCommit(int retainType, int phase) {
        boolean retainTransient;
        boolean bl = retainTransient = retainType == 5;
        if (retainTransient) {
            retainType = 4;
        }
        if (phase != 2) {
            this.om.commit(retainType);
        }
        boolean wasReadOnly = false;
        if (phase == 1) {
            wasReadOnly = this.serverPrepare();
        } else {
            this.serverCommit(phase == 0);
        }
        if (phase != 1 || wasReadOnly) {
            this.om.finalizeCommit(retainType);
            if (retainTransient) {
                this.om.forgetObjectsInDatabase(null, false, true);
            }
        }
    }

    @Override
    public void abort() {
        this.abort(this.om.defaultAbortRetain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(int retain) {
        if (this.abortInProgress) {
            return;
        }
        ObjectManager.checkRetain(retain, true, true);
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.assureThisTransaction();
            try {
                boolean retainTransient;
                this.abortInProgress = true;
                this.serverAbort();
                boolean bl = retainTransient = retain == 5;
                if (retainTransient) {
                    retain = 4;
                }
                this.om.abort(retain);
                if (retainTransient) {
                    this.om.forgetObjectsInDatabase(null, false, true);
                }
            }
            finally {
                this.om.callAfterCompletionHandlers(false);
                this.abortInProgress = false;
                this.aborted = true;
            }
        }
    }

    @Override
    public void checkpoint() {
        this.checkpoint(this.om.defaultCommitRetain);
    }

    @Override
    public void checkpoint(int retainType) {
        switch (retainType) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                Transaction transaction = this;
                if (transaction.om.whichProduct() != 3 || Boolean.valueOf(this.om.getProperty("com.odi.checkpointREADONLY", "false")).booleanValue()) break;
                retainType = 2;
                break;
            }
            case 4: 
            case 5: {
                retainType = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid retain argument to Transaction.checkpoint(): " + ObjectManager.retainTypeName(retainType));
            }
        }
        this.doCommitOrCheckpoint(retainType, true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultRetain(int newRetain) {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            ObjectManager.checkRetain(newRetain, true, true);
            om.defaultAbortRetain = newRetain;
            om.defaultCommitRetain = newRetain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultAbortRetain(int newRetain) {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            ObjectManager.checkRetain(newRetain, true, true);
            om.defaultAbortRetain = newRetain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultCommitRetain(int newRetain) {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            ObjectManager.checkRetain(newRetain, true, true);
            om.defaultCommitRetain = newRetain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getType() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.assureThisTransaction();
            return this.type;
        }
    }

    protected int getTypeInternal() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLockContention() {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            Transaction.assureTransaction();
            return om.tx.serverHasLockContention();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPriority() {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            return om.sv.serverGetTransactionPriority();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPriority(int priority) {
        ObjectManager om;
        if (priority < 0 || priority > 65535) {
            throw new IllegalArgumentException("Illegal priority argument to Transaction.setPriority: " + priority);
        }
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            om.sv.serverSetTransactionPriority(priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession() {
        ObjectManager objectManager = this.om;
        synchronized (objectManager) {
            if (this.om.isActive()) {
                return this.om;
            }
            return null;
        }
    }

    public abstract long getCurrentTransactionId();

    static void assureNoTransaction() {
        ObjectManager om = ObjectManager.assureCurrent();
        if (om.tx != null) {
            throw new TransactionInProgressException(om.tx);
        }
    }

    static void assureTransaction() {
        ObjectManager om = ObjectManager.assureCurrent();
        if (om.tx == null) {
            throw new NoTransactionInProgressException();
        }
    }

    void assureThisTransaction() {
        ObjectManager om = ObjectManager.assureCurrent();
        if (om.tx != this) {
            throw new NoTransactionInProgressException();
        }
    }

    public Transaction(int type, ObjectManager om) {
        this.type = type;
        this.om = om;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public boolean isActive() {
        return this.om.tx == this;
    }

    public boolean isPreparedButNotCommitted() {
        return this.prepared;
    }

    public abstract void serverBegin();

    public void serverAfterBegin() {
    }

    public abstract boolean serverPrepare();

    public abstract void serverCommit(boolean var1);

    public abstract void serverAbort();

    public abstract void serverCheckpoint();

    public void serverAfterCheckpoint() {
    }

    public abstract boolean serverHasLockContention();
}

